function viewWorkshopInvoiceApproval(WaccountsId, facultyId) {
    encodedValue_FaccountsId = btoa(WaccountsId);
    encodedValue_facultyId = btoa(facultyId);
    encodedKey_aId = btoa("aId");
    encodedKey_fId = btoa("fId");

    // window.location.href = "addPayment.php?aId=" + FaccountsId + "&fId=" + facultyId;
    window.location.href = "viewWorkshopInvoiceApproval.php?" + encodedKey_aId + "=" + encodedValue_FaccountsId + "&" + encodedKey_fId + "=" + encodedValue_facultyId;
}

function loaddata() {
    $.post('workshopApprovalDetails.php', {
        'facultyId': facultyId,
        'accountsId': accountsId,
    }, function (data) {
        document.getElementById('showData').innerHTML = data;
    });
}
function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function addPayment(FaccountsId, facultyId) {
    encodedValue_FaccountsId = btoa(FaccountsId);
    encodedValue_facultyId = btoa(facultyId);
    encodedKey_aId = btoa("aId");
    encodedKey_fId = btoa("fId");

    // window.location.href = "addPayment.php?aId=" + FaccountsId + "&fId=" + facultyId;
    window.location.href = "addWorkshopPayment.php?" + encodedKey_aId + "=" + encodedValue_FaccountsId + "&" + encodedKey_fId + "=" + encodedValue_facultyId;
}

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext.toUpperCase();
}

function loadDataDropdown(selectName, results) {
    console.log("loadddddd")
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "companyBankName") dummyOptions(theSelect, options, "BANK NAME");
    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");

        if (selectName.includes("companyBankName")) {
            options.value = results[i].accountNo.toUpperCase();
            options.text = results[i].bankName.toUpperCase();
            theSelect.add(options);
        }
        
    }
}

function loadAccountNo(element, f) {
    var text = element[element.selectedIndex].value.trim();
    if (text != 'SELECT BANK NAME') document.getElementById("companyBankAccountNo" + f).value = text;
    else document.getElementById("companyBankAccountNo" + f).value = '';
}
var amountPendingLater = '';
function calculate(element) {
    var tempPendingAmount = document.getElementById("facultyPendingAmount").value;
    var tempFinalAmount = document.getElementById("facultyFinalAmount").value;

    if (element.value == '') {
        showError(element.id, '#ff6666', "Amount Paid cannot be blank.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) == 0) {
        showError(element.id, '#ff6666', "Amount Paid cannot be zero.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) < 0) {
        showError(element.id, '#ff6666', "Amount Paid cannot be negative.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) > parseFloat(tempFinalAmount)) {
        showError(element.id, '#ff6666', "Amount Paid cannot be bigger than Final Amount.");
        return 0;
    } else showError(element.id, '', '');

    amountPendingLater = parseFloat(parseFloat(tempPendingAmount) - parseFloat(element.value)).toFixed(2);
    // console.log(amountPendingLater);
    tdsCalculate();
    return 1;
}

function tdsCalculate() {
    let tempValue = document.getElementById("amountpaid").value;
    console.log(tempValue);
    if (tempValue == '') {
        showError("amountpaid", "#ff6666", 'Enter Paid Amount for TDS%.');
        return 0;
    } else if (parseFloat(document.getElementById("tdsPercent").value) < 0) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Negative.');
        return 0;
    } else if (parseFloat(document.getElementById("tdsPercent").value) >= 100) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Bigger than or equal to 100.');
        return 0;
    } else if (document.getElementById("tdsPercent").value != '') {
        document.getElementById("tdsAmount").value = parseFloat(parseFloat(tempValue) * (parseFloat(document.getElementById("tdsPercent").value) / 100)).toFixed(2);
        document.getElementById("reminderAmount").value = parseFloat(parseFloat(tempValue) - parseFloat(document.getElementById("tdsAmount").value)).toFixed(2);
    }
    showError('amountpaid', '', '');
    showError('tdsPercent', '', '');
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}

var facultyBankName = '',
    paymentDate = '',
    companyBankName = '',
    companyAccountNo = '',
    transactionId = '',
    amountPaid = '',
    amountPending = '',
    tdsPercent = '',
    penaltyAmount = '',
    notesForPayment = '',
    facultyAccountNo = '',
    facultyBranchName = '';

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");

    return output;
}

function setHeaders() {
    facultyBankName = '',
        paymentDate = '',
        companyBankName = '',
        companyAccountNo = '',
        transactionId = '',
        amountPaid = '',
        amountPending = '',
        tdsPercent = '',
        penaltyAmount = '',
        notesForPayment = '';

    facultyBankName = document.getElementById("facultyBankName").value.trim();
    paymentDate = $("#paymentDate").find("input").val();
    tempSelect = document.getElementById("companyBankName");
    companyBankName = tempSelect[tempSelect.selectedIndex].text.trim();
    companyAccountNo = document.getElementById("companyBankAccountNo").value.trim();
    transactionId = document.getElementById("transactionId").value.trim();
    amountPaid = document.getElementById("amountpaid").value.trim();
    amountPending = document.getElementById("facultyPendingAmount").value.trim();
    tdsPercent = document.getElementById("tdsPercent").value.trim();
    notesForPayment = document.getElementById("paymentNotesText").value.trim();
    notesForPayment = escapeSpecialCharacters(notesForPayment);
    penaltyAmount = document.getElementById("facultyPenaltyAmount").value.trim();
    return 1;
}

function facultyBankDetails(facultyId) {
    facultyAccountNo = '',
        facultyBranchName = '';
    for (let i = 0; i < masterFacultyList.length; i++) {
        if (masterFacultyList[i].facultyId == facultyId) {
            document.getElementById("facultyBankName").value = masterFacultyList[i].bankName;
            facultyAccountNo = masterFacultyList[i].accountNo;
            facultyBranchName = masterFacultyList[i].branch;
        }
    }
}

function formValidation() {
    if (setHeaders() == 0) return 0;

    if (paymentDate == '') {
        showError('paymentDate', '#ff6666', "Payment Date cannot be Blank.");
        return 0;
    } else showError('paymentDate', '', '');

    if (companyBankName == 'SELECT BANK NAME') {
        showError('companyBankName', '#ff6666', "Please Select Valid company Bank Name.");
        return 0;
    } else showError('companyBankName', '', '');

    if (transactionId == '') {
        showError('transactionId', '#ff6666', "Transaction Id cannot be Blank.");
        return 0;
    } else showError('transactionId', '', '');

    if (calculate(document.getElementById("amountpaid")) == 0) return 0;
    if (tdsPercent == '') {
        showError('tdsPercent', '#ff6666', "Please Enter TDS Percent.");
        return 0;
    } else showError('tdsPercent', '', '');

    if (parseFloat(tdsPercent) > 100) {
        showError('tdsPercent', '#ff6666', "TDS Percent cannot be larger than 100%.");
        return 0;
    } else showError('tdsPercent', '', '');

    if (parseFloat(tdsPercent) < 0) {
        showError('tdsPercent', '#ff6666', "TDS Percent cannot be smaller than 0%.");
        return 0;
    } else showError('tdsPercent', '', '');

    facultyBankDetails(facultyId);

    if (makeArray() == 0) return 0;
    return 1;
}

function makeArray() {
    paymentContentArray = [];
    var obj = {
        'WaccountsId': WaccountsId,
        'facultyId': facultyId,
        'workshopId': workshopId,
        'facultyName': facultyName,
        'workshopTitle': workshopTitle,
        'facultyBankName': facultyBankName,
        'facultyAccountNo': facultyAccountNo,
        'facultyBranchaName': facultyBranchName,
        'paymentDate': paymentDate,
        'companyBankName': companyBankName,
        'companyAccountNo': companyAccountNo,
        'transactionId': transactionId,
        'amountPaid': amountPaid,
        'amountPending': amountPendingLater,
        'tdsPercent': tdsPercent,
        'notes': notesForPayment,
        'penaltyAmount': penaltyAmount,
    }
    paymentContentArray.push(obj);
    return 1;
}

function savePayment() {
    var saveFlag = "savePayment";
    if (formValidation() == 0) return;
    document.getElementById('savePayment').disabled = true;
    if (checkOnline() == false) return;
    else {
        if (confirm("Are you sure you want to save this Payment??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Payment. Please wait...';
            document.getElementById("savePayment").disabled = true;
            $.post('saveWorkshopPayment.php', {
                'saveFlag': saveFlag,
                'contentArray': paymentContentArray,
            }, function (data) {
                console.log(data);
                document.getElementById('successMessage').innerHTML = 'Payment Done Successfully...';
                document.getElementById("savePayment").disabled = true;
            });
        }
        else document.getElementById("savePayment").disabled = false;
    }
}

function deleteInvoice(workshopId, accountsId, workshopTitle) {
    var saveFlag = 'DeleteInvoice';
    formData = new FormData();
    formData.append('saveFlag', saveFlag);
    formData.append('workshopId', workshopId);
    formData.append('accountsId', accountsId);
    formData.append('workshopTitle', workshopTitle);
    console.log("hiii");
    if (confirm("Are you sure you want to delete invoice")) {
        $.ajax({
            url: "deleteWorkshopInvoice.php",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            enctype: 'multipart/form-data',
            success: function (data) {
                // location.reload();
            }
        });
    }
}

function showDetails(paymentId) {
    encodedValue_paymentId = btoa(paymentId);
    encodedKey_pId = btoa('pId');

    // window.location.href = 'viewPaymentDetails.php?pId=' + paymentId;
    window.location.href = 'viewWorkshopPaymentDetails.php?' + encodedKey_pId + "=" + encodedValue_paymentId;
}

function deletePayment(rows, array) {
    var saveFlag = "DELETEPAYMENT";

    if (checkOnline() == false) return;
    // console.log(array.split("::"));
    t = array.split("::");
    if (confirm("Are you sure you want to Delete this Payment of RS-" + t[10] + " ???")) {
        $.post('saveWorkshopPayment.php', {
            'userName': userName,
            'saveFlag': saveFlag,
            'contentArray': array,
        }, function (data) {
            // $('#savedData').html(data);
            // console.log(data);
            // document.getElementById('successMessage').innerHTML = 'Payment Deleted Successfully.';
            location.reload();
        });
    }
}

function viewBulkPayments(){
    window.location.href = 'allWorkshopPendingPayments.php';
}