function tdsCalculate() {
    let tempValue = document.getElementById("facultyFinalAmount").value;
    if (tempValue == '') {
        showError("facultyFinalAmount", "#ff6666", 'Enter Paid Amount for TDS%.');
        return 0;
    } else if (parseFloat(document.getElementById("tdsPercent").value) < 0) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Negative.');
        return 0;
    } else if (parseFloat(document.getElementById("tdsPercent").value) >= 100) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Bigger than or equal to 100.');
        return 0;
    } else if (document.getElementById("tdsPercent").value != '') {
        document.getElementById("tdsAmount").value = parseFloat(parseFloat(tempValue) * (parseFloat(document.getElementById("tdsPercent").value) / 100)).toFixed(2);
        document.getElementById("reminderAmount").value = parseFloat(parseFloat(tempValue) - parseFloat(document.getElementById("tdsAmount").value)).toFixed(2);
    }
    showError('facultyFinalAmount', '', '');
    showError('tdsPercent', '', '');
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function saveTDS(){
    var tdsPercent = document.getElementById("tdsPercent").value.trim();
    var saveFlag = 'WTDSPAYMENT';
    if(tdsPercent == ''){
        showError("tdsPercent", "#ff6666", 'TDS% cannot be blank');
        return 0;
    }else showError('tdsPercent', '', '');
    if (checkOnline() == false) return;
    document.getElementById('successMessage').innerHTML = 'Saving WTDS Payment. Please wait...';
            document.getElementById("savePayment").disabled = true;
            $.post('saveWTDSpercent.php', {
                'saveFlag': saveFlag,
                'tdsPercent': tdsPercent,
                'accountsId' : WaccountsId,
                'facultyId':facultyId,
                'workshopId':workshopId,
                'workshopTitle':workshopTitle
            }, function (data) {
                console.log(data);
                document.getElementById('successMessage').innerHTML = 'Saved Successfully';
                document.getElementById("savePayment").disabled = true;
            });
}