function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext.toUpperCase();
}


function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "companyBankName") dummyOptions(theSelect, options, "BANK NAME");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");

        if (selectName.includes("companyBankName")) {
            options.value = results[i].accountNo.toUpperCase();
            options.text = results[i].bankName.toUpperCase();
            theSelect.add(options);
        }

    }
}

function loadAccountNo(element, f) {
    var text = element[element.selectedIndex].value.trim();
    if (text != 'SELECT BANK NAME') document.getElementById("companyBankAccountNo" + f).value = text;
    else document.getElementById("companyBankAccountNo" + f).value = '';
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function calculate(element) {

    var tempFinalAmount = document.getElementById("vendorFinalAmount").value;

    if (element.value == '') {
        showError(element.id, '#ff6666', "Amount Paid cannot be blank.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) == 0) {
        showError(element.id, '#ff6666', "Amount Paid cannot be zero.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) < 0) {
        showError(element.id, '#ff6666', "Amount Paid cannot be negative.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) > parseFloat(tempFinalAmount)) {
        showError(element.id, '#ff6666', "Amount Paid cannot be bigger than Final Amount.");
        return 0;
    } else showError(element.id, '', '');
    if (parseFloat(element.value) > parseFloat(tempPendingAmount)) {
        showError(element.id, '#ff6666', "Amount Paid cannot be bigger than Pending Amount.");
        return 0;
    } else showError(element.id, '', '');

    amountPendingLater = parseFloat(parseFloat(tempPendingAmount) - parseFloat(element.value)).toFixed(2);
    console.log(amountPendingLater);
    tdsCalculate();
    return 1;
}
function tdsCalculate() {
    amountPending = document.getElementById("vendorPendingAmount").value.trim();

    if (amountpaid == '') {
        showError("amountpaid", "#ff6666", 'Enter Paid Amount for TDS%.');
        return 0;

    }

    else if (parseFloat(document.getElementById("tdsPercent").value) < 0) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Negative.');
        return 0;
    } else if (parseFloat(document.getElementById("tdsPercent").value) >= 100) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Bigger than or equal to 100.');
        return 0;
    }

    if (vendorType == 'GST') {
        let tempValue = document.getElementById("vendorGrossAmount").value;
        let amountpaid = document.getElementById("amountpaid").value;
        document.getElementById("tdsAmount").value = parseFloat(parseFloat(tempValue) * (parseFloat(document.getElementById("tdsPercent").value) / 100)).toFixed(2);
        document.getElementById("reminderAmount").value = parseFloat(parseFloat(amountpaid) - parseFloat(document.getElementById("tdsAmount").value)).toFixed(2);
    }
    else {
        let tempValue = document.getElementById("amountpaid").value;
        let amountpaid = document.getElementById("amountpaid").value;
        document.getElementById("tdsAmount").value = parseFloat(parseFloat(tempValue) * (parseFloat(document.getElementById("tdsPercent").value) / 100)).toFixed(2);
        document.getElementById("reminderAmount").value = parseFloat(parseFloat(amountpaid) - parseFloat(document.getElementById("tdsAmount").value)).toFixed(2);
    }
    showError('amountpaid', '', '');
    showError('tdsPercent', '', '');
}
function vendorBankDetails(vendorId) {
    vendorAccountNo = '',
        vendorBranchName = '';
    for (let i = 0; i < mastervendorList.length; i++) {
        if (mastervendorList[i].vendorId == vendorId) {
            document.getElementById("vendorBankName").value = mastervendorList[i].vendorBankName;
            vendorAccountNo = mastervendorList[i].accountNo;
            vendorBranchName = mastervendorList[i].bankBranch;
        }
    }
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");

    return output;
}
function setHeaders() {
    vendorBankName = '',
        paymentDate = '',
        companyBankName = '',
        companyAccountNo = '',
        transactionId = '',
        amountPaid = '',
        amountPending = '',
        tdsPercent = '',
        penaltyAmount = '',
        notesForPayment = '';

    vendorBankName = document.getElementById("vendorBankName").value.trim();
    venderCompanyName = document.getElementById("venderCompanyName").value.trim();
    paymentDate = $("#paymentDate").find("input").val();
    tempSelect = document.getElementById("companyBankName");
    companyBankName = tempSelect[tempSelect.selectedIndex].text.trim();
    companyAccountNo = document.getElementById("companyBankAccountNo").value.trim();
    transactionId = document.getElementById("transactionId").value.trim();
    amountPaid = document.getElementById("amountpaid").value.trim();
    amountPending = document.getElementById("vendorPendingAmount").value.trim();
    tdsPercent = document.getElementById("tdsPercent").value.trim();
    notesForPayment = document.getElementById("paymentNotesText").value.trim();
    notesForPayment = escapeSpecialCharacters(notesForPayment);
    return 1;
}
function formValidation() {
    if (setHeaders() == 0) return 0;
    if (vendorBankName == '') {
        showError('vendorBankName', '#ff6666', "Vendor Bank Name is Blank");
        return 0;
    } else showError('vendorBankName', '', '');
    if (companyBankName == 'SELECT BANK NAME') {
        showError('companyBankName', '#ff6666', "Please Select Valid company Bank Name.");
        return 0;
    } else showError('companyBankName', '', '');

    if (calculate(document.getElementById("amountpaid")) == 0) return 0;
    if (tdsPercent == '') {
        showError('tdsPercent', '#ff6666', "Please Enter TDS Percent.");
        return 0;
    } else showError('tdsPercent', '', '');

    if (parseFloat(tdsPercent) > 100) {
        showError('tdsPercent', '#ff6666', "TDS Percent cannot be larger than 100%.");
        return 0;
    } else showError('tdsPercent', '', '');

    if (parseFloat(tdsPercent) < 0) {
        showError('tdsPercent', '#ff6666', "TDS Percent cannot be smaller than 0%.");
        return 0;
    } else showError('tdsPercent', '', '');

    if (paymentDate == '') {
        showError('paymentDate', '#ff6666', "Payment Date cannot be Blank.");
        return 0;
    } else showError('paymentDate', '', '');


    if (transactionId == '') {
        showError('transactionId', '#ff6666', "Transaction Id cannot be Blank.");
        return 0;
    } else showError('transactionId', '', '');



    vendorBankDetails(vendorId);

    if (makeArray() == 0) return 0;
    return 1;
}

function makeArray() {
    paymentContentArray = [];
    var obj = {
        'invoiceId': invoiceId,
        'vendorId': vendorId,
        'vendorName': vendorName,
        'vendorcompanyName': venderCompanyName,
        'vendorBankName': vendorBankName,
        'vendorAccountNo': vendorAccountNo,
        'vendorBranchaName': vendorBranchName,
        'paymentDate': paymentDate,
        'companyBankName': companyBankName,
        'companyAccountNo': companyAccountNo,
        'transactionId': transactionId,
        'amountPaid': amountPaid,
        'amountPending': amountPendingLater,
        'tdsPercent': tdsPercent,
        'notes': notesForPayment,
    }
    paymentContentArray.push(obj);
    return 1;
}

function savePayment() {
    var saveFlag = "savePayment";
    if (formValidation() == 0) return;
    console.log(paymentContentArray);
    if (checkOnline() == false) return;
    else {
        if (confirm("Are you sure you want to save this Payment??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Payment. Please wait...';
            document.getElementById("savePayment").disabled = true;
            $.post('savePayment.php', {
                'saveFlag': saveFlag,
                'contentArray': paymentContentArray,
            }, function (data) {
                console.log(data);
                document.getElementById('successMessage').innerHTML = 'Payment Done Successfully...';
                document.getElementById("savePayment").disabled = true;
            });
        }
        else document.getElementById("savePayment").disabled = false;
    }
}
