var querySolution = '',
    querySolutionImageFlag = '',
    querySolutionImage = '',
    queryRejectReason = '',
    queryTransferTo = '';

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("queryRaisedTo")) {
            if (i == 0) {
                options.value = options.text = "QUERY TRANSFER TO";
                theSelect.add(options);
                options.selected = true;
                options.disabled = true;
                options = document.createElement("option");
            }
            options.value = results[i].userid;
            options.text = results[i].firstname + " " + results[i].lastname + " (" + results[i].user_type + ")".toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

var loadFile = function (event, previewId) {
    if (previewId == "queryImage" && event.target.files[0]) {
        flagEditPhoto = 1;
        var querySolutionImagePreview = document.getElementById('querySolutionImagePreview');
        querySolutionImagePreview.src = URL.createObjectURL(event.target.files[0]);
        querySolutionImagePreview.style.height = 200;
        querySolutionImagePreview.style.width = 180;
        querySolutionImagePreview.onload = function () {
            URL.revokeObjectURL(querySolutionImagePreview.src)
        }
    }
}

function viewQueryAttachment() {
    var queryImagePreview = document.getElementById('queryImagePreview');
    queryImagePreview.src = "../../../dist/img/studentQueryImages/" + tempQueryImage;
    queryImagePreview.style.height = 200;
    queryImagePreview.style.width = 180;

    newDiv = document.createElement("div");
    newDiv.setAttribute("class", "lightbox");

    newButton = document.createElement("button");
    newButton.setAttribute("class", "btn btn-primary showButton");
    newButton.setAttribute("type", "submit");
    newButton.setAttribute("id", "imageButton");
    newButton.setAttribute("onclick", "openModel('queryImagePreview')");
    newButton.style = "position: absolute;margin-left: 35%;margin-top: 40%;z-index: 2 ;display:none;";

    newI = document.createElement("i");
    newI.setAttribute("class", "fas fa-search");

    button = document.createElement("button");
    button.setAttribute("type", "button on click");
    button.setAttribute("id", "imageModal");
    button.setAttribute("data-toggle", "modal");
    button.setAttribute("data-target", "#exampleModal");
    button.setAttribute("hidden", "hidden");

    queryImagePreview.setAttribute("class", "lightbox");

    lightBoxDiv = document.createElement("div");
    lightBoxDiv.setAttribute("class", "lightbox");

    lightBoxDiv.appendChild(button);
    lightBoxDiv.appendChild(queryImagePreview);
    newButton.appendChild(newI);
    newDiv.appendChild(newButton);
    newDiv.appendChild(lightBoxDiv);

    queryAttachmentDiv = document.getElementById("queryAttchmentDiv");
    queryAttachmentDiv.appendChild(newDiv);
}

function showAndHideDiv() {
    if (statusOfQuery == 'UNDER PROCESS') {
        document.getElementById('acceptQueryLabel').innerHTML = 'Give a Solution';
        document.getElementById('acceptQuery').checked = true;
    } else if (queryStatus == 'PARTIALLY RESOLVED') {
        document.getElementById('viewRatingDiv').hidden = true;
        document.getElementById('viewDiv').hidden = false;
    } else if (queryStatus == 'FULLY RESOLVED') {
        document.getElementById('viewRatingDiv').hidden = false;
        document.getElementById('viewDiv').hidden = false;
    } else if (queryStatus == 'NOT RESOLVED') {
        document.getElementById('viewRatingDiv').hidden = false;
        document.getElementById('viewDiv').hidden = false;
    }
}

function viewRatingCount() {
    const starTotal = 10;
    const starPercentage = (parseFloat(ratingCount) / starTotal) * 100;
    const starPercentageRounded = (Math.round(starPercentage / 10) * 10) + '%';
    document.querySelector('.stars-inner').style.width = starPercentageRounded;
}

function selectQueryStatus(id) {
    if (id == 'acceptQuery') {
        document.getElementById("queryacceptDiv").hidden = false;
        document.getElementById("qyerySolutionDiv").hidden = true;
        document.getElementById("queryrevisedDiv").hidden = true;
        document.getElementById("queryrejectedDiv").hidden = true;
        document.getElementById("querytransferDiv").hidden = true;
    }
    if (id == 'rejectedQuery') {
        document.getElementById("queryacceptDiv").hidden = true;
        document.getElementById("queryrevisedDiv").hidden = true;
        document.getElementById("queryrejectedDiv").hidden = false;
        document.getElementById("querytransferDiv").hidden = true;
    }
    else if (id == 'revisedQuery') {
        document.getElementById("queryacceptDiv").hidden = true;
        document.getElementById("queryrevisedDiv").hidden = false;
        document.getElementById("queryrejectedDiv").hidden = true;
        document.getElementById("querytransferDiv").hidden = true;
    }
    else if (id == 'transferQuery') {
        document.getElementById("queryacceptDiv").hidden = true;
        document.getElementById("queryrevisedDiv").hidden = true;
        document.getElementById("queryrejectedDiv").hidden = true;
        document.getElementById("querytransferDiv").hidden = false;
    }
    if (queryStatus == 'UNDER PROCESS') {
        document.getElementById('a').innerHTML = 'Give a Solution';
        document.getElementById("qyerySolutionDiv").hidden = false;
    }
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"")
        .replace(/\'/g, "\'")
        .replace(/\"/g, "\"");
    return output;
}

function showError(id, color, message) {
    if (id != '') document.getElementById(id).style.backgroundColor = color;
    document.getElementById('querySolutionErrorMessage').innerHTML = message;
}

function showQueryRejectError(id, color, message) {
    if (id != '') document.getElementById(id).style.backgroundColor = color;
    document.getElementById('queryRejectErrorMessage').innerHTML = message;
}

function showTransferQueryError(id, color, message) {
    if (id != '') document.getElementById('transferQueryErrorMessage').innerHTML = message;
}

function acceptQuery() {
    document.getElementById('acceptQueryButton').disabled = true;
    var saveFlag = 'accept';

    if (checkOnline() == false) {
        document.getElementById("acceptQueryButton").disabled = false;
        return;
    }

    if (confirm("Are you sure you want to accept query ???")) {
        document.getElementById('querySolutionSuccessMessage').innerHTML = "saving please wait.";
        document.getElementById('acceptQueryButton').disabled = true;
        $.post("saveQuery.php", {
            'saveFlag': saveFlag,
            'queryId': queryId,
        }, function (data) {
            document.getElementById("qyerySolutionDiv").hidden = false;
            document.getElementById('querySolutionSuccessMessage').innerHTML = "saved successfully. Please wait. The page will get auto-refresh...";
            location.reload();
        })
    }
    else document.getElementById('acceptQueryButton').disabled = false;
}

function solutionValidation() {
    querySolution = '';
    querySolution = document.getElementById('solution').value.trim();

    var input = document.getElementById("queryImage");
    if (input.files.length > 0) {
        querySolutionImageFlag = "true";
        querySolutionImage = input.files[0];
        var imgSize = (parseFloat(input.files[0].size / 1024) / 1024).toFixed(2);
        if (imgSize > 1) {
            showError('', '', "Image size should not exceed 1 MB.");
            return 0;
        } else showError('', '', '');
    }

    if (querySolution == '') {
        document.getElementById("solution").style.backgroundColor = "#ffc2b3";
        showError('solution', "#ffc2b3", "Enter Solution");
        return 0;
    } else {
        document.getElementById("solution").style.backgroundColor = "";
        showError('querySolutionErrorMessage', '', '');
    }
    return 1;
}

function saveQuerySolution() {
    document.getElementById('saveSolutionButton').disabled = true;
    var saveFlag = 'saveSolution';

    if (solutionValidation() == false) {
        document.getElementById("saveSolutionButton").disabled = false;
        return;
    }

    if (checkOnline() == false) {
        document.getElementById("saveSolutionButton").disabled = false;
        return;
    }
    querySolution = escapeSpecialCharacters(querySolution);
    formData = new FormData();
    formData.append("saveFlag", saveFlag);
    formData.append("querySolution", querySolution);
    formData.append("queryId", queryId);
    formData.append("studentId", studentId);
    formData.append("querySolutionImageFlag", querySolutionImageFlag);
    formData.append("querySolutionImage", querySolutionImage);
    formData.append("queryDetails", JSON.stringify(queryDetails));
    formData.append("studentDetails", JSON.stringify(studentDetails));
    if (confirm("Are you sure you want to save solution ??? ")) {
        document.getElementById("saveSolutionButton").disabled = true;
        document.getElementById('transferQueryButton').disabled = true;
        document.getElementById('querySolutionSuccessMessage').innerHTML = 'Saving Please wait....';
        $.ajax({
            url: "saveQuerySolution.php",
            type: "POST",
            enctype: 'multipart/form-data',
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                document.getElementById('querySolutionSuccessMessage').innerHTML = "solution saved successfully. Please wait. The page will get auto-refresh...";
                location.reload();
            }
        });
    }
    else document.getElementById('saveSolutionButton').disabled = false;
}

function rejectQueryValidation() {
    queryRejectReason = '';
    queryRejectReason = document.getElementById('queryRejectReason').value.trim();

    if (queryRejectReason == '') {
        showQueryRejectError('queryRejectReason', '#ff6666', "Enter the reasons for rejection");
        return 0;
    } else showQueryRejectError('queryRejectReason', '', "");
    return 1;
}

function rejectQuery() {
    document.getElementById('rejectQueryButton').disabled = true;
    var saveFlag = "reject";

    if (rejectQueryValidation() == false) {
        document.getElementById("rejectQueryButton").disabled = false;
        return;
    }
    queryRejectReason = escapeSpecialCharacters(queryRejectReason);
    if (checkOnline() == false) {
        document.getElementById("rejectQueryButton").disabled = false;
        return;
    }

    if (confirm("Are you sure you want Reject Query ??? ")) {
        document.getElementById('rejectQueryButton').disabled = true;
        document.getElementById('queryRejectSuccessMessage').innerHTML = 'saving please wait ......';
        $.post("saveRejectedQuery.php", {
            'saveFlag': saveFlag,
            'queryRejectReason': queryRejectReason,
            'queryId': queryId,
            'studentId': studentId,
            'queryDetails': queryDetails,
            'studentDetails': studentDetails,
        }, function (data) {
            document.getElementById('queryRejectSuccessMessage').innerHTML = 'Saved successfully. Please wait. The page will get auto-refresh...';
            document.getElementById('rejectQueryButton').disabled = true;
            location.reload();
        })
    }
    else document.getElementById('rejectQueryButton').disabled = false;
}

function saveRevisedQuery() {
    document.getElementById('saveRevisionButton').disabled = true;
    var saveFlag = 'revise'
    if (checkOnline() == false) {
        document.getElementById("saveRevisionButton").disabled = false;
        return;
    }
    if (confirm("Are you sure you want to save it as revise query?")) {
        document.getElementById('saveRevisionButton').disabled = true;
        document.getElementById('revisedQuerySuccessMessage').innerHTML = 'Saving please wait.....';
        $.post("saveRevisedQuery.php", {
            'saveFlag': saveFlag,
            'queryId': queryId,
            'studentId': studentId,
            'queryDetails': queryDetails,
            'studentDetails': studentDetails,
        }, function (data) {
            document.getElementById('revisedQuerySuccessMessage').innerHTML = 'Saved successfully. Please wait. The page will get auto-refresh...';
            window.location.href = 'query.php';
        })
    }
    else document.getElementById('saveRevisionButton').disabled = false;
}

function transferQueryValidation() {
    queryTransferTo = '';
    queryTransferTo = document.getElementById('queryRaisedTo').value.trim();
    if (queryTransferTo == 'QUERY TRANSFER TO') {
        document.getElementById("queryRaisedTo").style.backgroundColor = "#ffc2b3";
        showTransferQueryError('queryRaisedTo', "#ffc2b3", "Select whom you want to transfer query");
        return 0;
    } else {
        document.getElementById("queryRaisedTo").style.backgroundColor = "";
        showTransferQueryError('modalErrorMessage', '', '');
    }
    return 1;
}

function transferQuery() {
    document.getElementById('transferQueryButton').disabled = true;
    var saveFlag = 'transferQuery';

    if (transferQueryValidation() == false) {
        document.getElementById("transferQueryButton").disabled = false;
        return;
    }
    if (checkOnline() == false) {
        document.getElementById("transferQueryButton").disabled = false;
        return;
    }
    if (confirm("Are you sure you want to transfer this query ???")) {
        document.getElementById('transferQuerySuccessMessage').innerHTML = 'Transfering Query Please wait....';
        $.post("saveTransferQuery.php", {
            'saveFlag': saveFlag,
            'queryTransferedTo': queryTransferTo,
            'queryId': queryId,
            'queryDetails': queryDetails
        }, function (data) {
            console.log(data);
            document.getElementById('transferQuerySuccessMessage').innerHTML = "Query Transfered.";
        });
    }
    else document.getElementById('transferQueryButton').disabled = false;
}