<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../../loginPage.php');
    exit;
}

require_once '../../../common/connectToDB.php';
require '../../../common/header.php';
require '../../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">STUDENT PAYMENT LIST</h3>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY PAYMENT DATE</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control fS13" id="paymentDateFilter" placeholder="FROM TO DATE" onchange="calculateAmountReceived()" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#paymentDateFilter" data-toggle="daterangepicker">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <label class='fS13'>TOTAL AMOUNT RECEIVED (FILTER BY DATE)</label>
                                    <div class="input-group my-colorpicker2">
                                        <div class="input-group-append">
                                            <span class="input-group-text"> <i class='fas fa-rupee-sign fS21'></i>
                                            </span>
                                        </div>
                                        <input type="text" class="form-control " id="totalAmountFilterByDate" placeholder="Total Amount" onchange="" disabled />
                                    </div>
                                </div>
                                <div class="col-md-4">
                                </div>
                                <div class="col-md-3">
                                    <label class='fS13'>TOTAL AMOUNT RECEIVED</label>
                                    <div class="input-group my-colorpicker2">
                                        <div class="input-group-append">
                                            <span class="input-group-text"> <i class='fas fa-rupee-sign fS21'></i>
                                            </span>
                                        </div>
                                        <input type="text" class="form-control " id="totalAmountReceived" placeholder="Total Amount" onchange="" disabled />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="example1">
                                <thead>
                                    <tr>
                                        <th style="width:10%;">
                                            Payment Id
                                        </th>
                                        <th style="width:15%;">
                                            Full Name
                                        </th>
                                        <th style="width:10%;">
                                            Payment Date
                                        </th>
                                        <th style="width:10%;">
                                            Payment Type
                                        </th>
                                        <th style="width:20%;">
                                            Payment Purpose
                                        </th>
                                        <th style="width:10%;">
                                            Amount
                                        </th>
                                        <th style="width:15%;">
                                            Payment Details
                                        </th>
                                        <th style="width:10%;">
                                            Fee Receipt
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../../common/connectToDB.php';

                                    $sql2 = "SELECT * from paymenthistory WHERE paymentStatus IN('APPROVED') ORDER BY
                                    paymentId desc; ";
                                    $result = $conn->query($sql2);
                                    $sr = 0;
                                    $totalAmountReceived = 0;
                                    $payentHistoryDetails = [];
                                    $statusCSS = "badge badge-danger";
                                    if ($result->num_rows > 0) {
                                        $rowId = 1;
                                        while ($row = $result->fetch_assoc()) {
                                            array_push($payentHistoryDetails, $row);
                                            $paymentId = $row["paymentId"];
                                            $leadId = $row["studentId"];
                                            $leadName = $row["firstName"] . ' ' . $row["lastName"];
                                            $paymentDate1 = $row["paymentDate"];
                                            $paymentDate = str_replace('-', "/", $paymentDate1);
                                            $paymentMethod = $row['paymentMethod'];
                                            $paymnetPurpose = '"' . $row['paymentPurpose'] . '"';
                                            $amount = $row['amount'];
                                            $studentId = '"' . $row['studentId'] . '"';
                                            $paymentDescription = '"' . $row['paymentDescription'] . '"';
                                            $programFeeReceipt = $row['programFeeReceipt'];
                                            $tuitionFeeReceipt = $row['tuitionFeeReceipt'];
                                            $totalAmountReceived = $totalAmountReceived + $amount;

                                            echo "
                                    <tr class='tAC'>
                                        <td><a class='tCB' href='#' onclick='showDetails(this.id,$paymentId)' id=" . $leadId . ">" . $paymentId . "</a></td>
                                        <td><a class='tCB' href='#' onclick='showDetails(this.id,$paymentId)' id=" . $leadId . "> " . $leadName . "</a></td>
                                        <td>" . $paymentDate . "</td>
                                        <td>" . $paymentMethod . "</td>";
                                            if ($row['paymentDescription'] != '') {
                                                echo "<td>" . $row['paymentPurpose'] . ' (' . $row['paymentDescription'] . ')' . "</td>";
                                            } else {
                                                echo "<td>" . $row['paymentPurpose'] . "</td>";
                                            }
                                            echo "<td>" . $amount . "</td>
                                        <td class='project-actions'>
                                            <a class='btn btn-primary btn-sm' href='#'
                                                onclick='showDetails(this.id,$paymentId)' id=" . $leadId . "
                                                title='click hear to view Payment Details'>
                                                <i class='fas fa-eye'>
                                                </i>
                                            </a>
                                            <a class='btn btn-warning btn-sm' href='#'
                                                title='Click here to Edit Payment.'
                                                onclick='editPayment(this.id,$paymentId)' id=" . $leadId . ">
                                                <i class='fas fa-edit'></i>
                                            </a>";
                                            echo "</td>";
                                            if (($row['paymentPurpose'] == 'PROGRAM FEE' || $row['paymentPurpose'] == "CHEQUE BOUNCE CHARGE") && $amount != 0) {
                                            //     echo "<td><a class='btn btn-primary btn-sm' target='_blank'
                                            //     href='../../../../dist/documents/studentProgramFeeReceipts/$programFeeReceipt'>
                                            //     <i class='fas fa-eye'>
                                            //     </i>
                                            // </a></td>";
                                                     echo "<td><a class='btn btn-primary btn-sm' id=" .  $paymentId . " onclick = 'generateReciptPdf(this.id,$studentId,$paymnetPurpose,$paymentDescription)'>
                                                <i class='fas fa-eye' style='color:white'>
                                                </i>
                                            </a></td>";
                                            }
                                             else if ($row['paymentPurpose'] == 'TUITION FEE' && $row['tuitionFeeReceipt'] != '') {
                                                echo "<td><a class='btn btn-primary btn-sm' target='_blank'
                                                href='../../../../dist/documents/studentTuitionFeeReceipts/$tuitionFeeReceipt'>
                                                <i class='fas fa-eye'>
                                                </i>
                                            </a></td>";
                                            } else echo "<td></td>";
                                            echo "</tr";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="../../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="paymentHistory.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var totalAmount = <?php echo $totalAmountReceived; ?>;
    document.getElementById('totalAmountReceived').value = numberWithCommas(totalAmount);
    var paymentHistoryDetails = <?php echo json_encode($payentHistoryDetails); ?>;

    $('#paymentDateFilter').daterangepicker({
        autoApply: true,
        "alwaysShowCalendars": true,
        locale: {
            format: 'DD/MM/YYYY',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                .endOf('month')
            ],
        },
    });

    $(function() {
        $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

        $("#paymentDateFilter").val("");
        $("#paymentDateFilter").change(function() {
            var table = $('#example1').DataTable();
            table.draw();
        });
        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("paymentDateFilter").value.trim();
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[2]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                } else inEmpStartingDateRange = true;
                return inEmpStartingDateRange;
            }
        );
    });
</script>
<?php require '../../../common/footer.php'; ?>