<?php
session_start();
if (isset($_SESSION['BDELoginsuccessEdj'])) {
    if ($_SESSION['BDELoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
$BDEId = $_SESSION['BDEUserid'];
$academicYearList = [];

$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">Lead Pool</h3>
                            <br>
                            <br>
                            <div class='row'>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                        <select class="select2" multiple="multiple" id="filterAyear" data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;" onchange="filterTable('studAyear')" ;>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY LEAD QUALIFICATION</label>
                                        <select class="select2" multiple="multiple" id="filterLeadQualificartion" data-placeholder="SELECT LEAD QUALIFICATION" style="width: 100%;" onchange="filterTable('studAyear')" ;>
                                            <option>NEW LEAD</option>
                                            <option>RECEIVED FROM CENTER</option>
                                            <option>TRANSFERRED TO COUNSELOR</option>
                                            <option>SEEK ADMISSION</option>
                                            <option>ADMISSION CONFIRMED</option>
                                            <option>DROPPED</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="example1">
                                <thead>
                                    <tr>
                                        <th>
                                            ID
                                        </th>
                                        <th>
                                            NAME
                                        </th>
                                        <th>
                                            PHONE NO.
                                        </th>
                                        <th>
                                            EMAIL ID
                                        </th>
                                        <th>
                                            CITY
                                        </th>
                                        <th>
                                           STATUS
                                        </th>
                                        <th>
                                            LEAD QUALIFICATION
                                        </th>
                                        <th>
                                           ACADEMIC YEAR
                                        </th>
                                        <th>
                                            Action
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from leads WHERE leadBDEId='$BDEId'  ORDER BY leadId DESC; ";
                                    $result = $conn->query($sql);
                                    $sr = 0;
                                    if ($result->num_rows > 0) {
                                        $rowId = 1;
                                        while ($row = $result->fetch_assoc()) {
                                            $sr = $sr + 1;
                                            $leadId = $row["leadId"];
                                            $leadName = $row["leadFirstName"] . ' ' . $row["leadMiddleName"] . ' ' . $row["leadLastName"];
                                            $leadEmail = $row['emailId'];
                                            $leadcontactNo = $row['phoneNumber'];
                                            $leadCity = $row['city'];
                                            $qualificationCSS = '';
                                            $leadQualification = '';

                                            if ($row['qualification'] == "NEW LEAD") {
                                                $qualificationCSS = "badge badge-info";
                                                $leadQualification = "NEW LEAD";
                                            } else if ($row['qualification'] == "TRANSFERRED TO BDE") {
                                                $qualificationCSS = "badge badge-warning";
                                                $leadQualification = "RECEIVED FROM BO";
                                            } else if ($row['qualification'] == "TRANSFERRED TO COUNSELLOR") {
                                                $qualificationCSS = "badge badge-warning";
                                                $leadQualification = "TRANSFERRED TO BDO";
                                            } else if ($row['qualification'] == "SEEK ADMISSION") {
                                                $qualificationCSS = "badge badge-success";
                                                $leadQualification = "SEEK ADMISSION";
                                            } else if ($row['qualification'] == "ADMISSION CONFIRMED") {
                                                $qualificationCSS = "badge badge-primary";
                                                $leadQualification = "ADMISSION CONFIRMED";
                                            } else if ($row['qualification'] == "DROPPED") {
                                                $qualificationCSS = "badge badge-danger";
                                                $leadQualification = "DROPPED";
                                            }  else {
                                                $qualificationCSS = "badge badge-warning";
                                                $leadQualification = $row['qualification'];
                                            }
                                            if ($row['status'] == "MILD") $leadStatusCSS = "badge badge-secondary";
                                            else if ($row['status'] == "HOT") $leadStatusCSS = "badge badge-success";
                                            else if ($row['status'] == "COLD") $leadStatusCSS = "badge badge-primary";
                                            echo "
                                                <tr  class='tAC'>
                                                <td > " . $leadId  . "</a></td>
                                                <td ><a class='tCB' href='#' onclick='showDetails(this.id)' id = " . $leadId . "> " . $leadName  . "</a></td> 
                                                <td >" . $leadcontactNo . "</td>
                                                <td >" . $leadEmail . "</td>
                                                <td>" . $leadCity . "</td>
                                                <td> <span class='" . $leadStatusCSS . "'>" . $row["status"]  . "</span></a></td> 
                                                <td><span class='" . $qualificationCSS . "'>" .  $leadQualification . "</span></td>
                                                <td>" . $row['academicYear'] . "</td>
                                                <td class='project-actions'>
                                                <a class='btn btn-primary btn-sm' href='#' onclick='showDetails(this.id)' id = " . $leadId . " title='click hear to view Lead Details'>
                                                            <i class='fas fa-eye'>
                                                            </i>
                                                        </a>
                                                        <a class='btn btn-secondary btn-sm' href='#' title='Click here to Edit Details.' onclick='editDetails($leadId)' >
                                                        <i class='fas fa-user-edit'>
                                                    </i>
                                                </a>";
                                            echo "
                                                </td>
                                                </tr> 
                                            ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="manageLead.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    $(function() {

        $('.select2').select2();
        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();
                selectedLeadQualification = getSelectValues('', document.getElementById("filterLeadQualificartion")).trim();

                var rowAcademicYear = data[6].trim();
                var rowLeadQualification = data[5].trim();

                if (selectedAcademicYear != '') {
                    inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ? rowAcademicYear : false;
                } else inStudAcademicYear = true;
                if (selectedLeadQualification != '') {
                    inStudLeadQualification = (selectedLeadQualification.indexOf(rowLeadQualification) != -1) ? rowLeadQualification : false;
                } else inStudLeadQualification = true;
                return inStudAcademicYear && inStudLeadQualification;


            }
        );
        $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
    loadDataDropdown("filterAyear", academicYearList);
</script>
<?php require '../../common/footer.php'; ?>