<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">UPCOMING PAYMENTS</h3>
                            <br>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">Filter By Due Date:</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control " id="dueDate" placeholder="Due Date" onchange="filterOtherDropDown('dueDate');" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#dueDate">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="upcomingPaymentTable">
                                <thead>
                                    <tr>
                                        <th width='5%'>STUDENT ID</th>
                                        <th width='15%'>NAME</th>
                                        <th width='15%'>DUE DATE</th>
                                        <th width='15%'>INSTALLMENT</th>
                                        <th width='10%'>AMOUNT</th>
                                        <th width='10%'>LATE PAYMENT CHARGES</th>
                                        <th width='15%'>PAYMENT STATUS</th>
                                        <th width='15'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from studentfeestructure WHERE (paymentStatus='PENDING' OR paymentStatus = 'ACCOUNTS APPROVAL PENDING') AND amount != '0' AND paymentType NOT LIKE '%STATUATORY FEE%' ORDER BY STR_TO_DATE(installmentDate, '%d/%m/%Y');";
                                    $result = $conn->query($sql);
                                    $paymentStatusCss = '';
                                    $payButtonCss = '';
                                    $latePaymentCharge = '';
                                    $chargeForPaymentType = '';
                                    $chargeFor = '';
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $studentId = $row['studentId'];
                                            $studentFirstName = $row['studentFirstName'];
                                            $studentLastName = $row['studentLastName'];
                                            $studentName = $studentFirstName . ' ' . $studentLastName;
                                            $paymentDate = $row['installmentDate'];
                                            $paymentType = '"' . $row['paymentType'] . '"';
                                            $amount = '"' . $row['amount'] . '"';
                                            $feeStructureId = '"' . $row['feeStructureId'] . '"';
                                            $feeStructureRowId = '"' . $row['feeStructureRowId'] . '"';
                                            $paymentChargeFor = $row['paymentChargeFor'];

                                            if ($row['paymentStatus'] == 'PENDING') {
                                                $paymentStatusCss = "badge badge-danger";
                                                $payButtonCss = "";
                                            } else if ($row['paymentStatus'] == 'ACCOUNTS APPROVAL PENDING') {
                                                $payButtonCss = "disabled";
                                                $paymentStatusCss = "badge badge-warning";
                                            }
                                            date_default_timezone_set('Asia/Kolkata');
                                            $currentDate = date("d-m-Y");

                                            $currentDateArray = explode('-', $currentDate);
                                            $currentDate1 = $currentDateArray[2] . '-' . $currentDateArray[1] . '-' . $currentDateArray[0];

                                            if ($paymentDate == '') $paymentDate = $currentDateArray[0] . '/' . $currentDateArray[1] . '/' . $currentDateArray[2];
                                            $dueDateArray = explode('/', $paymentDate);
                                            $dueDate1 = $dueDateArray[2] . '-' . $dueDateArray[1] . '-' . $dueDateArray[0];

                                            $currentDate2 = date_create($currentDate1);
                                            $dueDate2 = date_create($dueDate1);
                                            // print_r($currentDate2);

                                            $diff = date_diff($dueDate2, $currentDate2);
                                            $dateDifference = $diff->format("%R%a");


                                            $sql2 = "SELECT * from studentfeestructure WHERE feeStructureRowId = '$paymentChargeFor';";
                                            $result2 = $conn->query($sql2);
                                            if ($result2->num_rows > 0) {
                                                while ($row2 = $result2->fetch_assoc()) {
                                                    $chargeForPaymentType = $row2['paymentType'];
                                                    $chargeForPaymentType1 = '"' . $row2['paymentType'] . '"';
                                                }
                                            }


                                            if (intVal(($dateDifference - 7)) > 0 && $row['paymentType'] != 'LATE PAYMENT CHARGE') {
                                                $latePaymentCharge = ($dateDifference - 7) * 100;
                                            } else $latePaymentCharge = 0;

                                            if ($paymentChargeFor != '') {
                                                $chargeFor = '-' . '(' . $chargeForPaymentType . ')';
                                            } else $chargeFor = '';

                                            echo "
                                                <tr  class='tAC'>
                                                    <td id = " . $studentId . "> " . $studentId  . "</td>
                                                    <td>" . $studentName . "</td>
                                                    <td>" . $row['installmentDate'] . "</td>
                                                    <td>" . $row['paymentType'] . $chargeFor . "</td>
                                                    <td>" . $row['amount']  . "</td>
                                                    <td>" . $latePaymentCharge . "</td>
                                                    <td><span class = '$paymentStatusCss'>" . $row['paymentStatus']  . "<span></td>
                                                    <td><a class='btn btn-primary btn-sm fS18 $payButtonCss' title='Click hear to pay' id = " . $studentId . " onclick='payNow(this.id,$feeStructureRowId,$feeStructureId,$latePaymentCharge)'>
                                                        <i class='fas fa-rupee-sign fS15'></i> Receive
                                                        </a>
                                                        ";
                                            if ($row['paymentType'] == 'LATE PAYMENT CHARGE' && $row['paymentStatus'] == 'PENDING') {
                                                echo "<a class='btn btn-danger btn-sm fS20' title='Click hear to pay' id = " . $studentId . " onclick='deleteLatePayment(this.id,$feeStructureRowId,$feeStructureId,$amount,$chargeForPaymentType1)'>
                                                            <i class='fas fa-trash-alt fS20' style='font-size: 20px;height: 23px;color:#fff;margin-top: 2px;'></i></a>";
                                            }
                                            echo "
                                                    </td>                                           
                                                </tr>
                                            ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="upcomingPayment.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    $(function() {
        $('#dueDate').daterangepicker({
            autoApply: true,
            "alwaysShowCalendars": true,
            locale: {
                format: 'DD/MM/YYYY',
            },
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                    .endOf('month')
                ]
            },
        });
        $('#dueDate').val("");


        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("dueDate").value;
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[2]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ? (moment(empStartDate).isSameOrAfter(dateRangeStart) && moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                }
                return inEmpStartingDateRange;
            }
        );
    });
</script>

<?php require '../../common/footer.php'; ?>