<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {

    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">UPLOAD TUITION FEE RECEIPT</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="feeReceiptTable">
                                <thead>
                                    <tr>
                                        <th style="width:7%;">
                                            STUDENT ID
                                        </th>
                                        <th style="width:15%;">
                                            STUDENT NAME
                                        </th>
                                        <th style="width:10%;">
                                            RECEIVABLE PAYMENT DATE
                                        </th>
                                        <th style="width:15%;">
                                            PAYMENT TYPE
                                        </th>
                                        <th style="width:10%;">
                                            AMOUNT
                                        </th>
                                        <th style="width:8%;">
                                            STATUS
                                        </th>
                                        <th style="width:15%;">
                                            UPLOAD RECEIPT
                                        </th>
                                        <th style="width:10%;">
                                            PREVIEW
                                        </th>
                                        <th style="width:10%;">
                                            SAVE
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from paymenthistory WHERE paymentPurpose = 'TUITION FEE' AND paymentStatus = 'APPROVED' ORDER BY paymentId desc; ";
                                    $result = $conn->query($sql);

                                    $index = 0;
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $paymentId =  $row["paymentId"];
                                            $studentId = $row['studentId'];

                                            $receiptButtonId = '"' . 'receiptButton' . $index . '"';
                                            $receiptId = '"' . 'tuitionFeeReceipt' . $index . '"';
                                            $receiptPreviewId = '"' . 'tuitionFeeReceiptPreview' . $index . '"';
                                            $saveButtonId = '"' . 'saveButton' . $index . '"';
                                            $receiptErrorMessageId = '"' . 'receiptErrorMessage' . $index . '"';
                                            $receiptSuccessMessageId = '"' . 'receiptSuccessMessage' . $index . '"';
                                            $paymentDescription = '"' . $row['paymentDescription'] . '"';

                                            echo "
                                                <tr  class='tAC'>
                                                    <td >" . $row['studentId'] . "</td>
                                                    <td >" . $row['firstName'] . ' ' . $row['lastName'] . "</a></td>
                                                    <td >" . $row['paymentDate'] . "</td>
                                                    <td >" . $row['paymentPurpose'] . ' (' . $row['paymentDescription'] . ')' . "</td>
                                                    <td >" . $row['amount'] . "</td>";
                                            if ($row['tuitionFeeReceipt'] == '') {
                                                echo "<td><span class = 'badge badge-danger'>PENDING</span></td>";
                                            } else {
                                                echo "<td><span class = 'badge badge-success'>UPLOADED</span></td>";
                                            }
                                            echo "<td><label class='btn btn-primary' id = $receiptButtonId> Select File
                                                        <input type='file' accept='application/pdf' id=$receiptId onchange='loadReceiptFile(event,$receiptPreviewId)' hidden>
                                                        </label>
                                                    </td>
                                                    <td><div id=$receiptPreviewId></div></td>
                                                    <td>
                                                        <input type='button' class='btn btn-primary' value='Save' onclick='saveTuitionFeeReceipt(this.id,$receiptButtonId,$receiptId,$receiptErrorMessageId,$receiptSuccessMessageId,$paymentId,$studentId,$paymentDescription)' id='$saveButtonId' />
                                                        <p id=$receiptErrorMessageId class='text-center'
                                                        style='color: red; font-size: 1.0em;   text-align: center;'>
                                                        </p>
                                                        <p id=$receiptSuccessMessageId class='text-center'
                                                        style='color: green; font-size: 1.0em;   text-align: center;'>
                                                        </p>
                                                    </td>
                                                </tr>";
                                            $index += 1;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="pendingTuitionFeeReceipt.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    $(function() {
        $("#feeReceiptTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>
<?php require '../../common/footer.php'; ?>