<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';

$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">PENDING FEE STRUCTURE</h3>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">Filter By Academic Year</label>
                                        <select class="Select2" multiple="multiple" id="filterAyear" style="width: 100%;" onchange="filterOtherDropDown('studAyear');" data-placeholder="SELECT ACADEMIC YEAR">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label class="fS13">Filter By Year</label>
                                        <select class="select2" multiple="multiple" id="filterYer" style="width: 100%;" onchange="filterOtherDropDown('studYear');" data-placeholder="SELECT YEAR">
                                            <option>FIRST YEAR</option>
                                            <option>SECOND YEAR</option>
                                            <option>THIRD YEAR</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingFeeStructureTable">
                                <thead>
                                    <tr>
                                        <th width='10%'>STUDENT ID</th>
                                        <th width='20%'>NAME</th>
                                        <th width='15%'>ACADEMIC YEAR</th>
                                        <th width='15%'>CURRENT YEAR</th>
                                        <th width='20%'>YEAR</th>
                                        <th width='20%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sr = 0;
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT ls.studentId,ls.firstname,ls.lastname,ls.firstYearFeeStructure,ls.secondYearFeeStructure,ls.thirdYearFeeStructure,sf.academicYear from loginstudents ls INNER JOIN studentfee sf ON ls.studentId = sf.studentId WHERE ls.admissionStatus='CONFIRMED' AND (ls.firstYearFeeStructure = 'PENDING' OR ls.secondYearFeeStructure = 'PENDING' OR ls.thirdYearFeeStructure = 'PENDING') ORDER BY ls.studentId DESC;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $year = '';
                                            $yearCss = '';
                                            $studentCurrentYear = '';
                                            $currentYearOfStudent = '';
                                            $studentAcademicYear = '';
                                            $academicYear = '';
                                            $yearOfStudent = '';
                                            $yearFlag = '';

                                            $studentId = $row['studentId'];
                                            $studentName = $row['firstname'] . ' ' . $row['lastname'];
                                            $firstYearFeeStructure = $row['firstYearFeeStructure'];
                                            $secondYearFeeStructure = $row['secondYearFeeStructure'];
                                            $thirdYearFeeStructure = $row['thirdYearFeeStructure'];
                                            $studentAcademicYear = $row['academicYear'];
                                            $academicYear = explode('-', $studentAcademicYear);

                                            if ($firstYearFeeStructure == 'PENDING' && $secondYearFeeStructure == '' && $thirdYearFeeStructure == '') {
                                                if (count($academicYear) > 1) {
                                                    $studentCurrentYear = ($academicYear[0]) . '-' . ($academicYear[0] + 1);
                                                }
                                                $year = 'FIRST YEAR';
                                                $yearCss = 'badge badge-warning';
                                                $yearFlag = 'firstYear';
                                            } else if ($firstYearFeeStructure == 'CREATED' && $secondYearFeeStructure == 'PENDING' && $thirdYearFeeStructure == '') {
                                                if (count($academicYear) > 1) {
                                                    $studentCurrentYear = ($academicYear[0] + 1) . '-' . ($academicYear[0] + 2);
                                                }
                                                $year = 'SECOND YEAR';
                                                $yearCss = 'badge badge-primary';
                                                $yearFlag = 'secondYear';
                                            } else if ($firstYearFeeStructure == 'CREATED' && $secondYearFeeStructure == 'CREATED' && $thirdYearFeeStructure == 'PENDING') {
                                                if (count($academicYear) > 1) {
                                                    $studentCurrentYear = ($academicYear[0] + 2) . '-' . ($academicYear[1]);
                                                }
                                                $year = 'THIRD YEAR';
                                                $yearCss = 'badge badge-success';
                                                $yearFlag = 'thirdYear';
                                            }

                                            $currentYearOfStudent = '"' . $studentCurrentYear . '"';
                                            $yearOfStudent = '"' . $year . '"';

                                            echo "
                                                    <tr  class='tAC'>
                                                        <td ><a class='tCW'  id = " . $studentId . "> " . $studentId  . "</a></td>
                                                        <td ><a class='tCW'  id = " . $studentId . "> " . $studentName  . "</a></td>
                                                        <td ><a class='tCW'  id = " . $studentId . "> " . $studentAcademicYear  . "</a></td>
                                                        <td ><a class='tCW'  id = " . 'currentYear' . "> " . $studentCurrentYear  . "</a></td>                                                  
                                                        <td ><span class = '$yearCss' id = " . 'year' . "> " . $year  . "</span></td>
                                                        <td ><a class='btn btn-info tCW' id=" . $studentId . " title='Click here to create fee structure.' 
                                                        onclick='createFeeStructure(this.id,$currentYearOfStudent,$yearOfStudent)'>Create
                                                        </a>
                                                        </td>
                                                </tr>
                                                ";
                                            $sr = $sr + 1;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js">
</script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js">
</script>
<script src="pendingFeeStructure.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    $(function() {
        $('.select2').select2();

        $("#pendingFeeStructureTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        loadDataDropdown("filterAyear", academicYearList);

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var selectedYear = document.getElementById("filterYer").value.trim();
                var selectedAyear = document.getElementById("filterAyear").value.trim();

                var rowStudentYear = data[4].trim();
                var rowStudentAyear = data[2].trim();
                if (selectedYear != '') {
                    inSelectedYear = (selectedYear.indexOf(rowStudentYear) !== -1) ? rowStudentYear : false;
                } else inSelectedYear = true;

                if (selectedAyear != '') {
                    inSelectedAyear = (selectedAyear.indexOf(rowStudentAyear) !== -1) ? rowStudentAyear : false;
                } else inSelectedAyear = true;
                return inSelectedYear && inSelectedAyear;
            }
        );
    });
</script>
<?php require '../../common/footer.php'; ?>