<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">MANAGE FEE STRUCTURE</h3>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">Filter By Academic Year</label>
                                        <select class="Select2" multiple="multiple" id="filterAyear" style="width: 100%;" onchange="filterOtherDropDown('studAyear');" data-placeholder="SELECT ACADEMIC YEAR">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label class="fS13">Filter By Year</label>
                                        <select class="select2" multiple="multiple" id="filterYer" style="width: 100%;" onchange="filterOtherDropDown('studYear');" data-placeholder="SELECT YEAR">
                                            <option>FIRST YEAR</option>
                                            <option>SECOND YEAR</option>
                                            <option>THIRD YEAR</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="manageFeeStructureTable">
                                <thead>
                                    <tr>
                                        <th width='10%'>STUDENT ID</th>
                                        <th width='20%'>NAME</th>
                                        <th width='15%'>ACADEMIC YEAR</th>
                                        <th width='15%'>CURRENT YEAR</th>
                                        <th width='20%'>YEAR</th>
                                        <th width='20%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT distinct studentId,studentFirstName,studentLastName,academicYear,currentYear,year,feeStructureId FROM studentfeestructure ORDER BY studentId desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $editButtonCss = '';
                                            $yearCss = '';
                                            $studentCyear = '';

                                            $studentId = $row['studentId'];
                                            $studentName = $row['studentFirstName'] . ' ' . $row['studentLastName'];
                                            $studentAcademicYear = $row['academicYear'];
                                            $studentCurrentYear = $row['currentYear'];
                                            $year = $row['year'];
                                            $feeStructureId = $row['feeStructureId'];

                                            $studentCyear = '"' . $studentCurrentYear . '"';
                                            $yearOfStudent = '"' . $year . '"';

                                            if ($year == 'FIRST YEAR') $yearCss = 'badge badge-warning';
                                            if ($year == 'SECOND YEAR') $yearCss = 'badge badge-primary';
                                            if ($year == 'THIRD YEAR') $yearCss = 'badge badge-success';

                                            $feeStructureList = [];
                                            $sql2 = "SELECT * FROM studentfeestructure WHERE feeStructureId = '$feeStructureId';";
                                            $result2 = $conn->query($sql2);
                                            if ($result2->num_rows > 0) {
                                                while ($row2 = $result2->fetch_assoc()) {
                                                    array_push($feeStructureList, $row2);
                                                }
                                            }

                                            // for ($i = 0; $i < count($feeStructureList); $i++) {
                                            //     if ($feeStructureList[$i]['paymentStatus'] != 'PENDING' || $feeStructureList[$i]['paymentType'] == 'CHEQUE BOUNCE CHARGE' || $feeStructureList[$i]['paymentType'] == 'LATE PAYMENT CHARGE') {
                                            //         $editButtonCss = 'disabled';
                                            //     }
                                            // }

                                            echo "
                                                <tr  class='tAC'>
                                                    <td id = " . $studentId . "> " . $studentId  . "</td>
                                                    <td >" . $studentName . "</td>
                                                    <td >" . $studentAcademicYear . "</td>
                                                    <td >" . $studentCurrentYear . "</td>
                                                    <td ><span class = '$yearCss'>" . $year  . "</span></td>
                                                    <td><a class='btn btn-primary btn-sm' onclick='viewFeeStructure(this.id,$studentCyear,$yearOfStudent)' title='click hear to view fee structure' id = " . $studentId . ">
                                                        <i class='fas fa-eye'></i>
                                                        </a>
                                                        <a class='btn btn-warning btn-sm $editButtonCss' href='#' title='Click here to Edit Fee Structure.' onclick='editFeeStructure(this.id,$studentCyear,$yearOfStudent,$feeStructureId)' id = " . $studentId . ">
                                                        <i class='fas fa-edit'></i>
                                                        </a>
                                                        <a class='btn btn-danger btn-sm' href='#'  id = " . $feeStructureId . " title='click hear to Delete Fee Structure' onclick='deleteFeeStructure(this,$feeStructureId,$yearOfStudent,$studentId)' >
                                                            <i class='fas fa-trash-alt'></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="manageFeeStructure.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;

    $(function() {
        $('.select2').select2();

        $("#manageFeeStructureTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var selectedYear = document.getElementById("filterYer").value.trim();
                var selectedAyear = document.getElementById("filterAyear").value.trim();

                var rowStudentYear = data[4].trim();
                var rowStudentAyear = data[2].trim();
                if (selectedYear != '') {
                    inSelectedYear = (selectedYear.indexOf(rowStudentYear) !== -1) ? rowStudentYear : false;
                } else inSelectedYear = true;

                if (selectedAyear != '') {
                    inSelectedAyear = (selectedAyear.indexOf(rowStudentAyear) !== -1) ? rowStudentAyear : false;
                } else inSelectedAyear = true;
                return inSelectedYear && inSelectedAyear;
            }
        );

        loadDataDropdown("filterAyear", academicYearList);
    });
</script>

<?php require '../../common/footer.php'; ?>