<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">ALL INVOICES</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingInvoiceTable">
                                <thead>
                                    <tr>
                                        <th>
                                            ASSIGNMENT ID
                                        </th>
                                        <th>
                                            SEMESTER
                                        </th>
                                        <th>
                                            SUBJECT
                                        </th>
                                        <th>
                                            UNIT NO
                                        </th>
                                        <th>
                                            TOTAL AMOUNT
                                        </th>
                                        <th>
                                            PENALTY AMOUNT
                                        </th>
                                        <th>
                                            FINAL AMOUNT
                                        </th>
                                        <th>
                                            FACULTY NAME
                                        </th>
                                        <th>
                                            INVOICE STATUS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT ac.accountsId,ac.assignmentId,a.semester,a.subjectName,a.facultyId,a.facultyName,ac.unitNo,ac.totalAmount,ac.penaltyAmount,ac.invoice,ac.approvedExecutionMinutes,a.tableunitno FROM f_accounts as ac ,f_assignment as a where a.assignmentId=ac.assignmentId AND a.tableunitno = ac.unitNo AND ac.invoice = 'PENDING' GROUP BY a.assignmentId,a.tableunitno ORDER BY ac.accountsId DESC";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $tempPendingAmount = '';
                                            $tempPenaltyAmount = '';
                                            $invoice = '';
                                            $facultyId = '';
                                            $invoiceCss = '';

                                            $tempPendingAmount = $row['totalAmount'];
                                            $tempPenaltyAmount = $row['penaltyAmount'];
                                            $invoice = $row['invoice'];
                                            $facultyId = $row['facultyId'];
                                            $finalAmount = intVal($tempPendingAmount) - intVal($tempPenaltyAmount);

                                            if($row['invoice']!= 'PENDING')
                                            {
                                                $invoiceFile = $invoice;
                                                $invoice = "CREATED";
                                                $invoiceCss = "badge badge-success fS13";
                                            }
                                            else $invoiceCss = "badge badge-danger fS13";

                                            echo "
                                            <tr  class='tAC'>
                                                <td>" . $row['assignmentId']. "</td>
                                                <td>" . $row["semester"] . "</td>
                                                <td>" . $row["subjectName"] . "</td>
                                                <td>" . $row["unitNo"] . "</td>
                                                <td>" . $row["totalAmount"] . "</td>
                                                <td>" . $row["penaltyAmount"] . "</td>
                                                <td>" . $finalAmount . "</td>
                                                <td>" . $row["facultyName"] . "</td>
                                                <td><span class = '".$invoiceCss."'>" . $invoice . "</span></td>
                                            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
$(function() {
    $("#pendingInvoiceTable").DataTable({
        "responsive": true,
        "autoWidth": false,
        "aLengthMenu": [
            [5, 10, 25, 50, 75, -1],
            [5, 10, 25, 50, 75, "All"]
        ],
        "pageLength": 20,
        "aaSorting": [],
    });
});
</script>
<?php require '../../common/footer.php'; ?>