<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">PENDING PAYMENT</h3>
                        </div>

                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingPaymentTable">
                                <thead>
                                    <tr>
                                        <th>
                                            ASSIGNMENT ID
                                        </th>
                                        <th>
                                            UNIT NO
                                        </th>
                                        <th>
                                            SEMESTER
                                        </th>
                                        <th>
                                            SUBJECT
                                        </th>
                                        <th>
                                            FACULTY NAME
                                        </th>
                                        <th>
                                            PENDING AMOUNT
                                        </th>
                                        <th>
                                            FULL PAYMENT
                                        </th>
                                        <th>
                                            DISBURSAL AMOUNT
                                        </th>
                                    </tr>
                                </thead>
                                <tbody id="paymentTablebody">
                                    <?php
                                    require_once '../../common/connectToDB.php';

                                    $sql = "SELECT fgp.accountsId,fgp.assignmentId,fgp.unitNo,fgp.pendingTaxAmount,fgp.totalTaxAmount,fgp.flag,fa.semester,fa.subjectName,fa.facultyName,fa.facultyId,fgp.paymentStatus FROM f_gst_payment fgp,f_assignment fa WHERE fa.assignmentId = fgp.assignmentId AND fa.tableunitno = fgp.unitNo AND fgp.flag = 'PENDING' AND fgp.paymentStatus='PENDING AT ACCOUNTS' GROUP BY fa.assignmentId, fa.tableunitno ORDER by fa.assignmentId DESC";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $facultyId = '';
                                            $id = $row['accountsId'];
                                            $facultyId = $row['facultyId'];

                                            if ($row['paymentStatus'] == 'PENDING AT ACCOUNTS') {
                                                $hidBtn = '';
                                            } else {
                                                $hidBtn = 'hidden';
                                            }


                                            echo "
                                            <tr class='tAC'>
                                                <td>" . $row['assignmentId'] . "</td>
                                                <td>" . $row["unitNo"] . "</td>
                                                <td>" . $row["semester"] . "</td>
                                                <td>" . $row["subjectName"] . "</td>
                                                <td>" . $row["facultyName"] . "</td>
                                                <td>" . $row["pendingTaxAmount"] . "</td>
                                                <td><input type='checkbox'  id='fullPayment' onclick='copyFullPayment()'></td>
                                                <td><input type='text' value='' class='form-control' id='amount' name='disburse'></td>
    
                                            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="card-footer tAC">
                            <div class="form-group mt-5">
                                <p id='successMessage' class="text-center tAC" style="color: #25C032; font-size: 1em;   text-align: center;">
                                </p>
                                <p id='errorMessage' class="form-group text-center " style="color: red; font-size: 1.2em;   text-align: center;">
                                </p>
                                <a class='btn btn-success btn-md' href='#' onclick="generateExcel('report01')" title="Click to Download the report in Excel Format">Download Excel &nbsp;
                        <i class='fas fa-file-excel'>
                        </i>
                    </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="allPendingGstPayments.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    // $(function() {
    //     $("#pendingPaymentTable").DataTable({
    //         "responsive": true,
    //         "autoWidth": false,
    //         "aLengthMenu": [
    //             [5, 10, 25, 50, 75, -1],
    //             [5, 10, 25, 50, 75, "All"]
    //         ],
    //         "pageLength": 20,
    //         "aaSorting": [],
    //     });
    // });
</script>
<?php require '../../common/footer.php'; ?>