var paymentDate = '',
    companyBankName = '',
    transactionId = '',
    amountPaid = '',
    facultyPendingPayment = '',
    assignmentId = '',
    facultyName = '',
    unitNo = '',
    facultyBankName = '',
    companyAccountNo = '',
    paymentNotesText = '';

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext.toUpperCase();
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "companyBankName") dummyOptions(theSelect, options, "BANK NAME");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("companyBankName")) {
            options.value = results[i].accountNo.toUpperCase();
            options.text = results[i].bankName.toUpperCase();
            theSelect.add(options);
        }
    }
}

function loadAccountNo(element, f) {
    var text = element[element.selectedIndex].value.trim();
    if (text != 'SELECT BANK NAME') document.getElementById("companyBankAccountNo" + f).value = text;
    else document.getElementById("companyBankAccountNo" + f).value = '';
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function setHeaders() {
    paymentDate = '';
    companyBankName = '';
    transactionId = '';
    amountPaid = '';
    facultyPendingPayment = '';
    assignmentId = '';
    facultyName = '';
    unitNo = '';
    facultyBankName = '';
    companyAccountNo = '';
    paymentNotesText = '';

    paymentDate = $("#paymentDate").find("input").val();
    tempSelect = document.getElementById("companyBankName");
    companyBankName = tempSelect[tempSelect.selectedIndex].text.trim();
    transactionId = document.getElementById("transactionId").value.trim();
    amountPaid = document.getElementById('amountpaid').value.trim();
    facultyPendingPayment = document.getElementById('facultyPendingAmount').value.trim();
    assignmentId = document.getElementById('assignmentId').value.trim();
    facultyName = document.getElementById('facultyName').value.trim();
    unitNo = document.getElementById('unitNo').value.trim();
    facultyBankName = document.getElementById('facultyBankName').value.trim();
    companyAccountNo = document.getElementById('companyBankAccountNo').value.trim();
    paymentNotesText = document.getElementById('paymentNotesText').value.trim();
}

function formValidation() {
    if (setHeaders() == 0) return 0;

    if (paymentDate == '') {
        showError('paymentDate', '#ff6666', "Payment Date cannot be Blank.");
        return 0;
    } else showError('paymentDate', '', '');

    if (companyBankName == 'SELECT BANK NAME') {
        showError('companyBankName', '#ff6666', "Please Select Valid company Bank Name.");
        return 0;
    } else showError('companyBankName', '', '');

    if (transactionId == '') {
        showError('transactionId', '#ff6666', "Transaction Id cannot be Blank.");
        return 0;
    } else showError('transactionId', '', '');

    if (amountPaid == '') {
        showError('amountpaid', '#ff6666', "Enter Amount Paid.");
        return 0;
    } else showError('amountpaid', '', '');

    if (amountPaid < 0) {
        showError('amountpaid', '#ff6666', "Amount Paid cannot be negative.");
        return 0;
    } else showError('amountpaid', '', '');

    if (amountPaid == 0) {
        showError('amountpaid', '#ff6666', "Amount Paid cannot be negative.");
        return 0;
    } else showError('amountpaid', '', '');

    if (parseInt(amountPaid) > parseInt(facultyPendingPayment)) {
        showError('amountpaid', '#ff6666', "Amount Paid cannot be greater than pending payment.");
        return 0;
    } else showError('amountpaid', '', '');

    if (parseInt(amountPaid) != parseInt(facultyPendingPayment)) {
        showError('amountpaid', '#ff6666', "Amount Paid should be equal to pending payment.");
        return 0;
    } else showError('amountpaid', '', '');
    if (makeArray() == 0) return 0;
    return 1;
}

function makeArray() {
    paymentContentArray = [];
    var obj = {
        'FaccountsId': FaccountsId,
        'assignmentId': assignmentId,
        'facultyName': facultyName,
        'facultyId': facultyId,
        'unitNo': unitNo,
        'facultyBankName': facultyBankName,
        'facultyAccountNo': facultyAccountNo,
        'facultyBranchName': facultyBranchName,
        'paymentDate': paymentDate,
        'companyBankName': companyBankName,
        'companyAccountNo': companyAccountNo,
        'transactionId': transactionId,
        'amountPaid': amountPaid,
        'paymentNotesText': paymentNotesText,
    }
    paymentContentArray.push(obj);
    return 1;
}

function savePayment() {
    var saveFlag = "savePayment";
    if (formValidation() == 0) return;
    document.getElementById('savePayment').disabled = true;
    if (checkOnline() == false) return;
    else {
        if (confirm("Are you sure you want to save this Payment??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Payment. Please wait...';
            document.getElementById("savePayment").disabled = true;
            $.post('saveGSTpayment.php', {
                'saveFlag': saveFlag,
                'contentArray': paymentContentArray,
            }, function (data) {
                document.getElementById('successMessage').innerHTML = 'Payment saved Successfully...';
                document.getElementById("savePayment").disabled = true;
            });
        }
        else document.getElementById("savePayment").disabled = false;
    }
}