<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PAYMENT HISTORY</h3>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY USER STATUS</label>
                                        <select class="select2" multiple="multiple" id="userStatusFilter" data-placeholder="SELECT USER STATUS" style="width: 100%;" onchange="filterOtherDropDown('statusOfuser')" ;>
                                            <option value='ACTIVE' selected>ACTIVE</option>
                                            <option value='BLOCKED'>BLOCKED</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY PAYMENT DATE</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control " id="paymentDateFilter" placeholder="FROM TO DATE" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#paymentDateFilter" data-toggle="daterangepicker">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingValidationTable">
                                <thead>
                                    <tr>
                                        <th style="width:10%;">
                                            PAYMENT DATE
                                        </th>
                                        <th style="width:20%;">
                                            PAYMENT TYPE
                                        </th>
                                        <th style="width:10%;">
                                            PAYMENT ID
                                        </th>
                                        <th style="width:10%;">
                                            EMPLOYEE ID
                                        </th>
                                        <th style="width:15%;">
                                            EMPLOYEE NAME
                                        </th>

                                        <th style="width:10%;">
                                            DESIGNATION
                                        </th>
                                        <th style="width:5%;">
                                            STATUS
                                        </th>

                                        <th style="width:10%;">
                                            AMOUNT
                                        </th>
                                        <th style="width:10%;">
                                            ACTION
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from user_paymenthistory WHERE validationStatus = 'COMPLETED' ORDER BY paymentId desc; ";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $paymentPurpose = '';

                                            $paymentId = '"' . $row['paymentId'] . '"';
                                            $salaryMonth = '"' . $row['salaryMonth'] . '"';
                                            $payablePaymentId = $row['paymentId'];
                                            $userId = $row['userId'];
                                            $paymentDate = str_replace('-', "/", $row['paymentDate']);

                                            if ($row['paymentDescription'] == 'COLLEGE PAYMENT') $paymentPurpose = ' (' . $row['paymentPurpose'] . ')';
                                            else $paymentPurpose = '';

                                            $sql3 = "SELECT * FROM logindetail Where userid='$userId';";
                                            $result3 = $conn->query($sql3);
                                            if ($result3->num_rows > 0) {
                                                while ($row3 = $result3->fetch_assoc()) {
                                                    $user_status = $row3['userStatus'];
                                                    if ($row3["userStatus"] == 'BLOCKED') $statusCss = 'badge badge-danger';
                                                    if ($row3["userStatus"] == 'ACTIVE') $statusCss = 'badge badge-success';
                                                }
                                            }


                                            echo "
                                                <tr  class='tAC'>
                                                <td >" . $paymentDate . "</td>
                                                <td >" . $row['paymentDescription'] . "</td>
                                                <td >" . $row['paymentId'] . "</td>
                                                <td >" . $row['userId'] . "</td>
                                                <td >" . $row['userName'] . "</td>
                                                <td >" . $row['userType'] . "</td>
                                                <td><span class = '" . $statusCss . "'>" . $user_status  . "</span></td>

                                                <td >" . $row['amountPaid'] . "</td>
                                                <td ><a class='btn btn-primary btn-sm' href='#' id='" . $row['userId'] . "' onclick='showPaymentDetails($userId,$paymentId,$salaryMonth)' title='click hear to view Payment Details'>
                                                        <i class='fas fa-eye'></i>
                                                    </a>
                                                    <a class='btn btn-warning btn-sm' href='#'id='" . $row['userId'] . "' title='Click here to Edit Payment.' onclick='editPayment($userId,$paymentId,$salaryMonth)'>
                                                        <i class='fas fa-edit'></i>
                                                    </a>
                                                </td>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="pendingEmployeePayment.js?v=<?php echo $fileVersion; ?>"></script>



<script>
    function showPaymentDetails(id, paymentId, salaryMonth) {
        encodedValue_id = btoa(id);
        encodedValue_paymentId = btoa(paymentId);
        encodedValue_salaryMonth = btoa(salaryMonth);
        window.location.href = "viewPaymentDetails.php?id=" + encodedValue_id + "&pID=" + encodedValue_paymentId + "&aM=" + encodedValue_salaryMonth;
    }

    function editPayment(id, paymentId, salaryMonth) {
        encodedValue_id = btoa(id);
        encodedValue_paymentId = btoa(paymentId);
        encodedValue_salaryMonth = btoa(salaryMonth);
        window.location.href = "editPaymentDetails.php?id=" + encodedValue_id + "&pID=" + encodedValue_paymentId + "&aM=" + encodedValue_salaryMonth;
    }


    $(function() {
        $('.select2').select2();

        $('#paymentDateFilter').daterangepicker({
            autoApply: true,
            "alwaysShowCalendars": true,
            locale: {
                format: 'DD/MM/YYYY',
            },
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                    .endOf('month')
                ],
            },
        });

        $("#paymentDateFilter").val("");
        $("#paymentDateFilter").change(function() {
            var table = $('#pendingValidationTable').DataTable();
            table.draw();
        });
        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("paymentDateFilter").value.trim();
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[0]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                } else inEmpStartingDateRange = true;

                selecteduserStatus = getSelectValues('', document.getElementById("userStatusFilter")).trim();

                    var rowuserStatus = data[6].trim();


                    if (selecteduserStatus != '') {
                        inuserStatus = (selecteduserStatus.indexOf(rowuserStatus) != -1) ? rowuserStatus : false;
                    } else inuserStatus = true;

                    return inuserStatus && inEmpStartingDateRange;

            }
        );
            $("#pendingValidationTable").DataTable({
                "responsive": true,
                "autoWidth": false,
                "aLengthMenu": [
                    [5, 10, 25, 50, 75, -1],
                    [5, 10, 25, 50, 75, "All"]
                ],
                "pageLength": 20,
                "aaSorting": [],
            });
    });


    function showIcon() {
        document.getElementById('dateIcon').hidden = true;
        document.getElementById('clearDate').hidden = false;
        document.getElementById('iconBackground').style.backgroundColor = '#ff6666';
    }

    function clearDate() {
        document.getElementById('paymentDateFilter').value = '';
        var element = document.getElementById('paymentDateFilter');
        var event = new Event('change');
        element.dispatchEvent(event);
        document.getElementById('dateIcon').hidden = false;
        document.getElementById('clearDate').hidden = true;
        document.getElementById('iconBackground').style.backgroundColor = '';
    }

    function filterOtherDropDown(flag) {

        var table = $('#pendingValidationTable').DataTable();
        table.draw();
    }

    function getSelectValues(flag, selectVar) {
        var result = "";
        var options = selectVar && selectVar.options;
        var opt;

        for (var i = 0, iLen = options.length; i < iLen; i++) {
            opt = options[i];
            if (flag == '') {
                if (opt.selected) {
                    result += opt.text;
                }
            }
            if (flag == "multiple") {
                if (opt.selected) {
                    result += opt.text + "|";
                }
            }
        }
        return result.trim();
    }
</script>
<?php require '../../common/footer.php'; ?>