<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';

$masterSemester = [];
$sql = "SELECT * FROM semester";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterSemester, $row);
    }
}

$masterSubjectName = [];
$sql2 = "SELECT * FROM subjects;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($masterSubjectName, $row2);
    }
}
$academicYearList = [];
$sql2 = "SELECT DISTINCT academicYear FROM batchmaster ORDER BY batchId";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($academicYearList, $row2);
    }
}
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">ALL INVOICES</h3>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Semester</label>
                                        <select class="form-control custom-select" id="semester" style="width: 100%;" onchange="filterOtherDropDown('semester');">
                                            <option disabled selected>SELECT SEMESTER</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Subject Name</label>
                                        <select class="form-control custom-select" id="subjectName" style="width: 100%;" onchange="filterOtherDropDown('subject');">
                                            <option selected>SELECT SUBJECT</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Academic Year</label>
                                        <select class="form-control custom-select" id="academicYear" style="width: 100%;" onchange="filterOtherDropDown('aYear');">
                                            <option selected>SELECT ACADEMIC YEAR</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="allInvoiceTable">
                                <thead>
                                    <tr>
                                        <th>
                                            ASSIGNMENT ID
                                        </th>
                                        <th>
                                           ACADEMIC YEAR
                                        </th>
                                        <th>
                                            SEMESTER
                                        </th>
                                        <th>
                                            SUBJECT
                                        </th>
                                       
                                        <th>
                                            FINAL AMOUNT
                                        </th>
                                        <th>
                                            FACULTY NAME
                                        </th>
                                        <th>
                                            INVOICE STATUS
                                        </th>
                                        <th>
                                            ACTIONS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT b.bonusId,b.assignmentId,b.bonusValue,b.invoiceStatus,b.facultyId,b.facultyName,b.flag,b.invoice,a.academicYear,a.semester,a.subjectName,r.assignmentId, (SELECT (sum(r.noOfRatings)/count(r.noOfRatings))) as reviewNumber FROM f_bonus AS b,f_assignment AS a,review AS r WHERE a.assignmentId = b.assignmentId AND b.assignmentId = r.assignmentId AND b.invoice!=''  GROUP BY b.assignmentId;";

                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $tempPendingAmount = '';
                                            $tempPenaltyAmount = '';
                                            $invoice = '';
                                            $facultyId = '';
                                            $invoiceCss = '';

                                            $bonusValue = $row['bonusValue'];
                                            $invoice = $row['invoice'];
                                            $facultyId = $row['facultyId'];
                                            $assignmentId = $row['assignmentId'];
                                            $bonusId = $row['bonusId'];

                                            if ($row['invoice'] != 'PENDING') {
                                                $invoiceFile = $invoice;
                                                $invoice = "CREATED";
                                                $invoiceCss = "badge badge-success fS13";
                                            } else $invoiceCss = "badge badge-danger fS13";

                                            echo "
                                            <tr  class='tAC'>
                                                <td>" . $row['assignmentId'] . "</td>
                                                <td>" . $row['academicYear'] . "</td>
                                                <td>" . $row["semester"] . "</td>
                                                <td>" . $row["subjectName"] . "</td>
                                                <td>" . $bonusValue . "</td>
                                                <td>" . $row["facultyName"] . "</td>
                                                <td><span class = '" . $invoiceCss . "'>" . $invoice . "</span></td>";
                                            if ($invoice != "PENDING") {
                                                echo "<td>
                                                <a class='btn btn-primary btn-sm' target='_blank' id='' href='../../../dist/documents/facultyInvoices/$facultyId/$invoiceFile'>
                                                    <i class='fas fa-eye'></i>
                                                </a>&nbsp;
                                                

                                         
                                               
                                                </tr>";
                                            } else {
                                                echo "<td></td></tr>";
                                            }
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="allInvoices.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var masterSemester = <?php echo json_encode($masterSemester); ?>;
    var masterSubjectName = <?php echo json_encode($masterSubjectName); ?>;
    var academicYearList = <?php echo json_encode($academicYearList); ?>;
    $(function() {
        $("#allInvoiceTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedSemesterName = getSelectValues('', document.getElementById("semester")).trim();
                var rowSemesterName = data[2];

                if (selectedSemesterName != 'SELECT SEMESTER') {
                    inSemesterName = (selectedSemesterName.indexOf(rowSemesterName) !== -1) ? rowSemesterName :
                        false;
                } else inSemesterName = true;

                selectedSubjectName = getSelectValues('', document.getElementById("subjectName")).trim();
                var rowSubjectName = data[3];

                if (selectedSubjectName != 'SELECT SUBJECT') {
                    inSubjectName = (selectedSubjectName.indexOf(rowSubjectName) !== -1) ? rowSubjectName :
                        false;
                } else inSubjectName = true;

                
                selectedacademicYear = getSelectValues('', document.getElementById("academicYear")).trim();
                console.log(selectedacademicYear);
                var rowacademicYear = data[1];

                if (selectedacademicYear != 'SELECT ACADEMIC YEAR') {
                    inacademicYear = (selectedacademicYear.indexOf(rowacademicYear) !== -1) ? rowacademicYear :
                        false;
                } else inacademicYear = true;

                return inSemesterName && inSubjectName && inacademicYear;
            }
        );

        loadDataDropdown("semester", masterSemester);
        loadDataDropdown("subjectName", masterSubjectName);
        loadDataDropdown("academicYear", academicYearList);
    });
</script>
<?php require '../../common/footer.php'; ?>