// function showError(id, color, message) {
//     if (id != '')
//         document.getElementById(id).style.backgroundColor = color;
//     document.getElementById('errorMessage').innerHTML = message;
// }

// var bonusId = '',
//     assignmentId = '',
//     bonusAmount = '';

// function paymentValidation() {
//     bonusId = '';
//     assignmentId = '';
//     bonusAmount = '';

//     bonusId = document.getElementById('bonusId').value.trim();
//     assignmentId = document.getElementById('assignmentId').value.trim();
//     bonusAmount = document.getElementById('bonusAmount').value.trim();

//     if (bonusAmount == '') {
//         showError('bonusAmount', '#ff6666', "Bonus Amount cannot be blank.");
//         return 0;
//     } else showError('bonusAmount', '', '');

//     if (bonusAmount == 0) {
//         showError('bonusAmount', '#ff6666', "Bonus Amount can not be zero.");
//         return 0;
//     } else showError('bonusAmount', '', '');

//     if (bonusAmount < 0) {
//         showError('bonusAmount', '#ff6666', "Bonus Amount can not be negative.");
//         return 0;
//     } else showError('bonusAmount', '', '');
//     return 1;
// }

// function savePayment() {
//     document.getElementById('savePayment').disabled = true;
//     var saveFlag = 'saveBonus';
//     if (paymentValidation() == 0) {
//         document.getElementById('savePayment').disabled = false;
//         return;
//     }
//     $.post('saveBonus.php', {
//         'saveFlag': saveFlag,
//         'bonusAmount': bonusAmount,
//         'bonusId': bonusId,
//         'facultyName': facultyName,
//     }, function (data) {
//         document.getElementById('successMessage').innerHTML = 'Payment saved successfully.';
//         document.getElementById('savePayment').disabled = true;
//     });
// }

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext.toUpperCase();
}
function loadAccountNo(element, f) {
    var text = element[element.selectedIndex].value.trim();
    if (text != 'SELECT BANK NAME') document.getElementById("companyBankAccountNo" + f).value = text;
    else document.getElementById("companyBankAccountNo" + f).value = '';
}



function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "companyBankName") dummyOptions(theSelect, options, "BANK NAME");
    if (selectName == "semester") dummyOptions(theSelect, options, "SEMESTER");
    if (selectName == "subjectName") dummyOptions(theSelect, options, "SUBJECT");
    if (selectName == "academicYear") dummyOptions(theSelect, options, "ACADEMIC YEAR");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");

        if (selectName.includes("companyBankName")) {
            options.value = results[i].accountNo.toUpperCase();
            options.text = results[i].bankName.toUpperCase();
            theSelect.add(options);
        }
        else if (selectName.includes("semester")) {
            options.value = options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        
        } else if (selectName.includes("academicYear")) {
            options.value = options.text = results[i].academicYear;
            theSelect.add(options);
        }
    }
}

function calculate(element) {
    var tempFinalAmount = document.getElementById("bonusAmount").value;

    if (element.value == '') {
        showError(element.id, '#ff6666', "Amount Paid cannot be blank.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) == 0) {
        showError(element.id, '#ff6666', "Amount Paid cannot be zero.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) < 0) {
        showError(element.id, '#ff6666', "Amount Paid cannot be negative.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) > parseFloat(tempFinalAmount)) {
        showError(element.id, '#ff6666', "Amount Paid cannot be bigger than Final Amount.");
        return 0;
    } else showError(element.id, '', '');

    amountPendingLater = parseFloat(parseFloat(tempFinalAmount) - parseFloat(element.value)).toFixed(2);
    // console.log(amountPendingLater);
    tdsCalculate();
    return 1;
}


function tdsCalculate() {
    let tempValue = document.getElementById("amountpaid").value;
    if (tempValue == '') {
        showError("amountpaid", "#ff6666", 'Enter Paid Amount for TDS%.');
        return 0;
    } else if (parseFloat(document.getElementById("tdsPercent").value) < 0) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Negative.');
        return 0;
    } else if (parseFloat(document.getElementById("tdsPercent").value) >= 100) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Bigger than or equal to 100.');
        return 0;
    } else if (document.getElementById("tdsPercent").value != '') {
        document.getElementById("tdsAmount").value = parseFloat(parseFloat(tempValue) * (parseFloat(document.getElementById("tdsPercent").value) / 100)).toFixed(2);
        document.getElementById("reminderAmount").value = parseFloat(parseFloat(tempValue) - parseFloat(document.getElementById("tdsAmount").value)).toFixed(2);
    }
    showError('amountpaid', '', '');
    showError('tdsPercent', '', '');
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}


function setHeaders() {
    facultyBankName = '',
        paymentDate = '',
        companyBankName = '',
        companyAccountNo = '',
        transactionId = '',
        amountPaid = '',
        amountPending = '',
        tdsPercent = '',
        penaltyAmount = '',
        notesForPayment = '';

    facultyBankName = document.getElementById("facultyBankName").value.trim();
    paymentDate = $("#paymentDate").find("input").val();
    tempSelect = document.getElementById("companyBankName");
    companyBankName = tempSelect[tempSelect.selectedIndex].text.trim();
    companyAccountNo = document.getElementById("companyBankAccountNo").value.trim();
    transactionId = document.getElementById("transactionId").value.trim();
    amountPaid = document.getElementById("amountpaid").value.trim();
    tdsPercent = document.getElementById("tdsPercent").value.trim();
    notesForPayment = document.getElementById("paymentNotesText").value.trim();
    notesForPayment = escapeSpecialCharacters(notesForPayment);
    return 1;
}

function facultyBankDetails(facultyId) {
    facultyAccountNo = '',
        facultyBranchName = '';
    for (let i = 0; i < masterFacultyList.length; i++) {
        if (masterFacultyList[i].facultyId == facultyId) {
            document.getElementById("facultyBankName").value = masterFacultyList[i].bankName;
            facultyAccountNo = masterFacultyList[i].accountNo;
            facultyBranchName = masterFacultyList[i].branch;
        }
    }
}

function formValidation() {
    if (setHeaders() == 0) return 0;

    if (paymentDate == '') {
        showError('paymentDate', '#ff6666', "Payment Date cannot be Blank.");
        return 0;
    } else showError('paymentDate', '', '');

    if (companyBankName == 'SELECT BANK NAME') {
        showError('companyBankName', '#ff6666', "Please Select Valid company Bank Name.");
        return 0;
    } else showError('companyBankName', '', '');

    if (transactionId == '') {
        showError('transactionId', '#ff6666', "Transaction Id cannot be Blank.");
        return 0;
    } else showError('transactionId', '', '');

    if (calculate(document.getElementById("amountpaid")) == 0) return 0;
    if (tdsPercent == '') {
        showError('tdsPercent', '#ff6666', "Please Enter TDS Percent.");
        return 0;
    } else showError('tdsPercent', '', '');

    if (parseFloat(tdsPercent) > 100) {
        showError('tdsPercent', '#ff6666', "TDS Percent cannot be larger than 100%.");
        return 0;
    } else showError('tdsPercent', '', '');

    if (parseFloat(tdsPercent) < 0) {
        showError('tdsPercent', '#ff6666', "TDS Percent cannot be smaller than 0%.");
        return 0;
    } else showError('tdsPercent', '', '');

    facultyBankDetails(facultyId);

    if (makeArray() == 0) return 0;
    return 1;
}

function makeArray() {
    paymentContentArray = [];
    var obj = {
        'bonusId': bonusId,
        'facultyId': facultyId,
        'assignmentId': assignmentId,
        'facultyName': facultyName,
        'facultyBankName': facultyBankName,
        'facultyAccountNo': facultyAccountNo,
        'facultyBranchaName': facultyBranchName,
        'paymentDate': paymentDate,
        'companyBankName': companyBankName,
        'companyAccountNo': companyAccountNo,
        'transactionId': transactionId,
        'amountPaid': amountPaid,
        'amountPending': amountPendingLater,
        'tdsPercent': tdsPercent,
        'notes': notesForPayment,
    }
    paymentContentArray.push(obj);
    return 1;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");

    return output;
}

function savePayment() {
    var saveFlag = "savePayment";
    if (formValidation() == 0) return;
    document.getElementById('savePayment').disabled = true;
    if (checkOnline() == false) return;
  
    else {
        if (confirm("Are you sure you want to save this Payment??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Payment. Please wait...';
            document.getElementById("savePayment").disabled = true;
            $.post('saveBonusPayment.php', {
                'saveFlag': saveFlag,
                'contentArray': paymentContentArray,
            }, function (data) {
                console.log(data);
                document.getElementById('successMessage').innerHTML = 'Payment Done Successfully...';
                document.getElementById("savePayment").disabled = true;
            });
        }
        else document.getElementById("savePayment").disabled = false;
    }
}