var vendorUserId = "",
    vendorCompanyName = "",
    vendorEmailId = "",
    vendorPassword = "",
    vendorFirstName = "",
    vendorLastName = "",
    duplicatEmail = false,
    statement = '',
    flagForStatement = '';


const oldData = {
    vendorId: "",
    vendorCompanyName: "",
    vendorPassword: "",
    vendorEmail: ""
}

function loadOldValues() {
    oldData.vendorId = document.getElementById("vendorUserId").value.trim();
    oldData.vendorCompanyName = document.getElementById("vendorCompanyName").value.trim();
    oldData.vendorEmail = document.getElementById("vendorEmailId").value.trim();
    oldData.vendorPassword = document.getElementById("vendorPassword").value.trim();
}

function compareNewValuesWithOld() {
    statement = "UPDATE done in vendor Profile-ID " + oldData.vendorId + " Name " + oldData.vendorFirstName + " " + oldData.vendorLastName + ". ";
    var flagForStatement = 0;

    
    if (oldData.vendorCompanyName != vendorCompanyName) {
        flagForStatement = 1;
        statement = statement + "Company Name changed from " + oldData.vendorCompanyName + " to " + vendorCompanyName + "<br>";
    }
    if (oldData.vendorEmail != vendorEmailId) {
        flagForStatement = 1;
        statement = statement + "Email ID changed from " + oldData.vendorEmail + " to " + vendorEmailId + "<br>";
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    }
    return 1;
}

function checkDuplicate(emailId) {
    $.post('checkDuplicate.php', {
        'emailId': emailId
    },
        function (data) {
            if (data == 1) {
                showError('errorMessage', '', 'Duplicate email');
                document.getElementById("vendorEmailId").style.backgroundColor = "#ffc2b3";
                duplicatEmail = true;
                return duplicatEmail;
            } else {
                showError('errorMessage', '', '');
                document.getElementById("vendorEmailId").style.backgroundColor = "";
                duplicatEmail = false;
                return duplicatEmail;
            }
        }
    );
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function setHeaders() {
    vendorUserId = "";
    vendorCompanyName = '';
    vendorEmailId = '';
    vendorPassword = "";
    vendorFirstName = "";
    vendorLastName = "";

    vendorUserId = document.getElementById("vendorUserId").value.trim();
    vendorCompanyName = document.getElementById("vendorCompanyName").value.trim().toUpperCase();
    vendorEmailId = document.getElementById("vendorEmailId").value.trim();
    vendorPassword = document.getElementById("vendorPassword").value.trim();

    return 1;
}

function vendorValidation() {
   

    //vendor company name validation
    if (vendorCompanyName.length <= 0) {
        document.getElementById("vendorCompanyName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter company name");
        return 0;
    } else {
        document.getElementById("vendorCompanyName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //vendor EmailId validation
    if (vendorEmailId.length <= 0) {
        document.getElementById("vendorEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter email");
        return 0;
    } else {
        document.getElementById("vendorEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (!validateEmail(vendorEmailId)) {
        document.getElementById("vendorEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Email is not in correct format");
        // document.getElementById("errorMessage").style.display="block";
        return 0;
    } else {
        document.getElementById("vendorEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (duplicatEmail) {
        showError('errorMessage', '', 'Email Alredy Exist. Please Change it...');
        document.getElementById("vendorEmailId").style.backgroundColor = "#ffc2b3";
        return 0;
    } else {
        showError('errorMessage', '', '');
        document.getElementById("vendorEmailId").style.backgroundColor = "";
    }
    return 1;
}

function updateVendor() {
    document.getElementById('updateButton').disabled = true;
    if (setHeaders() == 0) return;
    if (vendorValidation() == 0) {
        document.getElementById('updateButton').disabled = false;
        return;
    }
    if (compareNewValuesWithOld() == 0) {
        document.getElementById('updateButton').disabled = false;
        return;
    }

    var flagForUpdate = "TRUE";
    if (confirm("Are you sure you want to update details?")) {
        document.getElementById('successMessage').innerHTML = "Saving Please Wait...";
        document.getElementById('updateButton').disabled = true;
        $.post('updateVendor.php', {
            'flagForUpdate': flagForUpdate,
            'vendorUserId': vendorUserId,
            'vendorCompanyName': vendorCompanyName,
            'vendorEmailId': vendorEmailId,
            'vendorPassword': vendorPassword,
            'logStatement': statement
        }, function (data) {
            document.getElementById('successMessage').innerHTML = "Saved successfully. Please wait page will get auto-refresh.";
            document.getElementById('updateButton').disabled = false;
            location.reload();
        });
    }
    else document.getElementById('updateButton').disabled = false;
}