var vendorUserId = "",
    vendorCompanyName = "",
    vendorEmailId = "",
    vendorPassword = "",
    vendorFirstName = "",
    vendorLastName = "",
    duplicatEmail = false;

    
// generate Random string
function randomString(length, chars) {
    var mask = '';
    if (chars.indexOf('a') > -1) mask += 'abcdefghijklmnopqrstuvwxyz';
    if (chars.indexOf('A') > -1) mask += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    if (chars.indexOf('#') > -1) mask += '0123456789';
    if (chars.indexOf('!') > -1) mask += '@#&*';
    var result = '';
    for (var i = length; i > 0; --i) result += mask[Math.floor(Math.random() * mask.length)];
    return result;
}

// email Validation
function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

// check email Duplication
function checkDuplicate(emailId) {
    $.post('checkDuplicate.php', {
        'emailId': emailId
    },
        function (data) {
            if (data == 1) {
                showError('errorMessage', '', 'Duplicate email');
                document.getElementById("vendorEmailId").style.backgroundColor = "#ffc2b3";
                duplicatEmail = true;
                return duplicatEmail;
            } else {
                showError('errorMessage', '', '');
                document.getElementById("vendorEmailId").style.backgroundColor = "";
                duplicatEmail = false;
                return duplicatEmail;
            }
        }
    );
}


function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}
function setHeaders() {
    vendorUserId = "";
    vendorCompanyName = '';
    vendorEmailId = '';
    vendorPassword = "";

    vendorUserId = document.getElementById("vendorUserId").value.trim();
    vendorCompanyName = document.getElementById("vendorCompanyName").value.trim().toUpperCase();
    vendorEmailId = document.getElementById("vendorEmailId").value.trim();
    vendorPassword = document.getElementById("vendorPassword").value.trim();

    return 1;
}
function vendorValidation() {
    
    //vendor company name validation
    if (vendorCompanyName.length <= 0) {
        document.getElementById("vendorCompanyName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter company name");
        return 0;
    } else {
        document.getElementById("vendorCompanyName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //vendor EmailId validation
    if (vendorEmailId.length <= 0) {
        document.getElementById("vendorEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter email");
        return 0;
    } else {
        document.getElementById("vendorEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (!validateEmail(vendorEmailId)) {
        document.getElementById("vendorEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Email is not in correct format");
        // document.getElementById("errorMessage").style.display="block";
        return 0;
    } else {
        document.getElementById("vendorEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (duplicatEmail) {
        showError('errorMessage', '', 'Email Alredy Exist. Please Change it...');
        document.getElementById("vendorEmailId").style.backgroundColor = "#ffc2b3";
        return 0;
    } else {
        showError('errorMessage', '', '');
        document.getElementById("vendorEmailId").style.backgroundColor = "";
    }
    return 1;
}
function saveVendor() {
    // document.getElementById('saveButton').disabled = true;
    if (setHeaders() == 0) return;
    if (vendorValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (confirm("Are you sure you want to save Details")) {
        document.getElementById('successMessage').innerHTML = "Saving Data Please Wait...";
        document.getElementById('saveButton').disabled = true;
        $.post('saveVendor.php', {
            'vendorUserId': vendorUserId,
            'vendorCompanyName': vendorCompanyName,
            'vendorEmailId': vendorEmailId,
            'vendorPassword': vendorPassword
        }, function (data) {
            console.log(data);
            document.getElementById('successMessage').innerHTML = "Data Saved successfully.";
            document.getElementById('saveButton').disabled = false;
            location.reload();
        });
    }
    else document.getElementById('saveButton').disabled = false;

}


function showDetails(VendorId) {
    encodedValue_VendorId = btoa(VendorId);
    encodedKey_VendorId = btoa('lId');
    window.location.href = "viewVendor.php?" + encodedKey_VendorId + "=" + encodedValue_VendorId;
}

function userEdit(VendorId) {
    encodedValue_VendorId = btoa(VendorId);
    encodedKey_VendorId = btoa('lId');
    window.location.href = "editVendor.php?" + encodedKey_VendorId + "=" + encodedValue_VendorId;
}