<?php
session_start();
if (isset($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">MANAGE SALARIES</h3>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group" style="margin-left: 21px;">
                                    <label class="fS13">FILTER BY USER STATUS</label>
                                    <select class="select2" multiple="multiple" id="userStatusFilter" data-placeholder="SELECT USER STATUS" style="width: 100%;" onchange="filterOtherDropDown('statusOfuser')" ;>
                                        <option value='ACTIVE' selected>ACTIVE</option>
                                        <option value='BLOCKED'>BLOCKED</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="manageAttendanceTable">
                                <thead>
                                    <tr>
                                        <th width='15%'>EMPLOYEE ID</th>
                                        <th width='20%'>EMPLOYEE NAME</th>
                                        <th width='25%'>DESIGNATION</th>
                                        <th width='10%'>SALARY MONTH</th>
                                        <th width='10%'>STATUS</th>
                                        <th width='10%'>PAY SLIP</th>
                                        <th width='15%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from user_payment where salaryStatus='COMPLETED' order by STR_TO_DATE(salaryAddTimeStamp,'%d-%m-%Y') desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $userId = $row['userid'];
                                            $paySlip = $row['paySlip'];

                                            $sql3 = "SELECT * FROM logindetail Where userid='$userId';";
                                            $result3 = $conn->query($sql3);
                                            if ($result3->num_rows > 0) {
                                                while ($row3 = $result3->fetch_assoc()) {
                                                    $user_status = $row3['userStatus'];
                                                    if ($row3["userStatus"] == 'BLOCKED') $statusCss = 'badge badge-danger';
                                                    if ($row3["userStatus"] == 'ACTIVE') $statusCss = 'badge badge-success';
                                                }
                                            }

                                            $attendanceMonth = date("F Y", strtotime($row['dateOfJoining']));
                                            $attendance1 = '"' . $attendanceMonth . '"';
                                            $attendance1 = '"' . $attendanceMonth . '"';
                                            $noOfPayableDays = '"' . $row['noOfPayableDays'] . '"';


                                            echo "<tr  class='tAC'>
                                            <td > " . $row['userid']  . "</td>
                                            <td > " . $row['userName'] . "</td>
                                            <td > " . $row['user_type']  . "</td>
                                            <td > " . $attendanceMonth  . "</td>
                                            <td><span class = '" . $statusCss . "'>" . $user_status  . "</span></td>
                                            <td>
                                                    <a class='btn btn-primary btn-sm' target='_blank' id = " . $row['userid'] . " onclick='generatePaySlipPdf(this.id,$attendance1,$noOfPayableDays)'>
                                                        <i class='fas fa-eye'></i>
                                                    </a>
                                                    </td>
                                            <td><a class='btn btn-primary btn-sm' title='Click hear to View salary' id = " . $row['userid'] . " onclick='viewSalary(this.id,$attendance1)'>
                                                <i class='fas fa-eye fS15'></i>
                                                </a>
                                                 <a class='btn btn-warning btn-sm' title='Click hear to Edit salary' id = " . $row['userid'] . " onclick='editSalary(this.id,$attendance1)'>
                                                <i class='fas fa-edit fS15'></i>
                                                </a>
                                            </td> 
                                        </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="manageSalaries.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    $(function() {
        $(document).ready(function() {
            $.fn.dataTableExt.afnFiltering.push(
                function(settings, data, dataIndex) {
                    selecteduserStatus = getSelectValues('', document.getElementById("userStatusFilter")).trim();

                    var rowuserStatus = data[4].trim();


                    if (selecteduserStatus != '') {
                        inuserStatus = (selecteduserStatus.indexOf(rowuserStatus) != -1) ? rowuserStatus : false;
                    } else inuserStatus = true;
                    return inuserStatus;
                }
            );
            $('.select2').select2();
            $("#manageAttendanceTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        });
    });

    function filterOtherDropDown(flag) {

        var table = $('#manageAttendanceTable').DataTable();
        table.draw();
    }

    function getSelectValues(flag, selectVar) {
        var result = "";
        var options = selectVar && selectVar.options;
        var opt;

        for (var i = 0, iLen = options.length; i < iLen; i++) {
            opt = options[i];
            if (flag == '') {
                if (opt.selected) {
                    result += opt.text;
                }
            }
            if (flag == "multiple") {
                if (opt.selected) {
                    result += opt.text + "|";
                }
            }
        }
        return result.trim();
    }
</script>

<?php require '../../common/footer.php'; ?>