function openNav() {
    document.getElementById("admissionCancelSidenav").style.width = "850px";
}

function closeNav() {
    document.getElementById("admissionCancelSidenav").style.width = "0";
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}
const oldData = {
    oldstudentId: '',
    oldUserFirstName: '',
    oldUserLastName: '',
    guardianWhatsappno: '',
        whatsAppNumber: ''
}
function loadOldValues() {
    oldData.oldstudentId = document.getElementById('studentId').value.trim();
    oldData.oldUserFirstName = document.getElementById('firstName').value.trim().toUpperCase();
    oldData.oldUserLastName = document.getElementById('middleName').value.trim().toUpperCase();
    oldData.whatsAppNumber = document.getElementById('whatsAppNumber').value.trim();
    oldData.guardianWhatsappno = document.getElementById('guardianWhatsappno').value.trim();
}

function compareNewValuesWithOld() {
    statement = "UPDATE done in Student Details ID-(" + oldData.oldstudentId + "), Name " + oldData.oldUserFirstName + " " + oldData.oldUserLastName + ". ";
    var flagForStatement = 0;

    if (oldData.whatsAppNumber != whatsAppNumber) {
        flagForStatement = 1;
        statement = statement + "whatsApp Number changed from " + oldData.whatsAppNumber + " to " + whatsAppNumber + "<br>";
    }
    if (oldData.guardianWhatsappno != guardianWhatsappno) {
        flagForStatement = 1;
        statement = statement + "Parent whatsApp Number changed from " + oldData.guardianWhatsappno + " to " + guardianWhatsappno + "<br>";
    }

    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    } else showError('', '', '');
    return 1;
}
function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");
    return output;
}

var guardianWhatsappno = '';
whatsAppNumber = '';

function saveWhatsappno() {
    guardianWhatsappno = document.getElementById('guardianWhatsappno').value.trim();
    whatsAppNumber = document.getElementById('whatsAppNumber').value.trim();
    studentId = document.getElementById('studentId').value.trim();
    saveFlag = 'saveWhatsappno';

    // whatsapp number validation
    if (whatsAppNumber == "") {
        showError('whatsAppNumber', '#ff6666', "whatsappNumber can not be blank.");
        return 0;
    } else showError('whatsAppNumber', '', '');

    if (whatsAppNumber.length != 10) {
        showError('whatsAppNumber', '#ff6666', "whatsappNumber should be of 10 digit only.");
        return 0;
    } else showError('whatsAppNumber', '', '');
    // whatsapp number validation
    if (guardianWhatsappno == "") {
        showError('guardianWhatsappno', '#ff6666', "whatsappNumber can not be blank.");
        return 0;
    } else showError('guardianWhatsappno', '', '');

    if (guardianWhatsappno.length != 10) {
        showError('guardianWhatsappno', '#ff6666', "whatsappNumber should be of 10 digit only.");
        return 0;
    } else showError('guardianWhatsappno', '', '');

    if (compareNewValuesWithOld() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    document.getElementById('SuccessMessage').innerHTML = 'Saving Please Wait...';
    $.post('saveWhatsappno.php', {
        'saveFlag': saveFlag,
        'guardianWhatsappno': guardianWhatsappno,
        'whatsAppNumber': whatsAppNumber,
        'statement': statement,
        'studentId': studentId,
    }, function (data) {
        document.getElementById('SuccessMessage').innerHTML = 'Saved successfully.';
        document.getElementById("saveButton").disabled = true;
    });

}
