<?php
session_start();
if (strlen($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';

$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">ALL STUDENTS</h3>
                                    <br>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                                <select class="select2" multiple="multiple" id="filterAyear" data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;" onchange="filterTable('studAyear')" ;>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="fS13">FILTER BY STATUS</label>
                                                <select class="select2" multiple="multiple" id="filterStudStatus" data-placeholder="SELECT STUDENT STATUS" style="width: 100%;" onchange="filterTable('status')" ;>
                                                    <option value='ACTIVE'>ACTIVE</option>
                                                    <option value='BLOCKED'>BLOCKED</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="studentTable">
                                <thead>
                                    <tr>
                                        <th>
                                            ACADEMIC YEAR
                                        </th>
                                        <th>
                                            ADMISSION DATE
                                        </th>
                                        <th>
                                            STUDENT ID
                                        </th>
                                        <th>
                                            NAME
                                        </th>
                                        <th>
                                            EMAIL ID
                                        </th>
                                        <th>
                                            STATUS
                                        </th>
                                        <th>
                                            ACTION
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT ls.studentId,ls.admissionDate,ls.firstname,ls.lastname,ls.username,ls.studentStatus,sf.academicYear,sf.studentId from loginstudents ls INNER JOIN studentfee sf ON ls.studentId = sf.studentId WHERE ls.admissionStatus='CONFIRMED' order by ls.studentId desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $studentId = '';
                                            $studentId = $row['studentId'];
                                            $statusCss = '';
                                            if ($row['studentStatus'] == 'ACTIVE') $statusCss = 'badge badge-success';
                                            if ($row['studentStatus'] == 'BLOCKED') $statusCss = 'badge badge-danger';
                                            echo "
                                                <tr  class='tAC'>
                                                <td> " . $row['academicYear'] . "</td>
                                                <td>" . date('d-m-Y', strtotime($row['admissionDate'])) . "</td>
                                                <td><a class='tCB' href='#' onclick='showDetails(this.id)' id = " . $studentId . "> " . $studentId . "</a></td>
                                                <td><a class='tCB' href='#' onclick='showDetails(this.id)' id = " . $studentId . "> " . $row['firstname'] . ' ' . $row['lastname']  . "</a></td>
                                                <td> " . $row['username']  . "</a></td>
                                                <td><span class = '" . $statusCss . "'> " . $row['studentStatus'] . "</span></td>
                                                <td class='project-actions'>
                                                <a class='btn btn-primary btn-sm' href='#' onclick='showDetails(this.id)' id = " . $studentId . " title='click hear to view Student Details'>
                                                    <i class='fas fa-eye'>
                                                    </i>
                                                </a>
                                                </td>
                                            </tr>
                                          ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="allStudent.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;

    $(function() {
        $('.select2').select2();

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();
                selectedStudStatus = getSelectValues('', document.getElementById("filterStudStatus")).trim();

                var rowAcademicYear = data[0].trim();
                var rowStudStatus = data[5].trim();

                if (selectedAcademicYear != '') {
                    inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ? rowAcademicYear : false;
                } else inStudAcademicYear = true;

                if (selectedStudStatus != '') {
                    inStudStatus = (selectedStudStatus.indexOf(rowStudStatus) != -1) ? rowStudStatus : false;
                } else inStudStatus = true;

                return inStudAcademicYear && inStudStatus;
            }
        );

        $("#studentTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        loadDataDropdown("filterAyear", academicYearList);
    });
</script>
<?php require '../../common/footer.php'; ?>