<?php
session_start();
if (strlen($_SESSION['AccountsLoginsuccessEdj'])) {
    if ($_SESSION['AccountsLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';

$feeMaster = [];
$sql = "SELECT sf.*,ls.studentId,ls.firstname,ls.middleName,ls.lastname FROM studentfee sf INNER JOIN loginstudents ls ON sf.studentId = ls.studentId;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($feeMaster, $row);
    }
}
$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
?>

<!-- side nav -->
<div id="admissionCancelSidenav" class="sidenav">
    <div class="row">
        <div class="col-12">
            <ul class="nav nav-tabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active tCW fS18" href="" role="tab" data-toggle="tab">Admission Cancellation Refund</a>
                </li>
                <a href="#" class="pull-right" id="cancel" style="position: absolute;right: 17px;" onclick="closeNav()"><i class="fas fa-window-close"></i></a>
            </ul>
            <!-- Tab panes -->
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane fade show active container" id="">
                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="mt-5">Student Id</label>
                                <input type="text" class="form-control" id="studentIdSideNav" disabled>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label class="mt-5">Student Name</label>
                                <input type="text" class="form-control" id="studentNameSideNav" disabled>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label class="mt-5">Owner Approval</label>
                                <input type="text" class="form-control" id="approvalStatusSideNav" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Total Tuition Fee Received</label>
                                <input type="text" class="form-control" id="totalTuitionFeeReceivedSideNav" disabled>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Total Program Fee Received</label>
                                <input type="text" class="form-control" id="totalProgramFeeReceivedSideNav" disabled>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Program Fee Refund <span class='star'>*</span></label>
                                <input type="number" class="form-control" id="refundSideNav" placeholder="Enter Refund">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12" id='reasonDiv'>
                            <label>Dissaproval Reason</label>
                            <textarea type="number" class="form-control" id="dissaprovalreasonNav" placeholder="Enter Reason" disabled></textarea>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12" id='resubmitReason'>
                            <label class='mt-3'>Reason for Approval</label>
                            <textarea type="number" class="form-control" id="aprovalreasonNav" placeholder="Enter Reason"></textarea>
                        </div>
                    </div>
                    <div class="row">
                        <div class=" col-md-12">
                            <div class="card-footer tAC">
                                <p id='sideNavErrorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                </p>
                                <p id='sideNavSuccessMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                </p>
                                <input type="button" class="btn btn-primary" value="Save" id="saveButton" onclick="sendRefundAmountForAapproval()" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- tab panes end -->
        </div>
    </div>
</div>
<!-- side nav end -->

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">CANCELLED ADMISSION</h3>
                        </div>
                        <br>
                        <div class='row'>
                            <div class="col-md-3">
                                <div class="form-group" style="margin-left: 22px;">
                                    <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                    <select class="select2" multiple="multiple" id="filterAyear" data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;" onchange="filterTable('studAyear');">"
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="studentListTable">
                                <thead>
                                    <tr>
                                        <th width='10%'>INITIATION DATE</th>
                                        <th width='10%'>STUDENT ID</th>
                                        <th width='20%'>NAME</th>
                                        <th width='10%'>ACADEMIC YEAR</th>
                                        <th width='20%'>STATUS</th>
                                        <th width='10%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from admssioncancelledstudents order by STR_TO_DATE(admissionCancelInitiationTimeStamp,'%d-%m-%Y') desc;";
                                    $result = $conn->query($sql);
                                    $studentList = [];
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $approvalStatusCss = '';
                                            $buttonCss = '';
                                            $statusCss = '';

                                            array_push($studentList, $row);
                                            $studentId = '';
                                            $studentId = $row['studentId'];
                                            $refundAmount = '"' . $row['programFeeRrefund'] . '"';
                                            if ($row['ownerApproval'] == 'PENDING') $approvalStatusCss = 'badge badge-danger';
                                            if ($row['ownerApproval'] == 'APPROVED') {
                                                $approvalStatusCss = 'badge badge-success';
                                                $buttonCss = 'disabled';
                                            }
                                            if ($row['ownerApproval'] == 'DISAPPROVED') $approvalStatusCss = 'badge badge-warning';
                                            if ($row['cancellationStatus'] == 'PENDING AT ACCOUNTS') $statusCss = 'badge badge-warning';
                                            if ($row['cancellationStatus'] == 'OWNER APPROVAL PENDING') $statusCss = 'badge badge-primary';
                                            if ($row['cancellationStatus'] == 'PAYMENT DISBURSAL PENDING') $statusCss = 'badge badge-secondary';
                                            if ($row['cancellationStatus'] == 'COMPLETED') $statusCss = 'badge badge-success';

                                            $dateArray = explode('-', $row['initiationDate']);
                                            $date = $dateArray[2] . '-' . $dateArray[1] . '-' . $dateArray[0];
                                            $date = str_replace('-', "/", $date);
                                            date_default_timezone_set('Asia/Kolkata');
                                            $currentDate = date("Y-m-d");
                                            $date1 = date_create($row['statusUpdateDate']);
                                            $date2 = date_create($currentDate);
                                            $diff = date_diff($date1, $date2);
                                            $datediff = $diff->format("%a");
                                            $bgColor = '';
                                            if ($datediff > 15 & ($row['cancellationStatus'] == 'PENDING AT ACCOUNTS' || $row['cancellationStatus'] == 'OWNER APPROVAL PENDING' || $row['cancellationStatus'] == 'PAYMENT DISBURSAL PENDING')) {
                                                $bgColor = '#FF726F';
                                            } else if ($date1 == '') {
                                                $bgColor = '';
                                            } else {
                                                $bgColor = '';
                                            }

                                            echo "
                                                <tr class='tAC' style='background-color:$bgColor'>
                                                    <td> " . $date  . "</td>
                                                    <td> " . $row['studentId']  . "</td>
                                                    <td>" . $row['studentFirstName'] . ' ' . $row['studentLastName'] . "</td>
                                                    <td> " . $row['academicYear']  . "</td>
                                                    <td><span class = '" . $statusCss . "'>" . $row['cancellationStatus'] . "</td>
                                                    <td class='project-actions'>
                                                    <a class='btn btn-primary btn-sm' href='#' id = 'refundAmountButton' onclick='viewRefundAmount($studentId)' title='Click hear to view Student Details'>
                                                        <i class='fas fa-eye'></i>
                                                        </i>
                                                    </a>
                                                    <a class='btn btn-primary btn-sm $buttonCss' href='#' id = 'viewRefundAmountButton' onclick='addRefundAmount($studentId)' title='Click hear to edit Student Details'>
                                                        <i class='fas fa-user-edit'></i>
                                                        </i>
                                                    </a>
                                                </td>
                                                    </tr>
                                            ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="admissionCancellation.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    studentList = <?php echo json_encode($studentList) ?>;
    feeMaster = <?php echo json_encode($feeMaster) ?>;
    var academicYearList = <?php echo json_encode($academicYearList) ?>;

    $(function() {
        $('.select2').select2();
        loadDataDropdown("filterAyear", academicYearList);
        selectDropdownValue("filterAyear", academicYearList);

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();

                var rowAcademicYear = data[3].trim();



                if (selectedAcademicYear != '') {
                    inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ? rowAcademicYear : false;
                } else inStudAcademicYear = true;
                return inStudAcademicYear;
            }
        );
        var table = $("#studentListTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

    })
</script>
<?php require '../../common/footer.php'; ?>