function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext.toUpperCase();
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "companyBankName") dummyOptions(theSelect, options, "BANK NAME");


    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");

        if (selectName.includes("companyBankName")) {
            options.value = results[i].accountNo.toUpperCase();
            options.text = results[i].bankName.toUpperCase();
            theSelect.add(options);
        }

    }
}

function loadAccountNo(element, f) {
    var text = element[element.selectedIndex].value.trim();
    if (text != 'SELECT BANK NAME') document.getElementById("companyBankAccountNo" + f).value = text;
    else document.getElementById("companyBankAccountNo" + f).value = '';
}
function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}
function tdsCalculate() {
    let tempValue = document.getElementById("amountpaid").value;
    if (tempValue == '') {
        showError("amountpaid", "#ff6666", 'Enter Paid Amount for TDS%.');
        return 0;
    } else if (parseFloat(document.getElementById("tdsPercent").value) < 0) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Negative.');
        return 0;
    } else if (parseFloat(document.getElementById("tdsPercent").value) >= 100) {
        showError("tdsPercent", "#ff6666", 'TDS% cannot be Bigger than or equal to 100.');
        return 0;
    } else if (document.getElementById("tdsPercent").value != '') {
        document.getElementById("tdsAmount").value = parseFloat(parseFloat(tempValue) * (parseFloat(document.getElementById("tdsPercent").value) / 100)).toFixed(2);
        document.getElementById("reminderAmount").value = parseFloat(parseFloat(tempValue) - parseFloat(document.getElementById("tdsAmount").value)).toFixed(2);
    }
    showError('amountpaid', '', '');
    showError('tdsPercent', '', '');
}
function calculate(element) {
    var tempPendingAmount = document.getElementById("pendingAmount").value;
    var tempFinalAmount = document.getElementById("finalAmount").value;

    if (element.value == '') {
        showError(element.id, '#ff6666', "Amount Paid cannot be blank.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) == 0) {
        showError(element.id, '#ff6666', "Amount Paid cannot be zero.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) < 0) {
        showError(element.id, '#ff6666', "Amount Paid cannot be negative.");
        return 0;
    } else showError(element.id, '', '');

    if (parseFloat(element.value) > parseFloat(tempFinalAmount)) {
        showError(element.id, '#ff6666', "Amount Paid cannot be bigger than Final Amount.");
        return 0;
    } else showError(element.id, '', '');

    amountPendingLater = parseFloat(parseFloat(tempPendingAmount) - parseFloat(element.value)).toFixed(2);
    // console.log(amountPendingLater);
    tdsCalculate();
    return 1;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");

    return output;
}
function setHeaders() {
    lifeCoachBankName = '',
        paymentDate = '',
        companyBankName = '',
        companyAccountNo = '',
        transactionId = '',
        amountPaid = '',
        amountPending = '',
        tdsPercent = '',
        penaltyAmount = '',
        paymentId = '',
        notesForPayment = '';

    paymentId = document.getElementById("paymentId").value.trim();
    lifeCoachBankName = document.getElementById("lifeCoachBankName").value.trim();
    lifeCoachName = document.getElementById("lifeCoachName").value.trim();
    paymentDate = $("#paymentDate").find("input").val();
    tempSelect = document.getElementById("companyBankName");
    companyBankName = tempSelect[tempSelect.selectedIndex].text.trim();
    companyAccountNo = document.getElementById("companyBankAccountNo").value.trim();
    transactionId = document.getElementById("transactionId").value.trim();
    amountPaid = document.getElementById("amountpaid").value.trim();
    amountPending = document.getElementById("pendingAmount").value.trim();
    tdsPercent = document.getElementById("tdsPercent").value.trim();
    totalNoOfStudents = document.getElementById("totalNoOfStudents").value.trim();
    notesForPayment = document.getElementById("paymentNotesText").value.trim();
    notesForPayment = escapeSpecialCharacters(notesForPayment);
    return 1;
}
function lifeCoachBankDetails(lifeCoachId) {
    lifeCoachAccountNo = '',
        lifeCoachBranchName = '';
    for (let i = 0; i < masterLifeCoachList.length; i++) {
        if (masterLifeCoachList[i].lifeCoachId == lifeCoachId) {
            document.getElementById("lifeCoachBankName").value = masterLifeCoachList[i].lifeCoachBankName;
            lifeCoachAccountNo = masterLifeCoachList[i].accountNo;
            lifeCoachBranchName = masterLifeCoachList[i].bankBranch;
        }
    }
}

function makeArray() {
    paymentContentArray = [];
    var obj = {
        'InvoiceId': InvoiceId,
        'lifeCoachId': lifeCoachId,
        'lifeCoachName': lifeCoachName,
        'totalNoOfStudents': totalNoOfStudents,
        'lifeCoachBankName': lifeCoachBankName,
        'lifeCoachAccountNo': lifeCoachAccountNo,
        'lifeCoachBranchName': lifeCoachBranchName,
        'paymentDate': paymentDate,
        'companyBankName': companyBankName,
        'companyAccountNo': companyAccountNo,
        'transactionId': transactionId,
        'amountPaid': amountPaid,
        'amountPending': amountPendingLater,
        'tdsPercent': tdsPercent,
        'notes': notesForPayment,
    }
    paymentContentArray.push(obj);
    return 1;
}
function formValidation() {
    if (setHeaders() == 0) return 0;

    if (paymentDate == '') {
        showError('paymentDate', '#ff6666', "Payment Date cannot be Blank.");
        return 0;
    } else showError('paymentDate', '', '');

    if (companyBankName == 'SELECT BANK NAME') {
        showError('companyBankName', '#ff6666', "Please Select Valid company Bank Name.");
        return 0;
    } else showError('companyBankName', '', '');

    if (transactionId == '') {
        showError('transactionId', '#ff6666', "Transaction Id cannot be Blank.");
        return 0;
    } else showError('transactionId', '', '');

    if (calculate(document.getElementById("amountpaid")) == 0) return 0;
    if (tdsPercent == '') {
        showError('tdsPercent', '#ff6666', "Please Enter TDS Percent.");
        return 0;
    } else showError('tdsPercent', '', '');

    if (parseFloat(tdsPercent) > 100) {
        showError('tdsPercent', '#ff6666', "TDS Percent cannot be larger than 100%.");
        return 0;
    } else showError('tdsPercent', '', '');

    if (parseFloat(tdsPercent) < 0) {
        showError('tdsPercent', '#ff6666', "TDS Percent cannot be smaller than 0%.");
        return 0;
    } else showError('tdsPercent', '', '');

    lifeCoachBankDetails(lifeCoachId);

    if (makeArray() == 0) return 0;
    return 1;
}
function savePayment() {
    var saveFlag = 'SAVEPAYMENT';
    if (formValidation() == 0) return 0;
    console.log(lifeCoachBankName, 'efe',
        paymentDate, 'efe',
        companyBankName, 'efe',
        companyAccountNo, 'efe',
        transactionId, 'efe',
        amountPaid, 'amountPaid',
        amountPending, 'amountPending',
        tdsPercent, 'tdsPercent',
        notesForPayment, 'efe',
        lifeCoachAccountNo, 'dhbhdvdv',
        lifeCoachBranchName, 'dhbhdvdv',
        lifeCoachId, 'lifeCoachId',
        paymentId, 'paymentId',
        notesForPayment)
    console.log(paymentContentArray);

    if (checkOnline() == false) return;
    // console.log(FaccountsId,assignmentId,facultyName,unitNo,facultyAccountNo,facultyBranchName);
    // console.log(facultyBankName,paymentDate,tempSelect,companyBankName,companyAccountNo,transactionId,amountPaid,amountPending,tdsPercent,notesForPayment,penaltyAmount);
    else {
        if (confirm("Are you sure you want to save this Payment??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Payment. Please wait...';
            document.getElementById("savePayment").disabled = true;
            $.post('savePayment.php', {
                'saveFlag': saveFlag,
                'contentArray': paymentContentArray,
            }, function (data) {
                console.log(data);
                document.getElementById('successMessage').innerHTML = 'Payment Done Successfully...';
                document.getElementById("savePayment").disabled = true;
            });
        }
        else document.getElementById("savePayment").disabled = false;
    }
}