<?php
session_start();
if (strlen($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    if ($_SESSION['academicExecutiveLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
$facultyList = [];
$sql2 = "SELECT * FROM faculty WHERE formStatus = 'APPROVED'";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($facultyList, $row2);
    }
}
$semester = [];
$sql2 = "SELECT * FROM semester;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($semester, $row2);
    }
}
$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
require '../../common/header.php';
require '../../common/navbar.php';
?>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PENDING LECTURES</h3>
                                    <br>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="fS13">FILTER BY SEMESTER NO.</label>
                                                <select class="select2" multiple="multiple" id="semDropdown" style="width: 100%;" onchange="filterTable('semester');" data-placeholder="SELECT SEMESTER">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="fS13">FILTER BY FACULTY NAME</label>
                                                <select class="select2" multiple="multiple" id="facultyDropdown" style="width: 100%;" onchange="filterTable('facultyName');" data-placeholder="SELECT FACULTY NAME">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                                <select class="select2" multiple="multiple" id="filterAyear" data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;" onchange="filterTable('studAyear')" ;>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingLecturesTable">
                                <thead>
                                    <tr>
                                        <th class="col-md-1">
                                            LECTURE ID
                                        </th>
                                        <th class="col-md-1">
                                            LECTURE DATE
                                        </th>
                                        <th class="col-md-1">
                                            START TIME
                                        </th>
                                        <th class="col-md-1">
                                            END TIME
                                        </th>
                                        <th class="col-md-2">
                                            FACULTY NAME
                                        </th>
                                        <th class="col-md-2">
                                            SEMESTER
                                        </th>
                                        <th class="col-md-2">
                                            ACADEMIC YEAR
                                        </th>
                                        <th class="col-md-1">
                                            STATUS
                                        </th>
                                        <th class="col-md-1">
                                            ACTION
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from timetable WHERE lectureStatus != 'COMPLETED' ORDER BY lectureId desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $statusCss = '';
                                            $lectureStatus = $row['lectureStatus'];
                                            $lectureId = $row['lectureId'];
                                            if ($lectureStatus == 'PENDING') $statusCss = 'badge badge-danger';
                                            if ($lectureStatus == 'CANCELLED') $statusCss = 'badge badge-warning';
                                            if ($lectureStatus == 'COMPLETED') $statusCss = 'badge badge-success';
                                            echo "
                                                <tr class='tAC'>
                                                    <td>" . $row['lectureId'] . "</td> 
                                                    <td>" . $row['lectureDate'] . "</td> 
                                                    <td>" . $row['startTime'] . "</td>
                                                    <td>" . $row['endTime'] . "</td>
                                                    <td>" . $row['facultyName'] . "</td>
                                                    <td>" . $row['semester'] . "</td>
                                                    <td>" . $row['academicYear'] . "</td>
                                                    <td><span class = '" . $statusCss . "'>" . $row['lectureStatus'] . "</span></td>
                                                    <td class='project-actions'>
                                                    <a class='btn btn-primary btn-sm' href='#' onclick='markAttendance(this.id)' id = " . $lectureId . " title='click hear to add attendance'>
                                                        <i class='fas fa-users'>
                                                        </i>
                                                    </a>
                                                </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<!-- <script src="attendance.js?v=<?php echo $fileVersion; ?>"></script> -->
<script src="pendingLecture.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    var facultyList = <?php echo json_encode($facultyList) ?>;
    var semester = <?php echo json_encode($semester) ?>;
    $(function() {
        $('.select2').select2();
        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();
                selectedSemester = getSelectValues('', document.getElementById("semDropdown")).trim();
                selectedFaculty = getSelectValues('', document.getElementById("facultyDropdown")).trim();

                var rowFacultyName = data[4].trim();
                var rowSemester = data[5].trim();
                var rowAcademicYear = data[6].trim();

                if (selectedSemester != '') {
                    inSemester = (selectedSemester.indexOf(rowSemester) !== -1) ?
                        rowSemester :
                        false;
                } else inSemester = true;
                if (selectedFaculty != '') {
                    inFacultyName = (selectedFaculty.indexOf(rowFacultyName) != -1) ?
                        rowFacultyName :
                        false;
                } else inFacultyName = true;
                if (selectedAcademicYear != '') {
                    inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ? rowAcademicYear : false;
                } else inStudAcademicYear = true;
                return inSemester && inFacultyName && inStudAcademicYear;


            }
        );
        var table = $("#pendingLecturesTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        loadDataDropdown("filterAyear", academicYearList);
        loadDataDropdown("semDropdown", semester);
        loadDataDropdown("facultyDropdown", facultyList);
    });
</script>
<?php require '../../common/footer.php'; ?>