function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";
    options.disabled = false;
    options.selected = true;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "academicYear") dummyOptions(theSelect, options, "ACADEMIC YEAR");
    if (selectName == "batchName") dummyOptions(theSelect, options, "BATCH");
    if (selectName.includes('facultyName')) dummyOptions(theSelect, options, "FACULTY");
    if (selectName.includes("subjectName")) dummyOptions(theSelect, options, "SUBJECT");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("academicYear")) {
            academicYear1 = results[i].firstAcademicYear.split("-");
            academicYear2 = results[i].thirdAcademicYear.split("-");
            academicYear = academicYear1[0] + '-' + academicYear2[1];
            options.value = options.text = academicYear;
            theSelect.add(options);
        } else if (selectName.includes("facultyName")) {
            facultyName = results[i].firstName + ' ' + results[i].lastName;
            options.value = results[i].facultyId;
            options.text = facultyName;
            theSelect.add(options);
        } else if (selectName.includes("batchName")) {
            options.value = results[i].batchId;
            options.text = results[i].batchTitle;
            theSelect.add(options);
        }
        else if (selectName.includes("subjectName")) {
            options.value = results[i].subjectName.toUpperCase();
            options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        }
        else if (selectName.includes("semDropdown")) {
            options.value = results[i].semesterValue.toUpperCase();
            options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        }
        else if (selectName.includes("facultyDropdown")) {
            facultyName = results[i].firstName + ' ' + results[i].lastName;
            options.value = results[i].facultyId;
            options.text = facultyName;
            theSelect.add(options);
        }
    }
}
function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}
function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].text;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}
function filterTable(flag) {
    var table = $('#viewtimeTable').DataTable();
    table.draw();
}

function resetTimetable() {
    document.getElementById("lectureId").value = '';
    document.getElementById("lectureDate").value = '';
    document.getElementById("lectureDay").value = '';
    document.getElementById("lectureStartTime").value = '';
    document.getElementById("lectureEndTime").value = '';
    document.getElementById("subjectName").value = '';
    document.getElementById("facultyName").value = '';
}
function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"")
    return output;
}
var modallectureDate = '';
modallectureDay = '';
modalfacultyName = '';
function addtoModal(lectureId, modallectureDate, modallectureDay, lectureStartTime, lectureEndTime, subjectName, facultyName) {
    console.log(lectureId, modallectureDate, modallectureDay, lectureStartTime, lectureEndTime, subjectName, facultyName)
    resetTimetable();
    document.getElementById("lectureId").value = lectureId;
    document.getElementById("lectureDate").value = modallectureDate;
    document.getElementById("lectureDay").value = modallectureDay;
    document.getElementById("lectureStartTime").value = lectureStartTime;
    document.getElementById("lectureEndTime").value = lectureEndTime;
    document.getElementById("subjectName").value = subjectName;
    document.getElementById("facultyName").value = facultyName;
    loadDataDropdown("subjectName", subjectList);
    selectDropdownValue("subjectName", subjectName);
    loadDataDropdown("facultyName", facultyList);
    selectDropdownValue("facultyName", facultyName);
}
function modalshowError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('editErrorMessage').innerHTML = message;
}

function modalValidation() {
    var lectureId = document.getElementById("lectureId").value;
    modallectureDate = document.getElementById("lectureDate").value;
    modallectureDay = document.getElementById("lectureDay").value;
    modallectureStartTime = document.getElementById("lectureStartTime").value;
    modallectureEndTime = document.getElementById("lectureEndTime").value;
    modalSubjectName = document.getElementById("subjectName").value;

    if (modallectureDate == '') {
        modalshowError('lectureDate', '#ff6666', "Enter the Date");
        return 0;
    } else {
        modalshowError('lectureDate', '', "");
        // console.log(modallectureDate)
    }
    if (modallectureDay == '') {
        modalshowError('lectureDay', '#ff6666', "Enter the Day");
        return 0;
    } else {
        modalshowError('lectureDay', '', "");
        // console.log(modallectureDay)

    }
    if (modallectureStartTime == '') {
        modalshowError('lectureStartTime', '#ff6666', "Enter the Start Time");
        return 0;
    } else {
        modalshowError('lectureStartTime', '', "");
        // console.log(modallectureStartTime)
    }
    // if (!validateTime(modallectureStartTime)) {
    //     modalshowError('lectureStartTime', '#ff6666', "Time should be in HH:MM AM/PM format.");
    //     return 0;
    // } else {
    //     modalshowError('lectureStartTime', '', "");
    // }
    if (modallectureEndTime == '') {
        modalshowError('lectureEndTime', '#ff6666', "Enter the End Time");
        return 0;
    } else {
        modalshowError('lectureEndTime', '', "");
    }
    // if (!validateTime(modallectureEndTime)) {
    //     modalshowError('lectureEndTime', '#ff6666', "Time should be in HH:MM AM/PM format.");
    //     return 0;
    // } else {
    //     modalshowError('lectureEndTime', '', "");
    // }
    if (modalSubjectName == '') {
        modalshowError('subjectName', '#ff6666', "Enter the Subject");
        return 0;
    } else {
        modalshowError('subjectName', '', "");
    }
    if (facultyName == '') {
        modalshowError('facultyName', '#ff6666', "Select Faculty Name");
        return 0;
    } else {
        modalshowError('facultyName', '', "");
    }

}
function editTimetable() {
    var saveFlag = 'updateTimetable';
    var modallectureDate = document.getElementById('lectureDate').value;
    var lectureId = document.getElementById("lectureId").value;
    tempSelect = document.getElementById("facultyName");
    facultyName = tempSelect[tempSelect.selectedIndex].text.trim();

    if (modalValidation() == 0) return 0;
    modalSubjectName = escapeSpecialCharacters(modalSubjectName);
    document.getElementById('modelsuccessMessage').innerHTML = 'Updating please wait...';
    $.post('updateTimeTable.php', {
        'saveFlag': saveFlag,
        'lectureId': lectureId,
        'modallectureDate': modallectureDate,
        'modallectureDay': modallectureDay,
        'modallectureStartTime': modallectureStartTime,
        'modallectureEndTime': modallectureEndTime,
        'modalSubjectName': modalSubjectName,
        'facultyName': facultyName,
    },
        function (data) {
            document.getElementById('modelsuccessMessage').innerHTML = ' Timetable Successfully Updated';
            // document.getElementById('modelsuccessMessage').innerHTML = ' Timetable Successfully Updated';
            // location.reload();
        });

}