<?php
session_start();
if (strlen($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    if ($_SESSION['academicExecutiveLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../studentLogin.php');
        exit;
    }
} else {
    header('Location:../../studentLogin.php');
    exit;
}

require_once '../../common/connectToDB.php';

$facultyList = [];
$sql2 = "SELECT * FROM faculty WHERE formStatus = 'APPROVED'";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($facultyList, $row2);
    }
}

$sql = "SELECT * FROM timetable";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $lectureId = $row['lectureId'];
    }
}

$subjectList = [];
$sql4 = "SELECT * FROM subjects";
$result4 = $conn->query($sql4);
if ($result4->num_rows > 0) {
    while ($row4 = $result4->fetch_assoc()) {
        array_push($subjectList, $row4);
    }
}
$semester = [];
$sql2 = "SELECT * FROM semester;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($semester, $row2);
    }
}

require '../../common/header.php';
require '../../common/navbar.php';
?>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">TIME TABLE</h3>
                            <br>
                            <br>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY SEMESTER NO.</label>
                                        <select class="select2" multiple="multiple" id="semDropdown" style="width: 100%;" onchange="filterTable('semester');" data-placeholder="SELECT SEMESTER">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY FACULTY NAME</label>
                                        <select class="select2" multiple="multiple" id="facultyDropdown" style="width: 100%;" onchange="filterTable('facultyName');" data-placeholder="SELECT FACULTY NAME">
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal fade" id="timeTableModal">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title">EDIT TIMETABLE</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closeAddModal" onclick="resetTimetable();">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <label>LECTURE ID</label>
                                                <input type="text" class="form-control" id="lectureId" value="" placeholder="" disabled>
                                            </div>
                                            <div class="col-md-2">
                                                <label>DATE</label>
                                                <input type="text" class="form-control" id="lectureDate" value="" placeholder="">
                                            </div>
                                            <div class="col-md-3">
                                                <label>DAY</label>
                                                <input type="text" class="form-control" id="lectureDay" placeholder="enter the day">
                                            </div>
                                            <div class="col-md-2">
                                                <label>TIME</label>
                                                <input type="text" class="form-control" id="lectureStartTime" value="" placeholder="">
                                            </div>
                                            <div class="col-md-2">
                                                <label>END TIME</label>
                                                <input type="text" class="form-control" id="lectureEndTime" value="" placeholder="">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-7">
                                                <label>SUBJECT</label>
                                                <select class="form-control custom-select" id="subjectName">
                                                    <option value="SELECT SUBJECT">SELECT FACULTY</option>
                                                </select>
                                            </div>

                                            <div class="col-md-5">
                                                <label>FACULTY NAME</label>
                                                <select class="form-control custom-select" id="facultyName">
                                                    <option value="SELECT FACULTY">SELECT FACULTY</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <p class="errorMessage fS22" id="editErrorMessage" style="color:red;"></p>
                                        <p class="modelsuccessMessage" id="modelsuccessMessage" style="color:green;">
                                        </p>
                                        <button type="button" id="closeButton" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        <button type="button" id="editbutton" onclick="editTimetable(this.$lectureId)" class="btn btn-primary">Update</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped projects tAC" id="viewtimeTable">
                            <thead>
                                <tr>
                                    <th>
                                        LECTURE ID
                                    </th>
                                    <th>
                                        DATE
                                    </th>
                                    <th>
                                        DAY
                                    </th>
                                    <th>
                                        START TIME
                                    </th>
                                    <th>
                                        END TIME
                                    </th>

                                    <th>
                                        SUBJECT
                                    </th>
                                    <th>
                                        SEMESTER
                                    </th>
                                    <th>
                                        FACULTY NAME
                                    </th>
                                    <th>
                                        ACTIONS
                                    </th>
                                </tr>
                            </thead>
                            <?php
                            require_once '../../common/connectToDB.php';
                            // $sql = "SELECT * FROM timetable WHERE batchId='" . $batchId . "';";
                            $sql1 = "SELECT * from timetable WHERE lectureStatus = 'PENDING' ORDER BY lectureId;";
                            $result = $conn->query($sql1);
                            if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    $id  = $row["lectureId"];
                                    $lectureDate = '"' . $row['lectureDate'] . '"';
                                    $modallectureDay = '"' . $row['lectureDay'] . '"';
                                    $startTime = '"' . $row['startTime'] . '"';
                                    $endTime = '"' . $row['endTime'] . '"';
                                    $lectureTime = '"' . $row['startTime'] . '-' . $row['endTime'] . '"';
                                    $subjectName = '"' . $row['subjectName'] . '"';
                                    $facultyName = '"' . $row['facultyName'] . '"';

                                    echo "
                                        <tr  class='tAC'>                                                                                                     
                                            <td>" . $id . "</td> 
                                            <td>" . $row['lectureDate'] . "</td>
                                            <td>" . $row['lectureDay'] . "</td>
                                            <td>" . $row['startTime'] . "</td>
                                            <td>" . $row['endTime'] . "</td>
                                            <td>" . $row['subjectName'] . "</td>
                                            <td>" . $row['semester'] . "</td>
                                            <td>" . $row['facultyName'] . "</td>
                                            <td class='project-actions'>
                                                    <a class='btn btn-primary btn-sm' href='#' id = '" . $id . "'  data-toggle='modal' data-target='#timeTableModal' onclick='addtoModal(this.id,$lectureDate,$modallectureDay,$startTime,$endTime,$subjectName,$facultyName)' title='Click here to Edit TimeTable.'>
                                                    <i class='fas fa-edit'>
                                                    </i>
                                                    </a>
                                                </td>
                                       </tr>  ";
                                }
                            }
                            ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
</div>
</section>
</div>



<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/excelsheetToHtmlTable/xlsx.full.min.js"></script>
<script src="manageTimetable.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var facultyList = <?php echo json_encode($facultyList) ?>;
    var subjectList = <?php echo json_encode($subjectList) ?>;
    var semester = <?php echo json_encode($semester) ?>;
    $(function() {
        $(document).ready(function() {});
        loadDataDropdown("facultyName", facultyList);
        loadDataDropdown("subjectName", subjectList);
        loadDataDropdown("semDropdown", semester);
        loadDataDropdown("facultyDropdown", facultyList);
        $('.select2').select2();

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedSemester = getSelectValues('', document.getElementById("semDropdown")).trim();
                selectedFaculty = getSelectValues('', document.getElementById("facultyDropdown")).trim();

                var rowSemester = data[6].trim();
                var rowFacultyName = data[7].trim();

                if (selectedSemester != '') {
                    inSemester = (selectedSemester.indexOf(rowSemester) !== -1) ?
                        rowSemester :
                        false;
                } else inSemester = true;
                if (selectedFaculty != '') {
                    inFacultyName = (selectedFaculty.indexOf(rowFacultyName) != -1) ?
                        rowFacultyName :
                        false;
                } else inFacultyName = true;
                return inSemester && inFacultyName;
            }
        );


        var table = $("#viewtimeTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>
<?php require '../../common/footer.php'; ?>