var lectureId = '',
    lectureStatus = '',
    lectureDate = '',
    batchId = '',
    batchName = '',
    academicYear = '',
    attendanceStatus = '',
    semester = '',
    logStatement = '',
    flagForStatement = 0,
    subjectName = '';

var tableFlag = '';
var oldAttendanceStatus = '',
    inputattendanceRemark = '';

function showError(id, color, message) {
    if (id != '') document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function onLoadOldValues() {
    oldAttendanceStatus = '';
    var table = document.getElementById("studListTableBody");
    for (var r = 1, n = table.rows.length; r <= n; r++) {
        inputbtnAttendance = document.getElementById("attendance" + (r));
        oldAttendanceStatus = oldAttendanceStatus + inputbtnAttendance.value + ":";
    }
    oldAttendanceStatus = oldAttendanceStatus.slice(0, -1);
}

function changeAttendance(id) {
    if (document.getElementById(id).value == "P") {
        document.getElementById(id).className = "btn btn-danger";
        document.getElementById(id).value = "A";
    }
    else if (document.getElementById(id).value == "A") {
        document.getElementById(id).className = "btn btn-success";
        document.getElementById(id).value = "P";
    }
}

function setHeaders() {
    lectureId = '';
    lectureDate = '';
    batchId = '';
    batchName = '';
    subjectName = '';
    semester = '';

    lectureId = document.getElementById('lectureId').value.trim();
    lectureStatus = document.getElementById('lectureStatus').value.trim();
    lectureDate = document.getElementById('lectureDate').value.trim();
    batchId = document.getElementById('batchId').value.trim();
    batchName = document.getElementById('batchName').value.trim();
    academicYear = document.getElementById('academicYear').value.trim();
    semester = document.getElementById('semester').value.trim();
    subjectName = document.getElementById('subjectName').value.trim().toUpperCase();

    if (lectureStatus == 'PENDING') tableFlag = false;
    if (lectureStatus == 'CANCELLED') tableFlag = false;
    if (lectureStatus == 'COMPLETED') tableFlag = true;
    return 1;
}

function setTablevalue() {
    studentIdList = [];
    studentNameList = [];
    attendanceStatusList = [];
    attendanceStatus = '';
    var table = document.getElementById("studListTableBody");
    for (var r = 0, n = table.rows.length; r < n; r++) {
        let tempStudentId = table.rows[r].cells[1].innerHTML.trim();
        let tempStudentName = table.rows[r].cells[3].innerHTML.trim().toUpperCase();
        let tempAttendanceStatus = table.rows[r].cells[4].getElementsByTagName("input")[0].value.trim().toUpperCase();
        attendanceStatus = attendanceStatus + tempAttendanceStatus + ":";

        studentIdList.push(tempStudentId);
        studentNameList.push(tempStudentName);
        attendanceStatusList.push(tempAttendanceStatus);
    }
    attendanceStatus = attendanceStatus.slice(0, -1);
}

function validatingChanges() {
    var stringOldAttendanceStatus = oldAttendanceStatus.split(":");
    var stringNewAttendanceStatus = attendanceStatus.split(":");
    var table = document.getElementById("studListTableBody");
    logStatement = "Attendance updated for Lecture ID - " + lectureId + " <br>";
    var flagForStatement = 0;
    for (var r = 0, n = table.rows.length; r < n; r++) {
        if (stringOldAttendanceStatus[r] != stringNewAttendanceStatus[r]) {
            flagForStatement = 1;
            tempStudName = table.rows[r].cells[3].innerHTML;
            logStatement = logStatement + "Student " + tempStudName + " Attendance Status has changed from " + stringOldAttendanceStatus[r] + " to " + stringNewAttendanceStatus[r] + "<br>";
        }
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No changes Done in Attendance');
        return 0;
    }
    return 1;
}

function updateAttendance() {
    var saveFlag = 'editAttendance';
    document.getElementById('saveButton').disabled = true;
    if (setHeaders() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (setTablevalue() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (checkOnline() == false) {
        document.getElementById("saveButton").disabled = false;
        return;
    }
    if (validatingChanges() == 0) {
        document.getElementById("saveButton").disabled = false;
        return;
    }
    if (confirm("Are you sure you want save attendance?")) {
        document.getElementById('successMessage').innerHTML = 'Saving please wait...';
        $.post('updateAttendance.php', {
            'saveFlag': saveFlag,
            'lectureId': lectureId,
            'lectureDate': lectureDate,
            'lectureStatus': lectureStatus,
            'batchId': batchId,
            'batchName': batchName,
            'academicYear': academicYear,
            'subjectName': subjectName,
            'semester': semester,
            'tableFlag': tableFlag,
            'studentId': studentIdList,
            'studentName': studentNameList,
            'attendanceStatus': attendanceStatusList,
            'logStatement': logStatement,
        },
            function (data) {
                location.reload();
                document.getElementById('successMessage').innerHTML = 'Lecture saved successfully';
            });
    }
    else document.getElementById("saveButton").disabled = false;
}