<?php
session_start();
if (strlen($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    if ($_SESSION['academicExecutiveLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}

$facultyList = [];
$sql2 = "SELECT * FROM faculty WHERE formStatus = 'APPROVED'";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($facultyList, $row2);
    }
}

$batchList = [];
$sql3 = "SELECT * FROM batchmaster";
$result3 = $conn->query($sql3);
if ($result3->num_rows > 0) {
    while ($row3 = $result3->fetch_assoc()) {
        array_push($batchList, $row3);
    }
}

$semester = [];
$sql2 = "SELECT * FROM semester";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) { 
    while ($row2 = $result2->fetch_assoc()) {
        array_push($semester, $row2);
    }
}

$subjectList=[];
$sql4 = "SELECT * FROM subjects";
$result4 = $conn->query($sql4);
if ($result4->num_rows > 0) { 
    while ($row4 = $result4->fetch_assoc()) {
        array_push($subjectList, $row4);
    }
}

require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header">
                            <h3 class="card-title fSB">Add Timetable</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <label>Import CSV/Excel file</label>
                                </div>
                                <div class="col-md-2" style="text-align: right;">
                                    <label>CSV/Excel File:</label>
                                </div>
                                <div class="col-md-3 ">
                                    <input type="file" name="file" id="file_upload" onchange="upload()"
                                        class="input-large">

                                </div>
                                <div class="col-md-2" style="text-align: right;">
                                    <label class="tAC">Download Excel Template:</label>

                                </div>
                                <div class="col-md-1">
                                    <a id="download" href="timetable.csv" download="timetable.csv"
                                        class="btn btn-primary">Download</a>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label> Academic Year <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="academicYear" onchange="filterOtherDropDown('academicYear');">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label> Batch <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="batchName">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Semester<span class="star">*</span></label>
                                        <select class="form-control custom-select" id="semester">
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header newCardHeader">
                            <h3 class="tAC fSB">TIME TABLE</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="timeTable">
                            </table>
                        </div>
                        <div class="card-footer tAC">
                            <p id='errorMessage' class="text-center"
                                style="color: red; font-size: 1.2em;   text-align: center;">
                            </p>
                            <p id='successMessage' class="text-center"
                                style="color: #25C032; font-size: 1.2em;   text-align: center;">
                            </p>
                            <span id="savedData"></span>
                            <input type="button" class="btn btn-primary" value="Save" onclick="saveTimetable()"
                                id="saveButton" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/excelsheetToHtmlTable/xlsx.full.min.js"></script>
<!-- <script src="timeTable.js?v=<?php echo $fileVersion; ?>"></script> -->
<script src="addTimetable.js?v=<?php echo $fileVersion; ?>"></script>
<script>
var academicYearList = <?php echo json_encode($academicYearList) ?>;
var batchList = <?php echo json_encode($batchList) ?>;
var facultyList = <?php echo json_encode($facultyList) ?>;
var semester = <?php echo json_encode($semester) ?>;
var subjects = <?php echo json_encode($subjectList) ?>;

$(function() {
    $(document).ready(function() {});
    loadDataDropdown("academicYear", academicYearList);
    loadDataDropdown("batchName", batchList);
    loadDataDropdown("semester", semester, "");

});
</script>
<?php require '../../common/footer.php'; ?>