function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";
    options.disabled = false;
    options.selected = true;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "academicYear") dummyOptions(theSelect, options, "ACADEMIC YEAR");
    if (selectName == "batchName") dummyOptions(theSelect, options, "BATCH");
    if (selectName.includes('facultyName')) dummyOptions(theSelect, options, "FACULTY");
    if (selectName.includes("semester")) dummyOptions(theSelect, options, "SEMESTER");
    if (selectName.includes("subjects")) dummyOptions(theSelect, options, "SUBJECT");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("academicYear")) {
            academicYear1 = results[i].firstAcademicYear.split("-");
            academicYear2 = results[i].thirdAcademicYear.split("-");
            academicYear = academicYear1[0] + '-' + academicYear2[1];
            options.value = options.text = academicYear;
            theSelect.add(options);
        } else if (selectName.includes("facultyName")) {
            facultyName = results[i].firstName + ' ' + results[i].lastName;
            options.value = results[i].facultyId;
            options.text = facultyName;
            theSelect.add(options);
        } else if (selectName.includes("batchName")) {
            options.value = results[i].batchId;
            options.text = results[i].batchTitle;
            theSelect.add(options);
        }
        else if (selectName.includes("semester")) {
            options.value = results[i].semesterValue.toUpperCase();
            options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        }
        else if (selectName.includes("subjects")) {
            options.value = results[i].subjectName.toUpperCase();
            options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        }
    }
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
        if (flag == "value") {
            if (opt.selected) {
                result += opt.value;
            }
        }
    }
    return result.trim();
}

// function selectDropdownValue(selectName, val) {
//     var theSelect = document.getElementById(selectName);
//     for (var j = 0; j < theSelect.options.length; j++) {
//         var optVal = theSelect.options[j].text;
//         if (optVal.toUpperCase() == val.toUpperCase()) {
//             theSelect.options[j].selected = true;
//         }
//     }
//     return;
// }

function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    var trimmedVal = val.trim().replace(/\s+/g, ''); 
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].text.trim().replace(/\s+/g, ''); 

        if (optVal.toUpperCase() === trimmedVal.toUpperCase()) {
            theSelect.options[j].selected = true;
            
        } 
    }
    return;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function upload() {
    var files = document.getElementById('file_upload').files;
    if (files.length == 0) {
        return;
    }
    var filename = files[0].name;
    var extension = filename.substring(filename.lastIndexOf(".")).toUpperCase();
    var docSize = (parseFloat(files[0].size / 1024) / 1024).toFixed(2);

    if (docSize > 1) {
        alert("Document size should not exceed 1 MB.");
        return;
    }
    if (extension == '.CSV') {
        excelFileToJSON(files[0]);
        showError('', '', '');
    } else {
        // alert("Please select a valid excel file.");
        showError('', '', "Please select a valid excel file.");
    }

}

function excelFileToJSON(file) {
    try {
        var reader = new FileReader();
        reader.readAsBinaryString(file);
        reader.onload = function (e) {
            var data = e.target.result;
            var workbook = XLSX.read(data, {
                type: 'binary'
            });
            var result = {};
            var firstSheetName = workbook.SheetNames[0];
            var worksheet = workbook.Sheets[firstSheetName];
            var resultJson = XLSX.utils.sheet_to_json(worksheet, { dateNF: 'mm/dd/yyyy;@', cellDates: true, raw: false });
            displayJsonToHtmlTable(resultJson);
        }
    } catch (e) {
        console.error(e);
    }
}

function displayJsonToHtmlTable(jsonData) {
    var table = document.getElementById("timeTable");
    if (jsonData.length > 0) {
        var htmlData = '<thead><tr><th class = "col-md-2">Date</th><th class = "col-md-2">Day</th><th class = "col-md-1">Start Time</th><th class = "col-md-1">End Time</th><th class = "col-md-4">Subject</th><th class = "col-md-2">Faculty Name</th></tr><thead>';
        htmlData += '<tbody id = "timeTableBody">';
        for (var i = 0; i < jsonData.length; i++) {
            var row = jsonData[i];
            htmlData += '<tr><td><input type="text" class="form-control" value = ' + row["Date"] + '>' + '</input></td><td><input type="text" class="form-control" value = ' + row["Day"] + '>' + '</input></td><td><input type="text" class="form-control" value = ' + row["Start Time"] + '>' + '</input></td><td><input type="text" class="form-control" value = ' + row["End Time"] + '>' + '</input></td><td><select class="form-control custom-select" id="subjects' + i + '" value = "' + row["Subject"] + '">' + '<option value="' + row["Subject"] + '">' + '</option></select></td><td><select class="form-control custom-select" id = "facultyName' + i + '">' + '</select></td></tr>';
        }
        htmlData += '</tbody>';
        table.innerHTML = htmlData;
        for (var i = 0; i < jsonData.length; i++) {
            var row = jsonData[i];
            loadDataDropdown("facultyName" + i, facultyList);
            loadDataDropdown("subjects" + i, subjects);
            selectDropdownValue("subjects" + i, row["Subject"]);
        }
        var table = document.getElementById("timeTableBody");
        for (var r = 0, n = table.rows.length; r < n; r++) {
            if (table.rows[r].cells[0].getElementsByTagName("input")[0].value.trim() == 'undefined') {
                table.rows[r].cells[0].getElementsByTagName("input")[0].value = '';
            }
            if (table.rows[r].cells[1].getElementsByTagName("input")[0].value.trim() == 'undefined') {
                table.rows[r].cells[1].getElementsByTagName("input")[0].value = '';
            }
            if (table.rows[r].cells[2].getElementsByTagName("input")[0].value.trim() == 'undefined') {
                table.rows[r].cells[2].getElementsByTagName("input")[0].value = '';
            }
            if (table.rows[r].cells[3].getElementsByTagName("input")[0].value.trim() == 'undefined') {
                table.rows[r].cells[3].getElementsByTagName("input")[0].value = '';
            }
            if (table.rows[r].cells[4].getElementsByTagName("select")[0].value.trim() == 'undefined') {
                table.rows[r].cells[4].getElementsByTagName("select")[0].value = '';
            }
        }
    } else {
        table.innerHTML = 'There is no data in Excel';
    }
}

function filterOtherDropDown(flag) {
    tempAcademicYear = getSelectValues('value', document.getElementById("academicYear")).trim();
    tempBatchName = [];
    if (flag == "academicYear") {
        loadDataDropdown("batchName", []);
        for (let i = 0; i < batchList.length; i++) {
            if (batchList[i].academicYear == tempAcademicYear) {
                tempdata = batchList[i].batchTitle;
                tempDataId = batchList[i].batchId;
                tempBatchName.push(obj = {
                    "batchTitle": tempdata,
                    "batchId": tempDataId
                });
                loadDataDropdown("batchName", tempBatchName);
            }
        }
    }
}

function resetTableErrors() {
    var table = document.getElementById("timeTableBody");
    for (var r = 0, n = table.rows.length; r < n; r++) {
        table.rows[r].cells[0].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[4].getElementsByTagName("select")[0].style.backgroundColor = "";
        table.rows[r].cells[5].getElementsByTagName("select")[0].style.backgroundColor = "";
    }
}

function validateDate(date) {
    // var re = /^(?:(?:31(\/|-|\.)(?:0?[13578]|1[02]))\1|(?:(?:29|30)(\/|-|\.)(?:0?[13-9]|1[0-2])\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})$|^(?:29(\/|-|\.)0?2\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:0?[1-9]|1\d|2[0-8])(\/|-|\.)(?:(?:0?[1-9])|(?:1[0-2]))\4(?:(?:1[6-9]|[2-9]\d)?\d{2})$/;
    // var re = /^(?:(?:31(\/)(?:0?[13578]|1[02]))\1|(?:(?:29|30)(\/)(?:0?[13-9]|1[0-2])\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})$|^(?:29(\/)0?2\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:0?[1-9]|1\d|2[0-8])(\/)(?:(?:0?[1-9])|(?:1[0-2]))\4(?:(?:1[6-9]|[2-9]\d)?\d{2})$/;

    var re = /^(?:(?:31(\/)(?:0?[13578]|1[02]))\1|(?:(?:29|30)(\/)(?:0?[13-9]|1[0-2])\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})$|^(?:29(\/)0?2\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:0?[1-9]|1\d|2[0-8])(\/)(?:(?:0?[1-9])|(?:1[0-2]))\4(?:(?:1[6-9]|[2-9]\d)?\d{4})$/;
    return re.test(String(date));
}

function validateTime(time) {
    var re = /\b((1[0-2]|0?[1-9]):([0-5][0-9]) ([AaPp][Mm]))/;
    return re.test(String(time));
}

function validateDay(day) {
    var re = /\b(([mon]|tues|wed(nes)?|thur(s)?|fri|sat(ur)?|sun)(day)?)\b/;
    return re.test(String(day));
}

var academicYear = '';
var batchId = '';
var batchName = '';
var semester = '';
function formValidation() {
    academicYear = '';
    batchName = '';
    batchId = '';
    semester = '';
    academicYear = document.getElementById("academicYear").value.trim();
    batchId = document.getElementById("batchName").value.trim();
    semester = document.getElementById("semester").value.trim().toUpperCase();
    var tempBatchOptions = document.getElementById("batchName");
    batchName = tempBatchOptions[tempBatchOptions.selectedIndex].text.toUpperCase();

    var files = document.getElementById('file_upload').files;
    if (files.length == 0) {
        showError('file_upload', '#ff6666', "Please select file");
        return 0;
    } else {
        showError('file_upload', '', " ");
    }

    if (academicYear == 0) {
        showError('academicYear', '#ff6666', "Please select academic year");
        return 0;
    } else {
        showError('academicYear', '', " ");
    }

    if (batchName == 'SELECT BATCH') {
        showError('batchName', '#ff6666', "Please select batch");
        return 0;
    } else {
        showError('batchName', '', " ");
    }
    if (semester == 0) {
        showError('semester', '#ff6666', "Please select semester");
        return 0;
    } else {
        showError('semester', '', " ");
    }
    return 1;
}

function timeTablevalidation() {
    resetTableErrors();
    var table = document.getElementById("timeTableBody");
    for (var r = 0, n = table.rows.length; r < n; r++) {
        // lecture date
        if (table.rows[r].cells[0].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[0].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter lecture date");
            return 0;
        } else table.rows[r].cells[0].getElementsByTagName("input")[0].style.backgroundColor = "";

        // if (!validateDate(table.rows[r].cells[0].getElementsByTagName("input")[0].value.trim())) {
        //     table.rows[r].cells[0].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
        //     showError('', '#ff6666', "Date should be in dd/mm/yyyy format.");
        //     return 0;
        // } else table.rows[r].cells[0].getElementsByTagName("input")[0].style.backgroundColor = "";

        // lecture day
        if (table.rows[r].cells[1].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter lecture day");
            return 0;
        } else table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";

        // lecture start time
        if (table.rows[r].cells[2].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter start time");
            return 0;
        } else table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

        // if (!validateTime(table.rows[r].cells[2].getElementsByTagName("input")[0].value.trim())) {
        //     table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
        //     showError('', '#ff6666', "Time should be in HH:MM AM/PM format.");
        //     return 0;
        // } else table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

        // lecture end time
        if (table.rows[r].cells[3].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter end time");
            return 0;
        } else table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";

        // if (!validateTime(table.rows[r].cells[3].getElementsByTagName("input")[0].value.trim())) {
        //     table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
        //     showError('', '#ff6666', "Time should be in HH:MM AM/PM format.");
        //     return 0;
        // } else table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";

        // if (!validateTime(table.rows[r].cells[3].getElementsByTagName("input")[0].value.trim())) {
        //     table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
        //     showError('input', '#ff6666', "Enter the time in 24 hours(HH:MM) format.");
        //     return 0;
        // } else table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";

        // subject name
        if (table.rows[r].cells[4].getElementsByTagName("select")[0].value.trim() == '') {
            table.rows[r].cells[4].getElementsByTagName("select")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter the subject name");
            return 0;
        } else table.rows[r].cells[4].getElementsByTagName("select")[0].style.backgroundColor = "";

        // faculty name
        tempFacultyOptions = table.rows[r].cells[5].getElementsByTagName("select")[0];
        var tempFacultyText = tempFacultyOptions[tempFacultyOptions.selectedIndex].text;
        if (tempFacultyText == 'SELECT FACULTY') {
            table.rows[r].cells[5].getElementsByTagName("select")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Select faculty name");
            return 0;
        } else table.rows[r].cells[5].getElementsByTagName("select")[0].style.backgroundColor = "";
    }
}

function prepareTableData() {
    lectureDate = [];
    lectureDay = [];
    lectureStartTime = [];
    lectureEndTime = [];
    subject = [];
    facultyName = [];
    facultyId = [];
    var table = document.getElementById("timeTableBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        let tempDate = table.rows[r].cells[0].getElementsByTagName("input")[0].value;
        let tempDay = table.rows[r].cells[1].getElementsByTagName("input")[0].value.trim().toUpperCase();
        let tempStartTime = table.rows[r].cells[2].getElementsByTagName("input")[0].value;
        let tempEndTime = table.rows[r].cells[3].getElementsByTagName("input")[0].value;
        let tempSubject = table.rows[r].cells[4].getElementsByTagName("select")[0].value.toUpperCase();
        let tempFacultyId = table.rows[r].cells[5].getElementsByTagName("select")[0].value.toUpperCase();

        var tempFacultyOptions = table.rows[r].cells[5].getElementsByTagName("select")[0];
        let tempFacultyName = tempFacultyOptions[tempFacultyOptions.selectedIndex].text;


        lectureDate.push(tempDate);
        lectureDay.push(tempDay);
        lectureStartTime.push(tempStartTime);
        lectureEndTime.push(tempEndTime);
        facultyName.push(tempFacultyName);
        facultyId.push(tempFacultyId);
        subject.push(tempSubject);
    }
    return 1;
}
function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\'")
        .replace(/\"/g, "\"");
    return output;
}
function saveTimetable() {
    var saveFlag = 'saveTimetable';
    document.getElementById('saveButton').disabled = true;
    if (formValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (timeTablevalidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (prepareTableData() == 0) return 0;
    if (checkOnline() == false) {
        document.getElementById("saveButton").disabled = false;
        return;
    }

    if (confirm("Are you sure you want to save Time table")) {
        document.getElementById('errorMessage').innerHTML = '';
        document.getElementById('successMessage').innerHTML = 'Saving Please wait.....';
        $.post('saveTimetable.php', {
            'saveFlag': saveFlag,
            'lectureDate': lectureDate,
            'lectureDay': lectureDay,
            'lectureStartTime': lectureStartTime,
            'lectureEndTime': lectureEndTime,
            'facultyName': facultyName,
            'facultyId': facultyId,
            'subject': subject,
            'academicYear': academicYear,
            'batchId': batchId,
            'batchName': batchName,
            'semester': semester
        },
            function (data) {
                document.getElementById('successMessage').innerHTML = ' Timetable Successfuly Added. Please wait. The page will get auto-refresh...';
                location.reload();
            });
    }
    else document.getElementById("saveButton").disabled = false;
}