<?php
session_start();
if (strlen($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    if ($_SESSION['academicExecutiveLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
$academicExecutiveId = $_SESSION['academicExecutiveUserid'];
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">ALL QUERIES</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="allQueriesTable">
                                <thead>
                                    <tr>
                                        <th width='10%'>QUERY ID</th>
                                        <th width='10%'>BATCH NAME</th>
                                        <th width='10%'>ROLLNO.</th>
                                        <th width='15%'>STUDENT NAME</th>
                                        <th width='20%'>TIME</th>
                                        <th width='15%'>STATUS</th>
                                        <th width='10%'>RATING</th>
                                        <th width='10%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT s.rating,s.firstName,s.lastName,s.studentId,s.queryId,s.status,s.queryTime,ls.batchName FROM studentsupport s INNER JOIN loginstudents ls ON s.studentId = ls.studentId WHERE s.queryTransferedTo = '$academicExecutiveId' AND s.status !='REVISION REQUESTED' ORDER BY s.queryId desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $queryId = '';
                                            $batchName = '';
                                            $studentName = '';
                                            $statusCss = '';
                                            $ratingCss = '';
                                            $tempRating = '';
                                            $rating = '';

                                            $queryId = $row['queryId'];
                                            $batchName = $row['batchName'];
                                            $studentName = $row['firstName'] . ' ' . $row['lastName'];
                                            $tempRating = $row['rating'];

                                            if ($tempRating == '') $tempRating = 0;
                                            if ($tempRating == 'PENDING') {
                                                $tempRating = 0;
                                                $rating = 'PENDING';
                                            }
                                            if ($tempRating > 0) $rating = ((floatVal($tempRating))) . '/' . '10';

                                            if ($row['status'] == 'PENDING') $statusCss = 'badge badge-danger';
                                            if ($row['status'] == 'UNDER PROCESS') $statusCss = 'badge badge-warning';
                                            if ($row['status'] == 'RESOLVED') $statusCss = 'badge badge-success';
                                            if ($row['status'] == 'UNRESOLVED') $statusCss = 'badge badge-primary';
                                            if ($row['status'] == 'REJECTED') $statusCss = 'badge badge-danger';
                                            if ($row['status'] == 'REVISION REQUESTED') $statusCss = 'badge badge-secondary';
                                            if ($row['status'] == 'RESPONDED') $statusCss = 'badge badge-success';

                                            if ($rating == 'PENDING') $ratingCss = 'badge badge-danger';
                                            else $ratingCss = '';

                                            echo "
                                            <tr class='tAC'>
                                                <td id = " . $row['queryId'] . "> " . $row['queryId'] . "</td>
                                                <td>" . $batchName . "</td>
                                                <td>" . $row['studentId'] . "</td>
                                                <td>" . $studentName . "</td>
                                                <td>" . $row['queryTime'] . "</td>
                                                <td><span class = '" . $statusCss . "'>" . $row['status'] . "</span></td>
                                                <td><span class = '" . $ratingCss . "'>" . $rating . "</span></td>
                                                <td class='project-actions'>
                                                    <a class='btn btn-primary btn-sm' href='#' onclick='showDetails(this.id)' id = " . $queryId . " title='click hear to view Query Details'>
                                                        <i class='fas fa-eye'>
                                                        </i>
                                                    </a>
                                                </td>
                                            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script>
    $(function() {
        $("#allQueriesTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });

    function showDetails(id) {
        encodedValue_id = btoa(id);
        window.location.href = "viewQuery.php?qId=" + encodedValue_id;
    }
</script>
<?php require '../../common/footer.php'; ?>