<?php
session_start();
if (strlen($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    if ($_SESSION['academicExecutiveLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';

$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}

$batchNameList = [];
$sql2 = "SELECT * FROM batchmaster where batchStatus='PENDING';";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($batchNameList, $row2);
    }
}

// $studentNameList = [];
// $sql3 = "SELECT sf.academicYear, ls.batchId,ls.batchName FROM studentfee as sf,loginstudents as ls WHERE sf.studentId = ls.studentId;";
// $result3 = $conn->query($sql3);
// if ($result3->num_rows > 0) {
//     while ($row3 = $result3->fetch_assoc()) {
//         array_push($studentNameList,$row3);

//     }
// }

require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header newCardHeader">
                            <h3 class="card-title fSB">STUDENT ENROLLMENT</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <label> Academic Years <span class="star">*</span></label>
                                    <select class="form-control custom-select" id="academicYear"
                                        onchange="filterOtherDropDown('academicYear')">
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label> Batch Name <span class="star">*</span></label>
                                    <select class="form-control custom-select" id="batchName"
                                        onchange="filterOtherDropDown('batch')">
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Vacant Slots</label>
                                        <input type="number" class="form-control" id="vacantSlot" disabled></input>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">STUDENT LIST</h3>
                                    <div class="card-body">
                                        <table class="table table-striped projects tAC" id="studentListTable">
                                            <thead>
                                                <tr>
                                                    <th class="col-md-2">
                                                        Student ID
                                                    </th>
                                                    <th class="col-md-3">
                                                        Student Name
                                                    </th>
                                                    <th class="col-md-3">
                                                        Academic Year
                                                    </th>
                                                    <th class="col-md-2">
                                                        Actions
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $allStudentDetails = [];
                                                $sql = "SELECT * FROM loginstudents where batchId='' AND batchName='' AND admissionStatus='CONFIRMED' ORDER BY studentId DESC;";
                                                $result = $conn->query($sql);
                                                if ($result->num_rows > 0) {
                                                    while ($row = $result->fetch_assoc()) {
                                                        array_push($allStudentDetails, $row);
                                                        $studentAcademicYear = '';
                                                        $studentId = '';
                                                        $studentname = '';
                                                        $studentId = $row['studentId'];
                                                        $studentname = $row['firstname'].' '.$row['middleName'].' '.$row['lastname'];
                                                        $sql2 = "SELECT academicYear FROM studentfee WHERE studentId = '".$studentId."';";
                                                        $result2 = $conn->query($sql2);
                                                        if ($result2->num_rows > 0) {
                                                            while ($row2 = $result2->fetch_assoc()) {
                                                                $studentAcademicYear = $row2['academicYear'];
                                                            }
                                                        }
                                                        echo "
                                                            <tr class='tAC'>                                                                                                     
                                                                <td>" . $row['studentId'] . "</td> 
                                                                <td>" . $studentname . "</td>
                                                                <td>" . $studentAcademicYear . "</td>
                                                                <td><input type='checkbox' id = '".$studentId."' onchange='updateCheckCount(this.id)' value = " . $studentId . " title='click here add student'></td></input>
                                                        </tr>  ";
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer tAC">
                <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                </p>
                <p id='successMessage' class="text-center"
                    style="color: #25C032; font-size: 1.2em;   text-align: center;">
                </p>
                <p id='message' class="text-center" style="color: white; font-size: 1em;   text-align: center;">
                </p>
                <span id="savedData"></span>
                <input type="button" class="btn btn-primary" value="Add Students" onclick="addStudent()"
                    id="saveButton" />
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<!-- <script src="batch.js?v=<?php echo $fileVersion; ?>"></script> -->
<script src="pendingStudentEnrollment.js?v=<?php echo $fileVersion; ?>"></script>

<script>
var academicYearList = <?php echo json_encode($academicYearList) ?>;
var batchNameList = <?php echo json_encode($batchNameList) ?>;
var allStudentDetails = <?php echo json_encode($allStudentDetails) ?>;

$(function() {
    $("#studentListTable").DataTable({
        "responsive": true,
        "autoWidth": false,
        "aLengthMenu": [
            [5, 10, 25, 50, 75, -1],
            [5, 10, 25, 50, 75, "All"]
        ],
        "pageLength": 20,
        "aaSorting": [],
    });

    $.fn.dataTableExt.afnFiltering.push(
        function(settings, data, dataIndex) {
            selectedAcademicYear = getSelectValues('', document.getElementById("academicYear")).trim();
            var rowAcademicYear = data[2];

            if (selectedAcademicYear != 'SELECT ACADEMIC YEAR') {
                inAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) !== -1) ? rowAcademicYear :
                    false;
            } else inAcademicYear = true;
            return inAcademicYear;
        }
    );

    loadDataDropdown("academicYear", academicYearList);
    loadDataDropdown("batchName", batchNameList);
});
</script>
<?php require '../../common/footer.php'; ?>