selectedStudentList = [];
selectedStudentDetails = [];
var selectedStudentCount = 0;
var enrolledStudentCount = 0;
var batchCapacity = 0;
var batchId = '',
    batchName = '',
    academicYear = '';

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}


function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "academicYear") dummyOptions(theSelect, options, "ACADEMIC YEAR");
    if (selectName == "batchName") dummyOptions(theSelect, options, "BATCH");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("academicYear")) {
            academicYear1 = results[i].firstAcademicYear.split("-");
            academicYear2 = results[i].thirdAcademicYear.split("-");
            academicYear = academicYear1[0] + '-' + academicYear2[1];
            options.value = options.text = academicYear;
            theSelect.add(options);
        } else if (selectName.includes("batchName")) {
            options.text = results[i].batchTitle;
            options.value = results[i].batchId;
            theSelect.add(options);
        }
    }
}

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";
    options.disabled = false;
    options.selected = true;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
        if (flag == "value") {
            if (opt.selected) {
                result += opt.value;
            }
        }
    }
    return result.trim();
}

function filterOtherDropDown(flag) {
    tempAcademicYear = getSelectValues('', document.getElementById("academicYear")).trim();
    tempBatchId = getSelectValues('value', document.getElementById("batchName")).trim();
    tempBatchList = [];
    tempVacantSlot = 0;
    enrolledStudentCount = 0;
    batchCapacity = 0;
    if (flag == "academicYear") {
        loadDataDropdown("batchName", batchNameList);
        for (let i = 0; i < batchNameList.length; i++) {
            if (batchNameList[i].academicYear == tempAcademicYear) {
                tempdata = batchNameList[i].batchTitle;
                tempdataId = batchNameList[i].batchId;
                tempBatchList.push(obj = {
                    "batchTitle": tempdata,
                    "batchId": tempdataId
                });
                loadDataDropdown("batchName", tempBatchList);
                var table = $('#studentListTable').DataTable();
                table.draw();
            }
        }
    } else if (flag == "batch") {
        for (let i = 0; i < batchNameList.length; i++) {
            if (batchNameList[i].academicYear == tempAcademicYear && batchNameList[i].batchId == tempBatchId) {
                batchCapacity = batchNameList[i].capacity;
                enrolledStudentCount = batchNameList[i].noOfStudents;
                if (isNaN(enrolledStudentCount)) enrolledStudentCount = 0;
            }
        }
        tempVacantSlot = parseInt(batchCapacity) - parseInt(enrolledStudentCount);
        document.getElementById('vacantSlot').value = tempVacantSlot;
    }
}
function updateCheckCount(checkId) {
    if (document.getElementById(checkId).checked) {
        selectedStudentCount = selectedStudentCount + 1;
        selectedStudentList.push(checkId);
    }
    else {
        selectedStudentCount = selectedStudentCount - 1;
        for (var i = 0; i < selectedStudentList.length; i++) {
            if (selectedStudentList[i] == checkId) {
                selectedStudentList.splice(i, 1);
            }
        }
    }
    document.getElementById('message').innerHTML = 'you have selected  ' + selectedStudentCount + '  student(s)';
}

function formValidation() {
    academicYear = '';
    batchName = '';
    batchId = '';
    vacantSlot = parseInt(batchCapacity) - parseInt(enrolledStudentCount);

    academicYear = document.getElementById('academicYear').value.trim();
    tempBatchOption = document.getElementById('batchName');
    batchName = tempBatchOption.options[tempBatchOption.selectedIndex].text.trim();
    batchId = tempBatchOption.options[tempBatchOption.selectedIndex].value.trim();

    if (academicYear == 0) {
        showError('academicYear', '#ff6666', "Please select academic year");
        return 0;
    } else {
        showError('academicYear', '', " ");
    }

    if (batchId == 0) {
        showError('batchName', '#ff6666', "Please select batch");
        return 0;
    } else {
        showError('batchName', '', " ");
    }

    if (parseInt(selectedStudentCount) == 0) {
        showError('', '#ff6666', "Please select at least 1 student");
        return 0;
    } else {
        showError('', '', " ");
    }

    // console.log(selectedStudentCount, enrolledStudentCount, batchCapacity, vacantSlot);
    if (parseInt(selectedStudentCount) > parseInt(vacantSlot)) {
        showError('', '#ff6666', "Batch Limit Exceeded." + vacantSlot + " slots are available");
        return 0;
    } else {
        showError('', '', " ");
    }

    return 1;
}

function getStudentDetails() {
    for (i = 0; i < allStudentDetails.length; i++) {
        for (j = 0; j < selectedStudentList.length; j++) {
            if (allStudentDetails[i]['studentId'] == selectedStudentList[j]) {
                selectedStudentDetails.push(allStudentDetails[i]);
            }
        }
    }
    return 1;
}

function addStudent() {
    var saveFlag = 'addStudent';
    document.getElementById('saveButton').disabled = true;
    if (formValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    if (checkOnline() == false) {
        document.getElementById("saveButton").disabled = false;
        return;
    }
    if (getStudentDetails() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    // console.log(selectedStudentCount);
    if (confirm("Are you sure you want to add " + selectedStudentCount + " student(s) in '" + batchName + "' batach ???")) {
        document.getElementById('saveButton').disabled = true;
        document.getElementById('successMessage').innerHTML = 'Adding student in batch. Please wait...';
        $.post('savePendingStudentEnrollment.php', {
            'selectedStudentDetails': selectedStudentDetails,
            'saveFlag': saveFlag,
            'academicYear': academicYear,
            'batchName': batchName,
            'batchId': batchId,
        },
            function (data) {
                // console.log(data);
                document.getElementById('successMessage').innerHTML = 'students added successfully. Please wait. The page will get auto-refresh...';
                location.reload();
            })
    }
    else document.getElementById("saveButton").disabled = false;
}
