<?php
session_start();
if (strlen($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    if ($_SESSION['academicExecutiveLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';

$academicYearList = [];

$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">ALL BATCHES</h3>
                                    <br>
                                    <br>
                                    <div class='row'>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                                <select class="select2" multiple="multiple" id="filterAyear" data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;" onchange="filterTable('studAyear')" ;>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="batchTable">
                                <thead>
                                    <tr>
                                        <th class='col-md-1'>
                                            BATCH ID
                                        </th>
                                        <th class='col-md-2'>
                                            BATCH NAME
                                        </th>
                                        <th class='col-md-2'>
                                            ACADEMIC YEAR
                                        </th>
                                        <th class='col-md-2'>
                                            CAPACITY
                                        </th>
                                        <th class='col-md-2'>
                                            NO OF STUDENTS IN BATCH
                                        </th>
                                        <th class='col-md-2'>
                                            BATCH STATUS
                                        </th>
                                        <th class='col-md-1'>
                                            ACTION
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * FROM batchmaster ORDER BY batchId DESC; ";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $batchId = $row['batchId'];
                                            $batchStatus = $row['batchStatus'];
                                            if ($batchStatus == 'PENDING') $statusCss = 'badge badge-danger';
                                            if ($batchStatus == 'COMPLETED') $statusCss = 'badge badge-success';

                                            echo "
                                            <tr  class='tAC'>                                                                                                     
                                                <td>" . $batchId . "</td> 
                                                <td>" . $row['batchTitle'] . "</td> 
                                                <td>" . $row['academicYear'] . "</td> 
                                                <td>" . $row['capacity'] . "</td>
                                                <td>" . $row['noOfStudents'] . "</td>
                                                <td><span class = '" . $statusCss . "'>" . $row['batchStatus'] . "</span></td>
                                                <td class='project-actions'>
                                                    <a class='btn btn-primary btn-sm' href='#' onclick='showBatchDetails(this.id)' id = " . $batchId . " title='click here to view batch Details'>
                                                        <i class='fas fa-eye'>
                                                        </i>
                                                    </a>
                                                </td>
                                            </tr>  ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="manageBatch.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    $(function() {
        $('.select2').select2();
            $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();

                var rowAcademicYear = data[2].trim();

                if (selectedAcademicYear != '') {
                    inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ? rowAcademicYear : false;
                } else inStudAcademicYear = true;
                return inStudAcademicYear;


            }
        );

        $("#batchTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        loadDataDropdown("filterAyear", academicYearList);
    });
</script>
<?php require '../../common/footer.php'; ?>