<?php
session_start();
if (strlen($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    if ($_SESSION['academicExecutiveLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
if (isset($_GET['sId'])) {
    $sessionPlanId = base64_decode($_GET['sId']);

    $masterList = [];
    $sql = "SELECT * FROM sessionplan where sessionPlanId = '" . $sessionPlanId . "';";
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $firstRow = $row;
            array_push($masterList, $row);
        }
    }

    $semester = [];
    $sql2 = "SELECT * FROM semester;";
    $result2 = $conn->query($sql2);
    if ($result2->num_rows > 0) {
        while ($row2 = $result2->fetch_assoc()) {
            array_push($semester, $row2);
        }
    }

    $subjectNames = [];
    $sql3 = "SELECT * FROM subjects;";
    $result3 = $conn->query($sql3);
    if ($result3->num_rows > 0) {
        while ($row3 = $result3->fetch_assoc()) {
            array_push($subjectNames, $row3);
        }
    }

    $facultyName = [];
    $sql4 = "SELECT facultyId,firstName,lastName,facultySubject FROM faculty where formStatus = 'APPROVED' order by facultyId desc;";
    $result4 = $conn->query($sql4);
    if ($result4->num_rows > 0) {
        while ($row4 = $result4->fetch_assoc()) {
            array_push($facultyName, $row4);
        }
    }
}
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header">
                            <h3 class="card-title fSB">1. Session Plan Create
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Session Plan Id</label>
                                        <input type="text" class="form-control tAC" id="sessionPlanId"
                                            value="<?php echo $sessionPlanId; ?>" placeholder="Enter Id" disabled>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Semester <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="semester" style="width: 100%;"
                                            onchange="filterOtherDropDown('semester');">
                                            <option disabled selected>SELECT SEMESTER</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Subject <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="subjectNames"
                                            onchange="filterOtherDropDown('subject');" style=" width: 100%;">
                                            <option disabled selected>SELECT SUBJECT</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Faculty Name <span class="star">*</span></label>
                                        <select class="select2" id="facultyName" style="width: 100%;"
                                            data-placeholder="Select Faculty" multiple>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card card-warning">
                        <div class="card-header">
                            <h3 class="card-title fSB">2. Session Plan Form Details</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <table class="table table-striped p0 tAC" id="sessionPlanTable">
                                    <thead>
                                        <tr>
                                            <th style="width:16%;">Unit No</th>
                                            <th style="width:20%;">Topic Covered</th>
                                            <th style="width:7%;">Total SubTopic</th>
                                            <th style="width:23%;">Sub Topic/Topic Min</th>
                                            <th style="width:19%;">Objective</th>
                                            <!-- <th style="width:25%;">Theory % Practical % Pedagogy</th> -->
                                            <th style="width:10%;">Total Mins</th>
                                            <th style="width:5%;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="sessionPlanTableBody">
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th style="width:16%;">Unit No</th>
                                            <th style="width:20%;">Topic Covered</th>
                                            <th style="width:7%;">Total SubTopic</th>
                                            <th style="width:23%;">Sub Topic/Topic Min</th>
                                            <th style="width:19%;">Objective</th>
                                            <!-- <th style="width:25%;">Theory % Practical % Pedagogy</th> -->
                                            <th style="width:10%;" id="totalNoOFHours">Total Hrs</th>
                                            <th style="width:5%;">Action</th>
                                            </th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <div class="card-footer tAC">
                            <p id='errorMessage' class="text-center"
                                style="color: red; font-size: 1.2em;   text-align: center;">
                            </p>
                            <p id='successMessage' class="text-center"
                                style="color: #25C032; font-size: 1.2em;   text-align: center;">
                            </p>
                            <span id="savedData"></span>
                            <input type="button" class="btn btn-primary" value="Update" onclick="updateSesssionPlan()"
                                id="saveButton" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<!-- <script src="masterSessionPlan.js?v=<?php echo $fileVersion; ?>"></script> -->
<script src="editSessionPlan.js?v=<?php echo $fileVersion; ?>"></script>
<script>
var masterList = <?php echo json_encode($masterList); ?>;
var semester = <?php echo json_encode($semester); ?>;
var subjectNames = <?php echo json_encode($subjectNames); ?>;
var facultyNameList = <?php echo json_encode($facultyName); ?>;
$(function() {
    $(document).ready(function() {
        $('.select2').select2();
        addTableRow('Edit', masterList,'start');
        loadDataDropdown("semester", semester);
        selectValuesInDropdown("text", "semester", masterList[0].semester);
        filterOtherDropDown('semester');
        selectValuesInDropdown("text", "subjectNames", masterList[0].subjectName);
        filterOtherDropDown('subject');
        // selectValuesInDropdown("text", "facultyName", masterList[0].facultyName);
        var tempFacultyId = masterList[0].facultyId.split("|");
        if (tempFacultyName.length > 0) selectValuesInDropdown("value", "facultyName", tempFacultyId);
    });
});
</script>
<?php require '../../common/footer.php'; ?>