var semester = '',
    subjectName = '',
    subjectId = '',
    facultyName = '',
    facultyId = '';
var totalHours = '';
var typeOfPayment = '',
    paymentPHrs = '',
    totalPayment = '';
var tableContent = [];

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function addTableRow(flag, result, type) {
    let tempRowID = '';
    if (type != 'start') tempRowID = type.split("addButton");
    if (flag != 'Edit')
        if (checkTableContentIsNotEmpty() == 0) return;

    var mytable = document.getElementById("sessionPlanTableBody"),
        newRow,
        newCell;
    var currentIndex = mytable.rows.length;
    for (let i = 0; i < result.length; i++) {
        if (flag == 'Edit') var rowId = i;
        else if (flag != 'Edit') rowId = currentIndex;

        var newRow = document.createElement("tr");
        if (type != 'start') newRow = mytable.insertRow(parseInt(tempRowID[1]) + 1);
        else mytable.appendChild(newRow);

        newCell = document.createElement("td");
        var newSelect = document.createElement("select");
        newSelect.setAttribute("id", "unitNo" + rowId);
        newSelect.setAttribute("class", "form-control custom-select mT10");
        newCell.appendChild(newSelect);
        newRow.appendChild(newCell);
        loadDataDropdown("unitNo" + rowId, unitList);
        if (flag == 'Edit')
            selectDropdownValue("unitNo" + rowId, result[i].tableunitno);

        newCell = document.createElement("td");
        var topicCovered = document.createElement("textarea");
        topicCovered.setAttribute("rows", "2");
        topicCovered.setAttribute("placeholder", "Topic Covered");
        if (flag == 'Edit')
            topicCovered.value = result[i].tableTopicCovered;
        if (setAtter(newRow, newCell, topicCovered, 'form-control mT10', "topicCovered" + rowId) == 0) return 0;


        newCell = document.createElement("td");
        var noOfSubTopic = document.createElement("input");
        noOfSubTopic.setAttribute("id", "noOfSubTopic" + rowId);
        noOfSubTopic.setAttribute("class", "form-control mT10");
        noOfSubTopic.setAttribute("type", "number");
        noOfSubTopic.setAttribute("onchange", "addInsideRow(this.id)");
        if (flag == 'Edit')
            noOfSubTopic.value = result[i].noOfSubTopic;
        newCell.appendChild(noOfSubTopic);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var subTopicAndHours = document.createElement("ul");
        subTopicAndHours.setAttribute("id", "objectiveAndHours" + rowId);
        subTopicAndHours.setAttribute("class", "mT10 p0");
        if (flag == 'Edit')
            if (result[i].noOfSubTopic > 0) {
                var tempSplit = result[i].subTopic.split("|");
                var tempHoursSplit = result[i].subTopicMinutes.split("|");

                for (var j = 0; n = result[i].noOfSubTopic, n > j; j++) {

                    var li = document.createElement("li");
                    if (j != 0)
                        li.setAttribute("class", "mT10");
                    li.style = "display: -webkit-box";

                    var subTopicValue = document.createElement("textarea");
                    subTopicValue.setAttribute("class", "form-control");
                    subTopicValue.setAttribute("type", "text");
                    subTopicValue.setAttribute("rows", "2");
                    subTopicValue.setAttribute("placeholder", "Sub Topic");
                    subTopicValue.id = "subTopic" + i + "rowSubTopic" + j;
                    subTopicValue.style = "width:70%";

                    var subTopichoursValue = document.createElement("input");
                    subTopichoursValue.setAttribute("class", "form-control mL10");
                    subTopichoursValue.setAttribute("type", "number");
                    subTopichoursValue.setAttribute("onchange", "calculateRowsTotal();");
                    subTopichoursValue.setAttribute("placeholder", "Min");
                    subTopichoursValue.id = "subTopic" + i + "rowHours" + j;
                    subTopichoursValue.style = "width:30%";

                    li.innerHTML += subTopicValue.outerHTML + subTopichoursValue.outerHTML;
                    subTopicAndHours.appendChild(li);
                    newCell.appendChild(subTopicAndHours);
                    newRow.appendChild(newCell);
                    document.getElementById("subTopic" + i + "rowSubTopic" + j).value = tempSplit[j];
                    document.getElementById("subTopic" + i + "rowHours" + j).value = tempHoursSplit[j];
                }
            }
        if (flag != 'Edit') {
            newCell.appendChild(subTopicAndHours);
            newRow.appendChild(newCell);
        }

        newCell = document.createElement("td");
        var objectiveValue = document.createElement("textarea");
        objectiveValue.setAttribute("class", "form-control mT10");
        objectiveValue.setAttribute("id", "topicCovered" + rowId);
        objectiveValue.setAttribute("rows", "2");
        objectiveValue.setAttribute("placeholder", "Objective");
        if (flag == 'Edit')
            objectiveValue.value = result[i].objective;
        newCell.appendChild(objectiveValue);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        newCell.style = "padding-left:0px;padding-right:20px;";
        var thearyUi = document.createElement("ul");
        thearyUi.setAttribute("id", "thePraPro" + rowId);
        thearyUi.setAttribute("class", "mT10 p0");

        newCell = document.createElement("td");
        newCell.setAttribute("id", "totalHours" + rowId);
        if (flag == 'Edit')
            newCell.innerHTML = result[i].totalHours;
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        newCell.style.display = "grid";
        let aButton = document.createElement("a");
        aButton.className = "btn btn-success ";
        aButton.id = "addButton" + rowId;
        aButton.setAttribute("title", "Add New Row");
        aButton.setAttribute("onClick", "addTableRow('Add',['1'],this.id);");
        let inputAt = document.createElement("i");
        inputAt.className = "fa fa-plus-circle";
        inputAt.style.fontSize = '18px';
        aButton.append(inputAt);

        var deleteButton = document.createElement("a");
        deleteButton.setAttribute("id", "deleteButton1" + rowId);
        deleteButton.setAttribute("class", "btn btn-danger mT10");
        deleteButton.setAttribute("title", "Delet Current Row");
        deleteButton.setAttribute("onclick", "deleteRow(this)");
        let inputDt = document.createElement("i");
        inputDt.className = "fa fa-trash";
        inputDt.style.fontSize = '18px';
        deleteButton.append(inputDt);
        newCell.appendChild(aButton);
        if (rowId > 0)
            newCell.appendChild(deleteButton);
        newRow.appendChild(newCell);
        if (resetId() == 0) return 0;
    }
    calculateRowsTotal();
}

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = true;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "semester") dummyOptions(theSelect, options, "SEMESTER");
    else if (selectName == "subjectNames") dummyOptions(theSelect, options, "SUBJECT");
    else if (selectName.includes("unitNo")) dummyOptions(theSelect, options, "UNIT");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");

        if (selectName.includes("semester")) {
            options.value = results[i].semesterValue.toUpperCase();
            options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectNames")) {
            options.value = results[i].subjectId.toUpperCase();
            options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("facultyName")) {
            options.value = results[i].facultyId.toUpperCase();
            options.text = results[i].facultyName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("unitNo")) {
            options.value = options.text = results[i].value.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].value;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function selectValuesInDropdown(flag, selectName, results) {
    var theSelect = document.getElementById(selectName);
    if (flag == 'value') {
        for (var i = 0; i < results.length; i++) {
            for (var j = 0; j < theSelect.options.length; j++) {
                var optVal = theSelect.options[j].value;
                if (optVal == results[i]) {
                    theSelect.options[j].selected = true;
                }
            }
        }
    } else if (flag == 'text') {
        for (var j = 0; j < theSelect.options.length; j++) {
            var optText = theSelect.options[j].text;
            if (optText == results) {
                theSelect.options[j].selected = true;
            }
        }
    }
    return;
}

function filterOtherDropDown(flag) {
    tempSemester = getSelectValues('value', document.getElementById("semester")).trim().slice(0, -1);
    tempSubjectName = [];
    tempFacultyName = [];
    if (flag == 'semester') {
        loadDataDropdown("subjectNames", []);
        loadDataDropdown("facultyName", []);
        for (let i = 0; i < subjectNames.length; i++) {
            if (subjectNames[i].semester == tempSemester) {
                tempSubjectName.push(obj = {
                    "subjectId": subjectNames[i].subjectId,
                    "subjectName": subjectNames[i].subjectName
                });
            }
            loadDataDropdown("subjectNames", tempSubjectName);
        }
    } else if (flag == 'subject') {
        tempSubjectOptions = getSelectValues('', document.getElementById("subjectNames"));
        for (var i = 0; n = facultyNameList.length, n > i; i++) {
            if (facultyNameList[i].facultySubject.includes(tempSubjectOptions)) {
                tempFacultyName.push(obj = {
                    "facultyName": facultyNameList[i].firstName + ' ' + facultyNameList[i].lastName,
                    "facultyId": facultyNameList[i].facultyId
                });
            }
        }
        loadDataDropdown("facultyName", tempFacultyName);
    }
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
        if (flag == "value") {
            if (opt.selected) {
                result += opt.value + "|";
            }
        }
    }
    return result.trim();
}

function addTableRowView(masterList, flag) {
    var mytable = document.getElementById("sessionPlanTableBody"),
        newRow,
        newCell;

    var totalMin = 0;
    for (var i = 0; n = masterList.length, n > i; i++) {
        var newRow = document.createElement("tr");
        mytable.appendChild(newRow);

        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].tableunitno;
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].tableTopicCovered;
        newRow.appendChild(newCell);


        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].noOfSubTopic;
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var subTopicAndHours = document.createElement("ul");


        if (masterList[i].noOfSubTopic > 0) {
            var tempSplit = masterList[i].subTopic.split("|");
            var tempHoursSplit = masterList[i].subTopicMinutes.split("|");

            for (var j = 0; n = masterList[i].noOfSubTopic, n > j; j++) {

                var li = document.createElement("li");
                if (j != 0)
                    li.setAttribute("class", "mT10");
                li.style = "display: -webkit-box";
                var subTopicValue = document.createElement("div");
                subTopicValue.innerHTML = tempSplit[j];
                subTopicValue.style = "width:70%";

                var subTopichoursValue = document.createElement("div");
                subTopichoursValue.innerHTML = tempHoursSplit[j];
                subTopichoursValue.style = "width:30%";

                totalMin = parseFloat(totalMin) + parseFloat(tempHoursSplit[j]);
                li.innerHTML += subTopicValue.outerHTML + subTopichoursValue.outerHTML;
                subTopicAndHours.appendChild(li);
                newCell.appendChild(subTopicAndHours);
                newRow.appendChild(newCell);
            }
        }

        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].objective;
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var subThePraPro = document.createElement("ul");

        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].totalMinutes;
        newRow.appendChild(newCell);

    }
    document.getElementById("totalNoOFHours").innerHTML = "Total Mins </br>" + totalMin;
}

function addInsideRow(id) {
    var tempData = document.getElementById(id).value;
    var temp = id;
    temp = temp.split("noOfSubTopic");
    var appandColoumn4 = document.getElementById("objectiveAndHours" + temp[1]);
    appandColoumn4.innerHTML = '';
    document.getElementById("totalHours" + temp[1]).value = '';

    if (tempData <= 0) {
        return 0;
    }
    for (let i = 0; i < tempData; i++) {

        var li = document.createElement("li");
        li.setAttribute("class", "mT10");
        li.style = "display: -webkit-box;padding-left:0px;";

        var subTopicValue = document.createElement("textarea");
        subTopicValue.setAttribute("class", "form-control");
        subTopicValue.setAttribute("type", "text");
        subTopicValue.setAttribute("rows", "2");
        subTopicValue.setAttribute("placeholder", "Sub Topic");
        subTopicValue.style = "width:70%";

        var subTopichoursValue = document.createElement("input");
        subTopichoursValue.setAttribute("class", "form-control mL10");
        subTopichoursValue.setAttribute("type", "number");
        subTopichoursValue.setAttribute("onchange", "calculateRowsTotal();");
        subTopichoursValue.setAttribute("placeholder", "Min");
        subTopichoursValue.style = "width:30%";

        li.innerHTML += subTopicValue.outerHTML + subTopichoursValue.outerHTML;
        appandColoumn4.appendChild(li);
    }
}



function checkTableContentIsNotEmpty() {
    resetTableErrors();
    const table = document.getElementById("sessionPlanTableBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        // unit dropdown
        if (table.rows[r].cells[0].getElementsByTagName("select")[0].selectedIndex == 0) {
            table.rows[r].cells[0].getElementsByTagName("select")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Pelase Select Valid Unit No");
            return 0;
        } else
            table.rows[r].cells[0].getElementsByTagName("select")[0].style.backgroundColor = "";

        //Topic Covered
        if (table.rows[r].cells[1].getElementsByTagName("textarea")[0].value == '') {
            table.rows[r].cells[1].getElementsByTagName("textarea")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Topic Covered cannot be blank.");
            return 0;
        } else
            table.rows[r].cells[1].getElementsByTagName("textarea")[0].style.backgroundColor = "";
        //Total sub Topic
        if (table.rows[r].cells[2].getElementsByTagName("input")[0].value == '') {
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Insert atleast 1 SubTopic");
            return 0;
        } else
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

        var tableUiRow = table.rows[r].cells[3].getElementsByTagName("ul")[0];
        var len = tableUiRow.getElementsByTagName("li").length;
        for (var i = 0; i < len; i++) {
            if (table.rows[r].cells[3].getElementsByTagName("textarea")[i].value == "") {
                table.rows[r].cells[3].getElementsByTagName("textarea")[i].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "SubTopic cannot be blank");
                return 0;
            } else
                table.rows[r].cells[3].getElementsByTagName("textarea")[i].style.backgroundColor = "";

            if (table.rows[r].cells[3].getElementsByTagName("input")[i].value == "") {
                table.rows[r].cells[3].getElementsByTagName("input")[i].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "SubTopic Minutes cannot be blank");
                return 0;
            } else
                table.rows[r].cells[3].getElementsByTagName("input")[i].style.backgroundColor = "";
        }
        if (table.rows[r].cells[4].getElementsByTagName("textarea")[0].value == "") {
            table.rows[r].cells[4].getElementsByTagName("textarea")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Objective cannot be blank");
            return 0;
        } else
            table.rows[r].cells[4].getElementsByTagName("textarea")[0].style.backgroundColor = "";
    }
    showError('', '', '');
    return 1;
}

function resetTableErrors() {
    const table = document.getElementById("sessionPlanTableBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        table.rows[r].cells[0].getElementsByTagName("select")[0].style.backgroundColor = "";
        table.rows[r].cells[1].getElementsByTagName("textarea")[0].style.backgroundColor = "";
        table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
        var tableUiRow = table.rows[r].cells[3].getElementsByTagName("ul")[0];
        var len = tableUiRow.getElementsByTagName("li").length;
        for (var i = 0; i < len; i++) {
            table.rows[r].cells[3].getElementsByTagName("textarea")[i].style.backgroundColor = "";
            table.rows[r].cells[3].getElementsByTagName("input")[i].style.backgroundColor = "";
        }
        table.rows[r].cells[4].getElementsByTagName("textarea")[0].style.backgroundColor = "";
    }
}

var unitList = [{
    'value': 'UNIT 1'
},
{
    'value': 'UNIT 2'
},
{
    'value': 'UNIT 3'
},
{
    'value': 'UNIT 4'
},
{
    'value': 'UNIT 5'
},
{
    'value': 'UNIT 6'
},
{
    'value': 'UNIT 7'
},
{
    'value': 'UNIT 8'
},
{
    'value': 'UNIT 9'
},
{
    'value': 'UNIT 10'
},
];

function setAtter(r, c, e, cl, id) {
    if (cl.length > 0) e.setAttribute("class", cl);
    if (id.length > 0) e.setAttribute("id", id);
    c.appendChild(e);
    r.appendChild(c);
    return 1;
}

function resetId() {
    let table = document.getElementById("sessionPlanTableBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        table.rows[r].cells[0].getElementsByTagName("select")[0].id = "unitNo" + r;
        table.rows[r].cells[1].getElementsByTagName("textarea")[0].id = "topicCovered" + r;
        table.rows[r].cells[2].getElementsByTagName("input")[0].id = "noOfSubTopic" + r;
        table.rows[r].cells[3].getElementsByTagName("ul")[0].id = "objectiveAndHours" + r;
        table.rows[r].cells[4].getElementsByTagName("textarea")[0].id = "objective" + r;
        table.rows[r].cells[5].id = "totalHours" + r;
        table.rows[r].cells[6].getElementsByTagName("a")[0].id = "addButton" + r;
        if (r > 0) table.rows[r].cells[6].getElementsByTagName("a")[1].id = "deleteButton1" + r;
    }
    return 1;
}

function calculateRowsTotal() {
    const table = document.getElementById("sessionPlanTableBody");
    var tempData = 0;
    var totalHours = 0;
    var TotalMin = 0;
    for (let r = 0, n = table.rows.length; r < n; r++) {
        var tempData = 0;
        var tableUlRow = table.rows[r].cells[3].getElementsByTagName("ul")[0];
        var len = tableUlRow.getElementsByTagName("li").length;
        if (len > 0) {
            for (var k = 0; k < len; k++) {
                var inputHours = table.rows[r].cells[3].getElementsByTagName("input")[k].value;
                if ((inputHours != '') && (inputHours <= 0)) {
                    table.rows[r].cells[3].getElementsByTagName("input")[k].style.backgroundColor = '#ff6666';
                    showError('', '#ff6666', 'Hours Cannot be less than Zero');
                    return 0;
                } else if (parseFloat(inputHours) > 0) {
                    TotalMin += parseFloat(inputHours);
                    table.rows[r].cells[3].getElementsByTagName("input")[k].style.backgroundColor = '';
                    showError('', '', '');
                    tempData = (parseFloat(tempData) + parseFloat(inputHours)).toFixed(2);
                }
                document.getElementById("totalHours" + r).innerHTML = tempData;
            }
        }
        document.getElementById("totalNoOFHours").innerHTML = "Total Mins<br>" + TotalMin;
    }
}

function tableValidation() {
    var table = document.getElementById("sessionPlanTableBody");
    tableContent = [];
    for (let r = 0, n = table.rows.length; r < n; r++) {
        var tempUnitNo = table.rows[r].cells[0].getElementsByTagName("select")[0];
        var tableUnitNo = tempUnitNo[tempUnitNo.selectedIndex].text;
        var tableTopicCovered = table.rows[r].cells[1].getElementsByTagName("textarea")[0].value;
        var tableTotalNoOfSubTopic = table.rows[r].cells[2].getElementsByTagName("input")[0].value;
        var tableSubTopic = '',
            tableSubTopicHours = '';
        var totalMinutes = 0;

        var tableUiRow = table.rows[r].cells[3].getElementsByTagName("ul")[0];
        var lim = tableUiRow.getElementsByTagName("li").length;
        for (let i = 0; i < lim; i++) {
            tableSubTopic = tableSubTopic + table.rows[r].cells[3].getElementsByTagName("textarea")[i].value + "|";
            tableSubTopicHours = tableSubTopicHours + table.rows[r].cells[3].getElementsByTagName("input")[i].value + "|";
            totalMinutes = totalMinutes + parseInt(table.rows[r].cells[3].getElementsByTagName("input")[i].value);
        }

        var tableObjective = table.rows[r].cells[4].getElementsByTagName("textarea")[0].value;
        var totalHours = table.rows[r].cells[5].innerHTML;
        tableTopicCovered = escapeSpecialCharacters(tableTopicCovered);
        tableSubTopic = escapeSpecialCharacters(tableSubTopic.slice(0, -1));
        tableObjective = escapeSpecialCharacters(tableObjective);
        var obj = {
            tableUnitNo: tableUnitNo,
            tableTopicCovered: tableTopicCovered,
            tableTotalNoOfSubTopic: tableTotalNoOfSubTopic,
            tableSubTopic: tableSubTopic,
            tableSubTopicHours: tableSubTopicHours.slice(0, -1),
            tableObjective: tableObjective,
            totalMinutes: totalMinutes
        };
        tableContent.push(obj);
    }
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"")
    return output;
}
function formValidation() {
    if (setHeaders() == 0) return 0;
    if (semester == 'SELECT SEMESTER') {
        showError('semester', '#ff6666', "Select Semester.");
        return 0;
    } else showError('semester', '', '');

    if (subjectName == 'SELECT SUBJECT') {
        showError('subjectNames', '#ff6666', "Select Subject.");
        return 0;
    } else showError('subjectNames', '', '');

    if (facultyName == '') {
        showError('facultyName', '#ff6666', "Select Faculty.");
        return 0;
    } else showError('facultyName', '', '');

    if (checkTableContentIsNotEmpty() == 0) return 0;
    if (tableValidation() == 0) return 0;

    return 1;
}

function setHeaders() {
    semester = '';
    subjectId = '';
    subjectName = '';
    facultyName = '';
    totalHours = '';
    typeOfPayment = '';
    paymentPHrs = '';
    totalPayment = '';
    tableContent = [];

    semester = getSelectValues('', document.getElementById("semester"));
    subjectName = getSelectValues('', document.getElementById("subjectNames"));
    subjectId = document.getElementById('subjectNames').value.trim();
    facultyName = getSelectValues('multiple', document.getElementById("facultyName")).slice(0, -1);
    facultyId = getSelectValues('value', document.getElementById("facultyName")).slice(0, -1);

    return 1;
}

function updateSesssionPlan() {
    document.getElementById("saveButton").disabled = true;
    var flag = "EDITFLAG";

    if (formValidation() == 0) {
        document.getElementById("saveButton").disabled = false;
        return;
    }
    if (checkOnline() == false) {
        document.getElementById("saveButton").disabled = false;
        return;
    }
    else {
        if (confirm("Are you sure you want to Update Session???")) {
            document.getElementById('successMessage').innerHTML = 'Updating... Please wait...';
            document.getElementById("saveButton").disabled = true;
            $.post('saveEditSessionPlan.php', {
                'flag': flag,
                'sessionPlanId': document.getElementById("sessionPlanId").value.trim(),
                'semester': semester,
                'subjectName': subjectName,
                'subjectId': subjectId,
                'facultyName': facultyName,
                'facultyId': facultyId,
                'tableContent': tableContent,
            }, function (data) {
                document.getElementById('successMessage').innerHTML = 'Session Updated Successfully. Please wait. The page will get auto-refresh...';
                location.reload();
            });
        }
        else document.getElementById("saveButton").disabled = false;
    }
}