

function addTableHeader() {
  const thead = document.getElementById("scoreTableHeader");
  const headerRow = document.createElement("tr");

 

  thead.appendChild(headerRow);
}

function addDataToModal(studentId) {
  const student = studentList.find(s => s.studentId === studentId);
  if (!student) return;

  document.getElementById("modalStudentName").value = `${student.firstname} ${student.lastname}`;
  document.getElementById("modalSubjectName").value = subjectName;
  document.getElementById("modalEditResult").dataset.studentId = studentId;

  const inputRow = document.getElementById("dynamicExamInputsRow");
  inputRow.innerHTML = ""; // Clear previous inputs

  subjectScoreStructure.forEach(item => {
    // Create col-md-2 container
    const col = document.createElement("div");
    col.className = "col-md-2";

    // Create form-group wrapper
    const formGroup = document.createElement("div");
    formGroup.className = "form-group";

    // Create label
    const label = document.createElement("label");
    label.textContent = item.examType + " ";
    const star = document.createElement("span");
    star.className = "star";
    star.textContent = "*";
    label.appendChild(star);

    // Create input
    const input = document.createElement("input");
    input.type = "number";
    input.className = "form-control tAC";
    input.id = `modal_${item.examType}`;
    input.placeholder = `${item.examType} Marks`;
    input.setAttribute("onchange", "getStatus(this.id)");

    // Append elements
    formGroup.appendChild(label);
    formGroup.appendChild(input);
    col.appendChild(formGroup);
    inputRow.appendChild(col);
  });

  // Reset modal status fields
  document.getElementById("modalInternalExamStatus").value = "";
  document.getElementById("modalSemExamStatus").value = "";
  document.getElementById("modaOverallStatus").value = "";

  // Show modal
  $("#modalEditResult").modal("show");
}




function calculateStatus(rowIndex) {
  let total = 0;
  let passed = true;

  subjectScoreStructure.forEach((item) => {
    const input = document.getElementById(`${item.examType}_${rowIndex}`);
    const value = parseFloat(input.value);
    const passMark = parseFloat(item.examPassingMarks);

    if (!isNaN(value)) {
      total += value;
      if (value < passMark) passed = false;
    } else {
      passed = false;
    }
  });

  // Update total marks
  const totalElement = document.getElementById(`total_${rowIndex}`);
  totalElement.textContent = total;

  // Update status cell text and classes directly (no span)
  const statusElement = document.getElementById(`status_${rowIndex}`);
  statusElement.textContent = passed ? "PASS" : "FAIL";

  // Remove previous badge classes if any
  statusElement.classList.remove("badge-success", "badge-danger");
  // Add class for styling whole cell
  statusElement.classList.add(passed ? "badge-success" : "badge-danger");
}


function showError(id, color, message) {
  if (id) document.getElementById(id).style.backgroundColor = color;
  document.getElementById("errorMessage").innerText = message;
}
