<?php
session_start();
if (!isset($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

require_once '../../common/connectToDB.php';

$data = json_decode(file_get_contents("php://input"), true);
if (!$data || !is_array($data)) {
    echo json_encode(['success' => false, 'message' => 'Invalid data.']);
    exit;
}

foreach ($data as $entry) {
    $studentId = $entry['studentId'];
    $scores = $entry['scores'];
    $status = $entry['status'];
    $examScoreMasterId = $entry['examScoreMasterId'];

    foreach ($scores as $examType => $examScore) {
        $examScore = floatval($examScore);

        // Check if record exists
        $checkSql = "SELECT examScoreMasterId FROM examinationscore WHERE studentId = ? AND examType = ? AND examScoreMasterId = ?";
        $stmt = $conn->prepare($checkSql);
        $stmt->bind_param("sss", $studentId, $examType, $examScoreMasterId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            // Update
            $updateSql = "UPDATE examinationscore SET examScore = ?, internalExamStatus = ? WHERE studentId = ? AND examType = ? AND examScoreMasterId = ?";
            $updateStmt = $conn->prepare($updateSql);
            $updateStmt->bind_param("dssss", $examScore, $status, $studentId, $examType, $examScoreMasterId);
            $updateStmt->execute();
        } else {
            // Insert
            $insertSql = "INSERT INTO examinationscore (studentId, examScore, examType, internalExamStatus, examScoreMasterId)
                          VALUES (?, ?, ?, ?, ?)";
            $insertStmt = $conn->prepare($insertSql);
            $insertStmt->bind_param("sdsss", $studentId, $examScore, $examType, $status, $examScoreMasterId);
            $insertStmt->execute();
        }
    }
}

echo json_encode(['success' => true]);
?>
