<?php
session_start();
if (!isset($_SESSION['academicExecutiveLoginsuccessEdj']) || $_SESSION['academicExecutiveLoginsuccessEdj'] <= 0) {
    header('Location:../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';

$examScoreMasterList = [];
$subjectScoreStructure = [];
$studentScoreMap = [];
$studentListFromLoginstudents = [];

if (isset($_GET['esmi'])) {
    $examScoreMasterId = base64_decode($_GET['esmi']);

    $sqlMaster = "SELECT * FROM examinationscoremaster WHERE examScoreMasterId = '$examScoreMasterId'";
    $resultMaster = $conn->query($sqlMaster);
    $scoreMasterRow = $resultMaster->fetch_assoc();

    if ($scoreMasterRow) {
        $examScoreMasterList[] = $scoreMasterRow;

        $subjectId = $scoreMasterRow['subjectId'];

        $sqlStructure = "SELECT * FROM subjectscore WHERE subjectId = '$subjectId'  AND deleted_at IS NULL";
        $resultStructure = $conn->query($sqlStructure);
        while ($row = $resultStructure->fetch_assoc()) {
            $subjectScoreStructure[] = $row;
        }

        $studentIds = [];
        $sqlStudentIds = "SELECT DISTINCT studentId FROM examinationscore WHERE examScoreMasterId = '$examScoreMasterId'";
        $resIds = $conn->query($sqlStudentIds);
        while ($row = $resIds->fetch_assoc()) {
            $studentIds[] = "'" . $row['studentId'] . "'";
        }

        if (!empty($studentIds)) {
            $studentIdList = implode(',', $studentIds);
            $sqlStudents = "SELECT studentId, rollNo, firstname, lastname FROM loginstudents WHERE studentId IN ($studentIdList)";
            $resStudents = $conn->query($sqlStudents);
            $studentDetails = [];
            while ($row = $resStudents->fetch_assoc()) {
                $studentDetails[$row['studentId']] = [
                    'rollNo' => $row['rollNo'],
                    'firstname' => $row['firstname'],
                    'lastname' => $row['lastname'],
                    'studentName' => $row['firstname'] . ' ' . $row['lastname']
                ];
                $studentListFromLoginstudents[] = [
                    'studentId' => $row['studentId'],
                    'rollNo' => $row['rollNo'],
                    'firstname' => $row['firstname'],
                    'lastname' => $row['lastname']
                ];
            }
        }

        $sqlScores = "SELECT * FROM examinationscore WHERE examScoreMasterId = '$examScoreMasterId' ORDER BY studentId";
        $resultScores = $conn->query($sqlScores);
        while ($row = $resultScores->fetch_assoc()) {
            $studentId = $row['studentId'];
            $studentScoreMap[$studentId]['rollNo'] = $studentDetails[$studentId]['rollNo'] ?? '';
            $studentScoreMap[$studentId]['studentName'] = $studentDetails[$studentId]['studentName'] ?? '';
            $studentScoreMap[$studentId]['scores'][$row['examType']] = $row['examScore'];
            $studentScoreMap[$studentId]['status'] = $row['internalExamStatus'] ?? '';
        }
    }
}

require '../../common/header.php';
require '../../common/navbar.php';
?> <div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-3">
                                    <label>Result ID</label>
                                    <input type="text" class="form-control tAC"
                                        value="<?= $examScoreMasterList[0]['examScoreMasterId'] ?? '' ?>" disabled>
                                </div>
                                <div class="col-md-3">
                                    <label>Academic Year</label>
                                    <input type="text" class="form-control tAC"
                                        value="<?= $examScoreMasterList[0]['academicYear'] ?? '' ?>" disabled>
                                </div>
                                <div class="col-md-3">
                                    <label>Batch</label>
                                    <input type="text" class="form-control tAC"
                                        value="<?= $examScoreMasterList[0]['batchName'] ?? '' ?>" disabled>
                                </div>
                                <div class="col-md-3">
                                    <label>Semester</label>
                                    <input type="text" class="form-control tAC"
                                        value="<?= 'SEMESTER-' . ($examScoreMasterList[0]['semester'] ?? '') ?>"
                                        disabled>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <label>Subject</label>
                                    <input type="text" class="form-control tAC"
                                        value="<?= $examScoreMasterList[0]['subjectName'] ?? '' ?>" disabled>
                                </div>
                                <div class="col-md-3">
                                    <label>Result Status</label>
                                    <div class="form-control" style="pointer-events: none; background-color: #e9ecef;">
                                        <?= $examScoreMasterList[0]['resultStatus'] ?? 'COMPLETED' ?> </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="scoreTable">
                                <thead id="scoreTableHeader">
                                    <tr>
                                        <th>Roll No</th>
                                        <th>Student Name</th> <?php foreach ($subjectScoreStructure as $exam): ?> <th>
                                            <?= $exam['examType'] ?><br>(Out of <?= $exam['examTotalMarks'] ?>)</th>
                                        <?php endforeach; ?> <th>Total Marks</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody id="scoreTableBody"> <?php foreach ($studentScoreMap as $studentId => $info): ?>
                                    <tr>
                                        <td><?= $info['rollNo'] ?></td>
                                        <td><?= $info['studentName'] ?></td> <?php
                                        $totalMarks = 0;
                                        $passed = true;
                                        foreach ($subjectScoreStructure as $exam):
                                            $examType = $exam['examType'];
                                            $maxMarks = $exam['examTotalMarks'];
                                            $passMarks = $exam['examPassingMarks'];
                                            $score = $info['scores'][$examType] ?? '';
                                            $totalMarks += (float)$score;
                                            if ($score < $passMarks) $passed = false;
                                        ?> <td>
                                            <input type="number" class="form-control tAC"
                                                id="score_<?= $studentId ?>_<?= $examType ?>"
                                                value="<?= htmlspecialchars($score) ?>" min="0" max="<?= $maxMarks ?>"
                                                oninput="calculateInlineStatus('<?= $studentId ?>')">
                                        </td> <?php endforeach; ?> <td id="total_<?= $studentId ?>"><?= $totalMarks ?>
                                        </td>
                                        <td id="status_<?= $studentId ?>"> <?= $passed
                                            ? "<span class='badge badge-success'>PASS</span>"
                                            : "<span class='badge badge-danger'>FAIL</span>" ?> </td>
                                    </tr> <?php endforeach; ?> </tbody>
                            </table>
                        </div>
                        <div class="modal-footer tAC">
                            <div class="col-md-12">
                                <p class="fS22" id="modalErrorMessage" style="color:red;"></p>
                                <p id="modelsuccessMessage" style="color:green;"></p>
                                <p id='errorMessage' class="text-danger text-center"></p>
                                <p id='successMessage' class="text-success text-center"></p>
                                <button type="button" id="saveBtn" onclick="saveScore()"
                                    class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<!-- JS variables come first -->
<script>
const subjectName = "<?= addslashes($examScoreMasterList[0]['subjectName'] ?? '') ?>";
const subjectScoreStructure = <?= json_encode($subjectScoreStructure) ?>;
const studentList = <?= json_encode($studentListFromLoginstudents) ?>;
const examScoreMasterId = "<?= $examScoreMasterList[0]['examScoreMasterId'] ?>";
</script>
<!-- Load JS once -->
<script src="edit.js"></script>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<!-- <script>
$(document).ready(function () {
    renderStudentRows(studentList);
});

</script> --> <?php require '../../common/footer.php'; ?>