// addScore.js

// // const studentScoreDetails = [];
// const scoreMasterData = [];

function addTableHeader() {
  const thead = document.getElementById("scoreTableHeader");
  thead.innerHTML = ''; // Clear any existing headers

  const headerRow = document.createElement("tr");

  // Roll No header
  const rollNoTh = document.createElement("th");
  rollNoTh.textContent = "Roll No";
  headerRow.appendChild(rollNoTh);

  // Student Name header
  const nameTh = document.createElement("th");
  nameTh.textContent = "Student Name";
  headerRow.appendChild(nameTh);

  // Dynamic exam type headers
  subjectScoreStructure.forEach((item) => {
    const th = document.createElement("th");
    th.innerHTML = `${item.examType}<br><small>(Out of ${item.examTotalMarks})</small>`;
    headerRow.appendChild(th);
  });

  // Total Marks header
  const totalTh = document.createElement("th");
  totalTh.textContent = "Total Marks";
  headerRow.appendChild(totalTh);

  // Status header
  const statusTh = document.createElement("th");
  statusTh.textContent = "Status";
  headerRow.appendChild(statusTh);

  // Append the full header row
  thead.appendChild(headerRow);
}

function renderStudentRows(studentList) {
  const tbody = document.getElementById("scoreTableBody");
  tbody.innerHTML = ""; // Clear previous rows

  studentList.forEach((student, idx) => {
    const row = document.createElement("tr");

    // Roll No cell
    const rollTd = document.createElement("td");
    rollTd.textContent = student.rollNo;
    row.appendChild(rollTd);

    // Student Name cell
    const nameTd = document.createElement("td");
    nameTd.id = student.studentId;
    nameTd.textContent = `${student.firstname} ${student.lastname}`;
    row.appendChild(nameTd);

    // Dynamic exam input fields
    subjectScoreStructure.forEach((item) => {
      const scoreTd = document.createElement("td");

      const input = document.createElement("input");
      input.type = "number";
      input.className = "form-control tAC";
      input.id = `${item.examType}_${idx}`;
      input.placeholder = `Enter ${item.examType}`;
      input.max = item.examTotalMarks;
      input.min = 0;
      input.oninput = function () {
        calculateStatus(idx);
      };

      scoreTd.appendChild(input);
      row.appendChild(scoreTd);
    });

    // Total Marks cell
    const totalTd = document.createElement("td");
    totalTd.id = `total_${idx}`;
    totalTd.textContent = "0";
    row.appendChild(totalTd);

    // Status cell
    const statusTd = document.createElement("td");
    statusTd.id = `status_${idx}`;

    const badge = document.createElement("span");
    badge.className = "badge badge-primary";
    badge.textContent = "N/A";
    statusTd.appendChild(badge);
    row.appendChild(statusTd);

    // Append row to table body
    tbody.appendChild(row);
  });
}


function calculateStatus(rowIndex) {
  let total = 0;
  let passed = true;

  subjectScoreStructure.forEach((item) => {
    const input = document.getElementById(`${item.examType}_${rowIndex}`);
    const value = parseFloat(input.value);
    const passMark = parseFloat(item.examPassingMarks);

    if (!isNaN(value)) {
      total += value;
      if (value < passMark) passed = false;
    } else {
      passed = false;
    }
  });

  // Update total marks
  const totalElement = document.getElementById(`total_${rowIndex}`);
  totalElement.textContent = total;

  // Update status
  const statusElement = document.getElementById(`status_${rowIndex}`);
  statusElement.innerHTML = ""; // Clear any existing children

  const badge = document.createElement("span");
  badge.className = passed ? "badge badge-success" : "badge badge-danger";
  badge.textContent = passed ? "PASS" : "FAIL";

  statusElement.appendChild(badge);
}


function showError(id, color, message) {
  if (id) document.getElementById(id).style.backgroundColor = color;
  document.getElementById("errorMessage").innerText = message;
  document.getElementById("successMessage").innerText = "";
}


function saveScore() {
  const saveBtn = document.getElementById("saveBtn");
  const errorBox = document.getElementById("errorMessage");
  const successBox = document.getElementById("successMessage");
  if (saveBtn) saveBtn.disabled = true;
  errorBox.innerText = ""; // clear previous errors
  successBox.innerText = "";
  // Check if no examType is defined
  if (!subjectScoreStructure || subjectScoreStructure.length === 0) {
    showError(null, null, "No exam type defined for this subject.");
    if (saveBtn) saveBtn.disabled = false;
    return;
  }
  studentScoreDetails = [];
  const rows = document.querySelectorAll("#scoreTableBody tr");
  let hasInvalidScore = false;
  let partialEntryFound = false;
  rows.forEach((row, index) => {
    const tds = row.querySelectorAll("td");
    const scores = {};
    let total = 0;
    let failed = false;
    let filledCount = 0;
    subjectScoreStructure.forEach((item) => {
      const input = document.getElementById(`${item.examType}_${index}`);
      const val = input.value.trim();
      let score = 0;
      if (val !== "") {
        score = parseFloat(val);
        filledCount++;
        if (
          isNaN(score) ||
          score < 0 ||
          score > parseFloat(item.examTotalMarks)
        ) {
          input.style.border = "2px solid red";
          hasInvalidScore = true;
          return;
        } else {
          input.style.border = "";
        }
      }
      scores[item.examType] = isNaN(score) ? 0 : score;
      total += score;
      if (score < parseFloat(item.examPassingMarks)) {
        failed = true;
      }
    });
    if (filledCount > 0 && filledCount < subjectScoreStructure.length) {
      partialEntryFound = true;
      row.style.backgroundColor = "#FFE6E6"; // mark error
    } else {
      row.style.backgroundColor = ""; // clear background
    }
    const fullName = tds[1].innerText.trim();
    const nameParts = fullName.split(" ");
    const firstName = nameParts[0];
    const lastName = nameParts.slice(1).join(" ");
    studentScoreDetails.push({
      rollNo: tds[0].innerText.trim(),
      studentId: tds[1].id,
      studentFirstName: firstName,
      studentLastName: lastName,
      scores: scores,
      total: total,
      status: failed ? "FAIL" : "PASS",
    });
  });
  // Handle validation failures
  if (hasInvalidScore) {
    showError(
      null,
      null,
      "Some scores are invalid (negative or exceed maximum)."
    );
    if (saveBtn) saveBtn.disabled = false;
    return;
  }
  if (partialEntryFound) {
    showError(null, null, "Incomplete Data");
    if (saveBtn) saveBtn.disabled = false;
    return;
  }
  // All validation passed
  const resultStatusDropdown = document.getElementById("resultStatus");
  if (resultStatusDropdown) resultStatusDropdown.value = "COMPLETED";
  scoreMasterData = [
    {
      academicYear: document.getElementById("academicYear")?.value || "",
      batchId: batchId || "",
      batchName: document.getElementById("batchName")?.value || "",
      semester: document.getElementById("semester")?.value || "",
      subjectId: subjectId || "",
      subjectName: document.getElementById("subjetName")?.value || "",
      masterScoreId: document.getElementById("examScoreMasterId")?.value || "",
      resultStatus: "COMPLETED",
    },
  ];
  if (confirm("Are you sure you want to save the scores?")) {
    $.post(
      "saveScore.php",
      {
        saveFlag: "addScore",
        studentScoreDetails: studentScoreDetails,
        scoreMasterData: scoreMasterData,
        subjectScoreStructure: subjectScoreStructure,
      },
      function (data) {
        successBox.innerText = "Scores saved successfully.";
        console.log(data,'sats')
        errorBox.innerText = "";
        // Save button remains disabled to prevent duplicate
      }
    ).fail(() => {
      showError(null, null, "Failed to save scores. Please try again.");
      if (saveBtn) saveBtn.disabled = false;
    });
  } else {
    if (saveBtn) saveBtn.disabled = false;
  }
}






