var modalScoreId = '',
    modalCE1Marks = '',
    modalCE2Marks = '',
    modalAttendanceMarks = '',
    modalSemExamMarks = '',
    modalStudentName = '',
    modalSubjectName = '',
    modalInternalExamStatus = '',
    modalSemExamStatus = '',
    modalOverallStatus = '',
    flagForStatement = 0,
    statement = '';

const subjectScoreDetails = {
    CE1TotalMarks: "",
    CE1PassingMarks: "",
    CE2TotalMarks: "",
    CE2PassingMarks: "",
    attendanceTotalMarks: "",
    attendancePassingMarks: "",
    semExamTotalMarks: "",
    semExamPassingMarks: "",
    internalExamPassingMarks: 0
}

const oldScoreDetails = {
    oldCE1marks: "",
    oldCE2marks: "",
    oldAttendanceMarks: "",
    oldSemExamMarks: "",
    oldInternalExamStatus: "",
    oldSemesterExamStatus: "",
    oldOverallStatus: ""
}

const newScoreDetails = {
    CE1marksObtained: "",
    CE2marksObtained: "",
    attendanceMarksObtained: "",
    semExamMarksObtained: "",
    internalExamStatus: "",
    semesterExamStatus: "",
    overallStatus: ""
}

function getSubjectScoreDetails() {
    var tempExamTypeList = subjectDetails[0]['examType'].split("::");
    var tempExamTotalMarksList = subjectDetails[0]['examTotalMarks'].split("::");
    var tempExamPassingMarksList = subjectDetails[0]['examPassingMarks'].split("::");
    var tempInternalExamPassingMarks = 0;

    for (i = 0; i < tempExamTypeList.length; i++) {
        if (tempExamTypeList[i].trim().toUpperCase() == 'CE-1') {
            subjectScoreDetails.CE1TotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.CE1PassingMarks = parseInt(tempExamPassingMarksList[i].trim());
            tempInternalExamPassingMarks = parseInt(tempInternalExamPassingMarks) + subjectScoreDetails.CE1PassingMarks;
        } else if (tempExamTypeList[i].trim().toUpperCase() == 'CE-2') {
            subjectScoreDetails.CE2TotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.CE2PassingMarks = parseInt(tempExamPassingMarksList[i].trim());
            tempInternalExamPassingMarks = parseInt(tempInternalExamPassingMarks) + subjectScoreDetails.CE2PassingMarks;
        } else if (tempExamTypeList[i].trim().toUpperCase() == 'ATTENDANCE MARKS') {
            subjectScoreDetails.attendanceTotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.attendancePassingMarks = parseInt(tempExamPassingMarksList[i].trim());
            tempInternalExamPassingMarks = tempInternalExamPassingMarks + subjectScoreDetails.attendancePassingMarks;
        } else if (tempExamTypeList[i].trim().toUpperCase() == 'SEMESTER EXAM') {
            subjectScoreDetails.semExamTotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.semExamPassingMarks = parseInt(tempExamPassingMarksList[i].trim());
        }
    }
    subjectScoreDetails.internalExamPassingMarks = parseInt(tempInternalExamPassingMarks);
}

function addTableHeader() {
    var mytableHeader = document.getElementById("scoreTableHeader"),
        newRow,
        newCell;

    var newRow = document.createElement("tr");
    mytableHeader.appendChild(newRow);

    // 6%+22%+11%+11%+13%+13%+6%+6%+6%+10%
    // roll no cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'ROLL NO';
    newCell.setAttribute("width", "6%");
    newRow.appendChild(newCell);

    // student Name name cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'STUDENT NAME';
    newCell.setAttribute("width", '22%');
    newRow.appendChild(newCell);

    // CE1 cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'CE1' + ' (OUT OF ' + subjectScoreDetails.CE1TotalMarks + ' )';
    newCell.setAttribute("width", '11%');
    newRow.appendChild(newCell);

    // CE2 cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'CE2' + ' (OUT OF ' + subjectScoreDetails.CE2TotalMarks + ' )';
    newCell.setAttribute("width", '11%');
    newRow.appendChild(newCell);

    // Attendance marks cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'ATTENDANCE MARKS' + ' (OUT OF ' + subjectScoreDetails.attendanceTotalMarks + ' )';
    newCell.setAttribute("width", '13%');
    newRow.appendChild(newCell);

    // Sem exam marks cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'SEMESTER EXAM MARKS' + ' (OUT OF ' + subjectScoreDetails.semExamTotalMarks + ' )';
    newCell.setAttribute("width", '13%');
    newRow.appendChild(newCell);

    // Internal exam Status
    newCell = document.createElement("th");
    newCell.innerHTML = 'INTERNAL EXAM STATUS';
    newCell.setAttribute("width", '6%');
    newRow.appendChild(newCell);

    // Semester exam Status
    newCell = document.createElement("th");
    newCell.innerHTML = 'SEMESTER EXAM STATUS';
    newCell.setAttribute("width", '6%');
    newRow.appendChild(newCell);

    // Overall Status
    newCell = document.createElement("th");
    newCell.innerHTML = 'OVERALL STATUS';
    newCell.setAttribute("width", '6%');
    newRow.appendChild(newCell);

    // Action
    newCell = document.createElement("th");
    newCell.innerHTML = 'ACTION';
    newCell.setAttribute("width", '10%');
    newRow.appendChild(newCell);

}

function generateList() {
    document.getElementById('generateSuccessMessage').innerHTML = 'Please Wait while we generate List';
    $.post('viewScoreDetails.php', {
        'examScoreMasterId': examScoreMasterId,
        'subjectScoreDetails': subjectScoreDetails,
    }, function (data) {
        $('#detailsTable').html(data);
        addTableHeader();
        document.getElementById('generateSuccessMessage').innerHTML = '';
    });
}

function resetModal() {
    document.getElementById('modalCE1Marks').value = '';
    document.getElementById('modalCE2Marks').value = '';
    document.getElementById('modalAttendanceMarks').value = '';
    document.getElementById('modalSemExamMarks').value = '';
    document.getElementById('modalStudentName').value = '';
    document.getElementById('modalSubjectName').value = '';

    document.getElementById('modalErrorMessage').innerHTML = '';
    document.getElementById('modelsuccessMessage').innerHTML = '';
    document.getElementById('editButton').disabled = false;
}

function addDataToModal(scoreId) {
    resetModal();
    modalScoreId = '';
    for (i = 0; i < obtainedScoreDetails.length; i++) {
        if (obtainedScoreDetails[i]['examScoreRowId'] == scoreId) {
            document.getElementById('modalCE1Marks').value = obtainedScoreDetails[i]['CE1marks'];
            document.getElementById('modalCE2Marks').value = obtainedScoreDetails[i]['CE2marks'];
            document.getElementById('modalAttendanceMarks').value = obtainedScoreDetails[i]['attendanceMarks'];
            document.getElementById('modalSemExamMarks').value = obtainedScoreDetails[i]['semesterExamMarks'];
            document.getElementById('modalStudentName').value = obtainedScoreDetails[i]['studentFirstName'] + ' ' + obtainedScoreDetails[i]['studentLastName'];
            document.getElementById('modalSubjectName').value = obtainedScoreDetails[i]['subjectName'];
            document.getElementById('modalInternalExamStatus').value = obtainedScoreDetails[i]['internalExamStatus'];
            document.getElementById('modalSemExamStatus').value = obtainedScoreDetails[i]['semesterExamStatus'];
            document.getElementById('modaOverallStatus').value = obtainedScoreDetails[i]['overallStatus'];

            if (obtainedScoreDetails[i]['internalExamStatus'].trim() == 'FAIL') {
                document.getElementById('modalInternalExamStatus').style.color = '#700e0e';
            } else if (obtainedScoreDetails[i]['internalExamStatus'].trim() == 'PASS') {
                document.getElementById('modalInternalExamStatus').style.color = '#3ce94a';
            }

            if (obtainedScoreDetails[i]['semesterExamStatus'].trim() == 'FAIL') {
                document.getElementById('modalSemExamStatus').style.color = '#700e0e';
            } else if (obtainedScoreDetails[i]['semesterExamStatus'].trim() == 'PASS') {
                document.getElementById('modalSemExamStatus').style.color = '#3ce94a';
            }

            if (obtainedScoreDetails[i]['overallStatus'].trim() == 'FAIL') {
                document.getElementById('modaOverallStatus').style.color = '#700e0e';
            } else if (obtainedScoreDetails[i]['overallStatus'].trim() == 'PASS') {
                document.getElementById('modaOverallStatus').style.color = '#3ce94a';
            }
            modalScoreId = obtainedScoreDetails[i]['examScoreRowId'];

            oldScoreDetails.oldCE1marks = obtainedScoreDetails[i]['CE1marks'];
            oldScoreDetails.oldCE2marks = obtainedScoreDetails[i]['CE2marks'];
            oldScoreDetails.oldAttendanceMarks = obtainedScoreDetails[i]['attendanceMarks'];
            oldScoreDetails.oldSemExamMarks = obtainedScoreDetails[i]['semesterExamMarks'];
            oldScoreDetails.oldInternalExamStatus = obtainedScoreDetails[i]['internalExamStatus'];
            oldScoreDetails.oldSemesterExamStatus = obtainedScoreDetails[i]['semesterExamStatus'];
            oldScoreDetails.oldOverallStatus = obtainedScoreDetails[i]['overallStatus'];
        }
    }
}

function showModalError(id, color, message) {
    if (id != '') document.getElementById(id).style.backgroundColor = color;
    document.getElementById('modalErrorMessage').innerHTML = message;
}

function checkNegative(scoreId) {
    if (parseInt(document.getElementById(scoreId).value) < 0) {
        showModalError(scoreId, '#ff6666', "Marks can't be negative");
        return 0;
    } else showModalError(scoreId, '', '');
    return 1;
}

function checkScoreLimit() {
    if (parseInt(document.getElementById('modalCE1Marks').value) > subjectScoreDetails.CE1TotalMarks) {
        showModalError('modalCE1Marks', '#ff6666', "CE-1 marks can't be greater than " + subjectScoreDetails.CE1TotalMarks);
        return 0;
    } else showModalError('modalCE1Marks', '', '');

    if (parseInt(document.getElementById('modalCE2Marks').value) > subjectScoreDetails.CE2TotalMarks) {
        showModalError('modalCE2Marks', '#ff6666', "CE-1 marks can't be greater than " + subjectScoreDetails.CE2TotalMarks);
        return 0;
    } else showModalError('modalCE2Marks', '', '');

    if (parseInt(document.getElementById('modalAttendanceMarks').value) > subjectScoreDetails.attendanceTotalMarks) {
        showModalError('modalAttendanceMarks', '#ff6666', "CE-1 marks can't be greater than " + subjectScoreDetails.attendanceTotalMarks);
        return 0;
    } else showModalError('modalAttendanceMarks', '', '');

    if (parseInt(document.getElementById('modalSemExamMarks').value) > subjectScoreDetails.semExamTotalMarks) {
        showModalError('modalSemExamMarks', '#ff6666', "CE-1 marks can't be greater than " + subjectScoreDetails.semExamTotalMarks);
        return 0;
    } else showModalError('modalSemExamMarks', '', '');
    return 1;
}

function calculateInternalExamStatus() {
    var tempCE1Score = '';
    var tempCE2Score = '';
    var tempAttendanceScore = '';

    tempCE1Score = parseInt(document.getElementById("modalCE1Marks").value);
    tempCE2Score = parseInt(document.getElementById("modalCE2Marks").value);
    tempAttendanceScore = parseInt(document.getElementById("modalAttendanceMarks").value);

    if (isNaN(tempCE1Score) && isNaN(tempCE2Score) && isNaN(tempAttendanceScore)) {
        document.getElementById("modalInternalExamStatus").value = '';
        document.getElementById("modalInternalExamStatus").style.color = "";
        return;
    }

    else {
        if (isNaN(tempCE1Score)) tempCE1Score = 0;
        if (isNaN(tempCE2Score)) tempCE2Score = 0;
        if (isNaN(tempAttendanceScore)) tempAttendanceScore = 0;

        if ((tempCE1Score + tempCE2Score + tempAttendanceScore) >= 0) {
            if ((tempCE1Score + tempCE2Score + tempAttendanceScore) < subjectScoreDetails.internalExamPassingMarks) {
                document.getElementById("modalInternalExamStatus").value = 'FAIL';
                document.getElementById("modalInternalExamStatus").style.color = "#700e0e";
            } else if ((tempCE1Score + tempCE2Score + tempAttendanceScore) >= subjectScoreDetails.internalExamPassingMarks) {
                document.getElementById("modalInternalExamStatus").value = 'PASS';
                document.getElementById("modalInternalExamStatus").style.color = "#3ce94a";
            }
        }
    }
}

function calculateSemExamResultStatus() {
    var temSemExamScore = parseInt(document.getElementById("modalSemExamMarks").value);
    if (isNaN(temSemExamScore)) {
        document.getElementById("modalSemExamStatus").value = '';
        document.getElementById("modalSemExamStatus").style.color = "";
        return;
    }
    if (temSemExamScore >= 0) {
        if (temSemExamScore < subjectScoreDetails.semExamPassingMarks) {
            document.getElementById("modalSemExamStatus").value = 'FAIL';
            document.getElementById("modalSemExamStatus").style.color = "#700e0e";
        } else if (temSemExamScore >= subjectScoreDetails.semExamPassingMarks) {
            document.getElementById("modalSemExamStatus").value = 'PASS';
            document.getElementById("modalSemExamStatus").style.color = "#3ce94a";
        }
    }
}

function calculateOverallResultStatus() {
    var tempInternalExamStatus = document.getElementById("modalInternalExamStatus").value;
    var tempSemExamStatus = document.getElementById("modalSemExamStatus").value;
    if (tempInternalExamStatus != '' || tempSemExamStatus != '') {
        if (tempInternalExamStatus.trim() == '') tempInternalExamStatus = 'FAIL';
        if (tempSemExamStatus.trim() == '') {
            tempSemExamStatus = 'FAIL';
        }

        if (tempInternalExamStatus == 'FAIL' && tempSemExamStatus == 'FAIL') {
            document.getElementById("modaOverallStatus").value = 'FAIL';
            document.getElementById("modaOverallStatus").style.color = "#700e0e";
        }
        if (tempInternalExamStatus == 'FAIL' && tempSemExamStatus == 'PASS') {
            document.getElementById("modaOverallStatus").value = 'FAIL';
            document.getElementById("modaOverallStatus").style.color = "#700e0e";
        }
        if (tempInternalExamStatus == 'PASS' && tempSemExamStatus == 'FAIL') {
            document.getElementById("modaOverallStatus").value = 'FAIL';
            document.getElementById("modaOverallStatus").style.color = "#700e0e";
        }
        if (tempInternalExamStatus == 'PASS' && tempSemExamStatus == 'PASS') {
            document.getElementById("modaOverallStatus").value = 'PASS';
            document.getElementById("modaOverallStatus").style.color = "#3ce94a";
        }
    } else {
        document.getElementById("modaOverallStatus").value = '';
        document.getElementById("modaOverallStatus").style.color = "";
    }
}

function getStatus(id) {
    if (checkNegative(id) == 0) return;
    if (checkScoreLimit() == 0) return;
    calculateInternalExamStatus();
    calculateSemExamResultStatus();
    calculateOverallResultStatus();
}

function setHeaders() {
    modalCE1Marks = '';
    modalCE2Marks = '';
    modalAttendanceMarks = '';
    modalSemExamMarks = '';
    modalStudentName = '';
    modalSubjectName = '';
    modalInternalExamStatus = '';
    modalSemExamStatus = '';
    modalOverallStatus = '';

    modalCE1Marks = document.getElementById('modalCE1Marks').value.trim();
    modalCE2Marks = document.getElementById('modalCE2Marks').value.trim();
    modalAttendanceMarks = document.getElementById('modalAttendanceMarks').value.trim();
    modalSemExamMarks = document.getElementById('modalSemExamMarks').value.trim();
    modalStudentName = document.getElementById('modalStudentName').value.trim();
    modalSubjectName = document.getElementById('modalSubjectName').value.trim();
    modalInternalExamStatus = document.getElementById('modalInternalExamStatus').value.trim();
    modalSemExamStatus = document.getElementById('modalSemExamStatus').value.trim();
    modalOverallStatus = document.getElementById('modaOverallStatus').value.trim();
    return 1;
}

function modalValidation() {
    // CE1 score validation
    if (parseInt(modalCE1Marks) < 0) {
        showModalError('modalCE1Marks', "#ffc2b3", "Marks can not be negative.");
        return 0;
    } else showModalError('modalCE1Marks', '', '');

    if (parseInt(modalCE1Marks) > subjectScoreDetails.CE1TotalMarks) {
        showModalError('modalCE1Marks', "#ffc2b3", "CE1 marks can not be greater than " + subjectScoreDetails.CE1TotalMarks);
        return 0;
    } else showModalError('modalCE1Marks', '', '');

    // CE2 score validation
    if (parseInt(modalCE2Marks) < 0) {
        showModalError('modalCE2Marks', "#ffc2b3", "Marks can not be negative.");
        return 0;
    } else showModalError('modalCE2Marks', '', '');

    if (parseInt(modalCE2Marks) > subjectScoreDetails.CE2TotalMarks) {
        showModalError('modalCE2Marks', "#ffc2b3", "CE2 marks can not be greater than " + subjectScoreDetails.CE2TotalMarks);
        return 0;
    } else showModalError('modalCE2Marks', '', '');

    // Attendance score validation
    if (parseInt(modalAttendanceMarks) < 0) {
        showModalError('modalAttendanceMarks', "#ffc2b3", "Marks can not be negative.");
        return 0;
    } else showModalError('modalAttendanceMarks', '', '');

    if (parseInt(modalAttendanceMarks) > subjectScoreDetails.attendanceTotalMarks) {
        showModalError('modalAttendanceMarks', "#ffc2b3", "Attendance marks can not be greater than " + subjectScoreDetails.attendanceTotalMarks);
        return 0;
    } else showModalError('modalAttendanceMarks', '', '');

    // Semester exam score validation
    if (parseInt(modalSemExamMarks) < 0) {
        showModalError('modalSemExamMarks', "#ffc2b3", "Marks can not be negative.");
        return 0;
    } else showModalError('modalSemExamMarks', '', '');

    if (parseInt(modalSemExamMarks) > subjectScoreDetails.semExamTotalMarks) {
        showModalError('modalSemExamMarks', "#ffc2b3", "Semester exam marks can not be greater than " + subjectScoreDetails.semExamTotalMarks);
        return 0;
    } else showModalError('modalSemExamMarks', '', '');

    return 1;
}

function addValuesToObject() {
    if (isNaN(modalCE1Marks)) modalCE1Marks = '';
    if (isNaN(modalCE2Marks)) modalCE2Marks = '';
    if (isNaN(modalAttendanceMarks)) modalAttendanceMarks = '';
    if (isNaN(modalSemExamMarks)) modalSemExamMarks = '';

    newScoreDetails.CE1marksObtained = modalCE1Marks;
    newScoreDetails.CE2marksObtained = modalCE2Marks;
    newScoreDetails.attendanceMarksObtained = modalAttendanceMarks;
    newScoreDetails.semExamMarksObtained = modalSemExamMarks;
    newScoreDetails.internalExamStatus = modalInternalExamStatus;
    newScoreDetails.semesterExamStatus = modalSemExamStatus;
    newScoreDetails.overallStatus = modalOverallStatus;
}

function compareNewValuesWithOld() {
    statement = "UPDATE done in Result of student (" + modalStudentName + ") of subject (" + modalSubjectName + ") Score Id (" + modalScoreId + "). <br>";
    var flagForStatement = 0;

    if (oldScoreDetails.oldCE1marks != newScoreDetails.CE1marksObtained) {
        flagForStatement = 1;
        statement = statement + "CE1 marks changed from " + oldScoreDetails.oldCE1marks + " to " + newScoreDetails.CE1marksObtained + "<br>";
    }
    if (oldScoreDetails.oldCE2marks != newScoreDetails.CE2marksObtained) {
        flagForStatement = 1;
        statement = statement + "CE2 marks changed from " + oldScoreDetails.oldCE2marks + " to " + newScoreDetails.CE2marksObtained + "<br>";
    }
    if (oldScoreDetails.oldAttendanceMarks != newScoreDetails.attendanceMarksObtained) {
        flagForStatement = 1;
        statement = statement + "Attendance marks changed from " + oldScoreDetails.oldAttendanceMarks + " to " + newScoreDetails.attendanceMarksObtained + "<br>";
    }
    if (oldScoreDetails.oldSemExamMarks != newScoreDetails.semExamMarksObtained) {
        flagForStatement = 1;
        statement = statement + "Semester exam marks changed from " + oldScoreDetails.oldSemExamMarks + " to " + newScoreDetails.semExamMarksObtained + "<br>";
    }
    if (oldScoreDetails.oldInternalExamStatus != newScoreDetails.internalExamStatus) {
        flagForStatement = 1;
        statement = statement + "Internal exam status changed from " + oldScoreDetails.oldInternalExamStatus + " to " + newScoreDetails.internalExamStatus + "<br>";
    }
    if (oldScoreDetails.oldSemesterExamStatus != newScoreDetails.semesterExamStatus) {
        flagForStatement = 1;
        statement = statement + "Semester exam status changed from " + oldScoreDetails.oldSemesterExamStatus + " to " + newScoreDetails.semesterExamStatus + "<br>";
    }
    if (oldScoreDetails.oldOverallStatus != newScoreDetails.overallStatus) {
        flagForStatement = 1;
        statement = statement + "Overall exam status changed from " + oldScoreDetails.oldOverallStatus + " to " + newScoreDetails.overallStatus + "<br>";
    }
    if (flagForStatement == 0) {
        showModalError('', '#ff6666', 'No Changes Done');
        return 0;
    }
    return 1;
}

function editResult() {
    var saveFlag = 'editScore';
    document.getElementById('editButton').disabled = true;
    if (setHeaders() == 0) {
        document.getElementById('editButton').disabled = false;
        return 0;
    }
    if (modalValidation() == 0) {
        document.getElementById('editButton').disabled = false;
        return 0;
    }
    if (addValuesToObject() == 0) {
        document.getElementById('editButton').disabled = false;
        return 0;
    }
    if (compareNewValuesWithOld() == 0) {
        document.getElementById('editButton').disabled = false;
        return;
    }
    document.getElementById('modalErrorMessage').innerHTML = '';
    document.getElementById('modelsuccessMessage').innerHTML = 'Saving Please wait.....';
    $.post('updateScore.php', {
        'saveFlag': saveFlag,
        'newScoreDetails': newScoreDetails,
        'scoreId': modalScoreId,
        'logStatement': statement
    },
        function (data) {
            document.getElementById('modelsuccessMessage').innerHTML = ' Marks successfully saved.';
            document.getElementById("closeModal").click();
            generateList();
        });
}