const subjectScoreDetails = {
    CE1TotalMarks: "",
    CE1PassingMarks: "",
    CE2TotalMarks: "",
    CE2PassingMarks: "",
    attendanceTotalMarks: "",
    attendancePassingMarks: "",
    semExamTotalMarks: "",
    semExamPassingMarks: "",
    internalExamPassingMarks: 0
}
var studentScoreDetails = [];
var scoreMasterData = [];
var semester = '',
    academicYear = '',
    batchName = '',
    subjectName = '',
    masterScoreId = '',
    resultStatus = '';

function getSubjectScoreDetails() {
    var tempExamTypeList = subjectDetails[0]['examType'].split("::");
    var tempExamTotalMarksList = subjectDetails[0]['examTotalMarks'].split("::");
    var tempExamPassingMarksList = subjectDetails[0]['examPassingMarks'].split("::");
    var tempInternalExamPassingMarks = 0;

    for (i = 0; i < tempExamTypeList.length; i++) {
        if (tempExamTypeList[i].trim().toUpperCase() == 'CE-1') {
            subjectScoreDetails.CE1TotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.CE1PassingMarks = parseInt(tempExamPassingMarksList[i].trim());
            tempInternalExamPassingMarks = parseInt(tempInternalExamPassingMarks) + subjectScoreDetails.CE1PassingMarks;
        } else if (tempExamTypeList[i].trim().toUpperCase() == 'CE-2') {
            subjectScoreDetails.CE2TotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.CE2PassingMarks = parseInt(tempExamPassingMarksList[i].trim());
            tempInternalExamPassingMarks = parseInt(tempInternalExamPassingMarks) + subjectScoreDetails.CE2PassingMarks;
        } else if (tempExamTypeList[i].trim().toUpperCase() == 'ATTENDANCE MARKS') {
            subjectScoreDetails.attendanceTotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.attendancePassingMarks = parseInt(tempExamPassingMarksList[i].trim());
            tempInternalExamPassingMarks = tempInternalExamPassingMarks + subjectScoreDetails.attendancePassingMarks;
        } else if (tempExamTypeList[i].trim().toUpperCase() == 'SEMESTER EXAM') {
            subjectScoreDetails.semExamTotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.semExamPassingMarks = parseInt(tempExamPassingMarksList[i].trim());
        }
    }
    subjectScoreDetails.internalExamPassingMarks = parseInt(tempInternalExamPassingMarks);
}

function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].text;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function addTableHeader() {
    var mytableHeader = document.getElementById("scoreTableHeader"),
        newRow,
        newCell;

    var newRow = document.createElement("tr");
    mytableHeader.appendChild(newRow);

    // 4%+6%+26%+13%+10%+10%+13%+6%+6%+6%
    // scoreId cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'SCORE ID';
    newCell.setAttribute("width", "4%");
    newCell.setAttribute("hidden", "hidden");
    newRow.appendChild(newCell);

    // roll no cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'ROLL NO';
    newCell.setAttribute("width", "6%");
    newRow.appendChild(newCell);

    // student Name name cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'STUDENT NAME';
    newCell.setAttribute("width", '26%');
    newRow.appendChild(newCell);

    // CE1 cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'CE1' + ' (OUT OF ' + subjectScoreDetails.CE1TotalMarks + ' )';
    newCell.setAttribute("width", '10%');
    newRow.appendChild(newCell);

    // CE2 cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'CE2' + ' (OUT OF ' + subjectScoreDetails.CE2TotalMarks + ' )';
    newCell.setAttribute("width", '10%');
    newRow.appendChild(newCell);

    // Attendance marks cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'ATTENDANCE MARKS' + ' (OUT OF ' + subjectScoreDetails.attendanceTotalMarks + ' )';
    newCell.setAttribute("width", '13%');
    newRow.appendChild(newCell);

    // Sem exam marks cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'SEMESTER EXAM MARKS' + ' (OUT OF ' + subjectScoreDetails.semExamTotalMarks + ' )';
    newCell.setAttribute("width", '13%');
    newRow.appendChild(newCell);

    // Internal exam Status
    newCell = document.createElement("th");
    newCell.innerHTML = 'INTERNAL EXAM STATUS';
    newCell.setAttribute("width", '6%');
    newRow.appendChild(newCell);

    // Semester exam Status
    newCell = document.createElement("th");
    newCell.innerHTML = 'SEMESTER EXAM STATUS';
    newCell.setAttribute("width", '6%');
    newRow.appendChild(newCell);

    // Overall Status
    newCell = document.createElement("th");
    newCell.innerHTML = 'OVERALL STATUS';
    newCell.setAttribute("width", '6%');
    newRow.appendChild(newCell);

}

function checkNegative(scoreId, rowId) {
    if (parseInt(document.getElementById(scoreId).value) < 0) {
        showError(scoreId, '#ff6666', "Marks can't be negative");
        return 0;
    } else showError(scoreId, '', '');
    return 1;
}

function checkScoreLimit(scoreId, rowId) {
    if (scoreId.includes("ce1Score")) {
        if (parseInt(document.getElementById(scoreId).value) > subjectScoreDetails.CE1TotalMarks) {
            showError(scoreId, '#ff6666', "CE-1 marks can't be greater than " + subjectScoreDetails.CE1TotalMarks);
            return 0;
        } else showError(scoreId, '', '');
    }
    if (scoreId.includes("ce2Score")) {
        if (parseInt(document.getElementById(scoreId).value) > subjectScoreDetails.CE2TotalMarks) {
            showError(scoreId, '#ff6666', "CE-2 marks can't be greater than " + subjectScoreDetails.CE2TotalMarks);
            return 0;
        } else showError(scoreId, '', '');
    }
    if (scoreId.includes("attendanceScore")) {
        if (parseInt(document.getElementById(scoreId).value) > subjectScoreDetails.attendanceTotalMarks) {
            showError(scoreId, '#ff6666', "Attendance marks can't be greater than " + subjectScoreDetails.attendanceTotalMarks);
            return 0;
        } else showError(scoreId, '', '');
    }
    if (scoreId.includes("semExamScore")) {
        if (parseInt(document.getElementById(scoreId).value) > subjectScoreDetails.semExamTotalMarks) {
            showError(scoreId, '#ff6666', "semester exam marks can't be greater than " + subjectScoreDetails.semExamTotalMarks);
            return 0;
        } else showError(scoreId, '', '');
    }
    return 1;
}

function calculateInternalExamStatus(scoreId, rowId) {
    var tempCE1Score = '';
    var tempCE2Score = '';
    var tempAttendanceScore = '';

    tempCE1Score = parseInt(document.getElementById("ce1Score" + rowId).value);
    tempCE2Score = parseInt(document.getElementById("ce2Score" + rowId).value);
    tempAttendanceScore = parseInt(document.getElementById("attendanceScore" + rowId).value);

    if (isNaN(tempCE1Score) && isNaN(tempCE2Score) && isNaN(tempAttendanceScore)) {
        document.getElementById("internalExamStatus" + rowId).innerHTML = '';
        document.getElementById("internalExamStatus" + rowId).style.color = "";
        return;
    }
    else {
        if (isNaN(tempCE1Score)) tempCE1Score = 0;
        if (isNaN(tempCE2Score)) tempCE2Score = 0;
        if (isNaN(tempAttendanceScore)) tempAttendanceScore = 0;

        if ((tempCE1Score + tempCE2Score + tempAttendanceScore) >= 0) {
            if ((tempCE1Score + tempCE2Score + tempAttendanceScore) < subjectScoreDetails.internalExamPassingMarks) {
                document.getElementById("internalExamStatus" + rowId).innerHTML = 'FAIL';
                document.getElementById("internalExamStatus" + rowId).style.color = "#700e0e";
            } else if ((tempCE1Score + tempCE2Score + tempAttendanceScore) >= subjectScoreDetails.internalExamPassingMarks) {
                document.getElementById("internalExamStatus" + rowId).innerHTML = 'PASS';
                document.getElementById("internalExamStatus" + rowId).style.color = "#3ce94a";
            }
        }
    }
}

function calculateSemExamResultStatus(scoreId, rowId) {
    var temSemExamScore = parseInt(document.getElementById(scoreId).value);
    if (isNaN(temSemExamScore)) {
        document.getElementById("semExamStatus" + rowId).innerHTML = '';
        document.getElementById("semExamStatus" + rowId).style.color = "";
        return;
    }
    if (temSemExamScore >= 0) {
        if (temSemExamScore < subjectScoreDetails.semExamPassingMarks) {
            document.getElementById("semExamStatus" + rowId).innerHTML = 'FAIL';
            document.getElementById("semExamStatus" + rowId).style.color = "#700e0e";
        } else if (temSemExamScore >= subjectScoreDetails.semExamPassingMarks) {
            document.getElementById("semExamStatus" + rowId).innerHTML = 'PASS';
            document.getElementById("semExamStatus" + rowId).style.color = "#3ce94a";
        }
    }
}

function calculateOverallResultStatus(rowId) {
    var tempInternalExamStatus = document.getElementById("internalExamStatus" + rowId).innerHTML;
    var tempSemExamStatus = document.getElementById("semExamStatus" + rowId).innerHTML;
    if (tempInternalExamStatus != '' || tempSemExamStatus != '') {
        if (tempInternalExamStatus.trim() == '') tempInternalExamStatus = 'FAIL';
        if (tempSemExamStatus.trim() == '') {
            tempSemExamStatus = 'FAIL';
        }

        if (tempInternalExamStatus == 'FAIL' && tempSemExamStatus == 'FAIL') {
            document.getElementById("overAllStatus" + rowId).innerHTML = 'FAIL';
            document.getElementById("overAllStatus" + rowId).style.color = "#700e0e";
        }
        if (tempInternalExamStatus == 'FAIL' && tempSemExamStatus == 'PASS') {
            document.getElementById("overAllStatus" + rowId).innerHTML = 'FAIL';
            document.getElementById("overAllStatus" + rowId).style.color = "#700e0e";
        }
        if (tempInternalExamStatus == 'PASS' && tempSemExamStatus == 'FAIL') {
            document.getElementById("overAllStatus" + rowId).innerHTML = 'FAIL';
            document.getElementById("overAllStatus" + rowId).style.color = "#700e0e";
        }
        if (tempInternalExamStatus == 'PASS' && tempSemExamStatus == 'PASS') {
            document.getElementById("overAllStatus" + rowId).innerHTML = 'PASS';
            document.getElementById("overAllStatus" + rowId).style.color = "#3ce94a";
        }
    } else {
        document.getElementById("overAllStatus" + rowId).innerHTML = '';
        document.getElementById("overAllStatus" + rowId).style.color = "";
    }
}

function getStatus(id) {
    if (id.includes("ce1Score")) t = id.split("ce1Score");
    else if (id.includes("ce2Score")) t = id.split("ce2Score");
    else if (id.includes("attendanceScore")) t = id.split("attendanceScore");
    else if (id.includes("semExamScore")) t = id.split("semExamScore");
    var rowId = t[1];

    if (checkNegative(id, rowId) == 0) return;
    if (checkScoreLimit(id, rowId) == 0) return;

    if (id.includes("ce1Score") || id.includes("ce2Score") || id.includes("attendanceScore")) {
        calculateInternalExamStatus(id, rowId);
    }
    if (id.includes("semExamScore")) {
        calculateSemExamResultStatus(id, rowId);
    }
    calculateOverallResultStatus(rowId);
}

function resetTableErrors() {
    var table = document.getElementById("scoreTableBody");
    for (var r = 0, n = table.rows.length; r < n; r++) {
        table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[4].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[5].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[6].getElementsByTagName("input")[0].style.backgroundColor = "";
    }
}

function scoreValidation() {
    resetTableErrors();

    var table = document.getElementById("scoreTableBody");
    for (var r = 0, n = table.rows.length; r < n; r++) {
        // CE1 score validation
        if (table.rows[r].cells[3].getElementsByTagName("input")[0].value.trim() < 0) {
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Marks can't be negative");
            return 0;
        } else table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[3].getElementsByTagName("input")[0].value.trim() > subjectScoreDetails.CE1TotalMarks) {
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "CE-1 marks can't be greater than " + subjectScoreDetails.CE1TotalMarks);
            return 0;
        } else table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";

        // CE2 score validation
        if (table.rows[r].cells[4].getElementsByTagName("input")[0].value.trim() < 0) {
            table.rows[r].cells[4].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Marks can't be negative");
            return 0;
        } else table.rows[r].cells[4].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[4].getElementsByTagName("input")[0].value.trim() > subjectScoreDetails.CE2TotalMarks) {
            table.rows[r].cells[4].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "CE-2 marks can't be greater than " + subjectScoreDetails.CE2TotalMarks);
            return 0;
        } else table.rows[r].cells[4].getElementsByTagName("input")[0].style.backgroundColor = "";

        // attendance marks validation
        if (table.rows[r].cells[5].getElementsByTagName("input")[0].value.trim() < 0) {
            table.rows[r].cells[5].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Marks can't be negative");
            return 0;
        } else table.rows[r].cells[5].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[5].getElementsByTagName("input")[0].value.trim() > subjectScoreDetails.attendanceTotalMarks) {
            table.rows[r].cells[5].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Attendance marks can't be greater than " + subjectScoreDetails.attendanceTotalMarks);
            return 0;
        } else table.rows[r].cells[5].getElementsByTagName("input")[0].style.backgroundColor = "";

        // semester exam marks validation
        if (table.rows[r].cells[6].getElementsByTagName("input")[0].value.trim() < 0) {
            table.rows[r].cells[6].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Marks can't be negative");
            return 0;
        } else table.rows[r].cells[6].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[6].getElementsByTagName("input")[0].value.trim() > subjectScoreDetails.semExamTotalMarks) {
            table.rows[r].cells[6].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "semester exam marks can't be greater than " + subjectScoreDetails.semExamTotalMarks);
            return 0;
        } else table.rows[r].cells[6].getElementsByTagName("input")[0].style.backgroundColor = "";
    }
    return 1;
}

function prepareMasterData() {
    semester = '';
    academicYear = '';
    batchName = '';
    subjectName = '';
    masterScoreId = '';
    resultStatus = '';

    var tempSem = document.getElementById('semester').value.trim().toUpperCase();
    tempSem = tempSem.split("-");
    semester = tempSem[1];

    academicYear = document.getElementById('academicYear').value.trim();
    batchName = document.getElementById('batchName').value.trim().toUpperCase();
    subjectName = document.getElementById('subjetName').value.trim().toUpperCase();
    masterScoreId = document.getElementById('examScoreMasterId').value.trim();
    resultStatus = document.getElementById('resultStatus').value.trim().toUpperCase();

    var masterObj = {
        masterScoreId: masterScoreId,
        academicYear: academicYear,
        batchId: batchId,
        batchName: batchName,
        semester: semester,
        subjectId: subjectId,
        subjectName: subjectName,
        resultStatus: resultStatus
    }
    scoreMasterData.push(masterObj);
    return 1;
}

function prepareTableData() {
    studentScoreDetails = [];
    var table = document.getElementById("scoreTableBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        let tempScoreIds = table.rows[r].cells[0].innerHTML.trim();
        let tempRollNo = table.rows[r].cells[1].innerHTML.trim();
        let tempStudentId = table.rows[r].cells[2].id.trim();
        let tempStudName = table.rows[r].cells[2].innerHTML.trim();
        let tempCE1Score = parseInt(table.rows[r].cells[3].getElementsByTagName("input")[0].value.trim());
        let tempCE2Score = parseInt(table.rows[r].cells[4].getElementsByTagName("input")[0].value.trim());
        let tempAttendanceScore = parseInt(table.rows[r].cells[5].getElementsByTagName("input")[0].value.trim());
        let tempSemesterExamScore = parseInt(table.rows[r].cells[6].getElementsByTagName("input")[0].value.trim());
        let tempInternalExamStatus = table.rows[r].cells[7].innerHTML.trim();
        let tempSemExamStatus = table.rows[r].cells[8].innerHTML.trim();
        let tempOverallStatus = table.rows[r].cells[9].innerHTML.trim();

        if(isNaN(tempCE1Score)) tempCE1Score = '';
        if(isNaN(tempCE2Score)) tempCE2Score = '';
        if(isNaN(tempAttendanceScore)) tempAttendanceScore = '';
        if(isNaN(tempSemesterExamScore)) tempSemesterExamScore = '';

        var studentName = tempStudName.split(" ");

        var obj = {
            scoreId: tempScoreIds,
            rollNo: tempRollNo,
            studentId: tempStudentId,
            studentFirstName: studentName[0].trim(),
            studentLastName: studentName[1].trim(),
            CE1Score: tempCE1Score,
            CE2Score: tempCE2Score,
            attendanceScore: tempAttendanceScore,
            semesterExamScore: tempSemesterExamScore,
            internalExamStatus: tempInternalExamStatus.trim(),
            semesterExamStatus: tempSemExamStatus.trim(),
            overallStatus: tempOverallStatus.trim()
        };
        studentScoreDetails.push(obj);
    }
}

function saveScore() {
    var saveFlag = 'addScore';
    document.getElementById('saveButton').disabled = true;
    if (scoreValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (prepareMasterData() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    if (prepareTableData() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    document.getElementById('errorMessage').innerHTML = '';
    if (confirm("Are you sure you want to save result???")) {
        document.getElementById('saveButton').disabled = true;
        document.getElementById('successMessage').innerHTML = 'Saving Please wait.....';
        $.post('saveScore.php', {
            'saveFlag': saveFlag,
            'studentScoreDetails': studentScoreDetails,
            'scoreMasterData': scoreMasterData
        },
            function (data) {
                document.getElementById('successMessage').innerHTML = ' Marks successfully saved. Please wait. The page will get auto-refresh...';
                location.reload();
            });
    } else document.getElementById('saveButton').disabled = false;
}