var academicApproval='';


$(function() {
    $(document).ready(function() {
        if (tempFacultyPhoto.length > 0) {
            var passPortPhotoPreview = document.getElementById('passPortPhotoPreview');
            passPortPhotoPreview.src = "../../../dist/img/faculty/facultyProfilePhoto/" + tempFacultyPhoto;
            passPortPhotoPreview.style.height = 200;
            passPortPhotoPreview.style.width = 180;
        }
        if (tempChequeProof.length > 0) {
            var checkProofPreview = document.getElementById('cancelledCheckfPreview');
            checkProofPreview.src = "../../../dist/img/faculty/facultyChequeProof/" + tempChequeProof;
            checkProofPreview.style.height = 200;
            checkProofPreview.style.width = 180;
        }
        if (tempAddress.length > 0) {
            var test = document.createElement("a");
            test.href = "../../../dist/img/faculty/facultyAddressProof/" + tempAddress;
            test.target = '_blank';
            test.title = 'Click hear to view the Document';
            test.className = 'btn btn-primary fS10 p10 mL10 tAC';
            var icon = document.createElement("i");
            icon.className = 'fas fa-eye';

            document.getElementById("addressProofPreview").appendChild(test);
            test.appendChild(icon);
        }
        if (tempIdProof.length > 0) {
            var test = document.createElement("a");
            test.href = "../../../dist/img/faculty/facultyIdProof/" + tempIdProof;
            test.target = '_blank';
            test.title = 'Click hear to view the Document';
            test.className = 'btn btn-primary fS10 p10 mL10 tAC';
            var icon = document.createElement("i");
            icon.className = 'fas fa-eye';

            document.getElementById("idProofPreview").appendChild(test);
            test.appendChild(icon);
        }
        if (tempFRe.length > 0) {
            var test = document.createElement("a");
            test.href = "../../../dist/img/faculty/facultyResumes/" + tempFRe;
            test.target = '_blank';
            test.title = 'Click hear to view the Document';
            test.className = 'btn btn-primary fS10 p10 mL10 tAC';
            var icon = document.createElement("i");
            icon.className = 'fas fa-eye';

            document.getElementById("facultyResumePreview").appendChild(test);
            test.appendChild(icon);
        }
        if (tempAccademic.length > 0) {
            var test = document.createElement("a");
            test.href = "../../../dist/img/faculty/facultyAcademicCertificates/" + tempAccademic;
            test.target = '_blank';
            test.title = 'Click hear to view the Document';
            test.className = 'btn btn-primary fS10 p10 mL10 tAC';

            var icon = document.createElement("i");
            icon.className = 'fas fa-eye';

            document.getElementById("academicCertificatePreview").appendChild(test);
            test.appendChild(icon);
        }
        if (tempPastExperience.length > 0) {
            var test = document.createElement("a");
            test.href = "../../../dist/img/faculty/facultyExperienceCertificates/" +
                tempPastExperience;
            test.target = '_blank';
            test.title = 'Click hear to view the Document';
            test.className = 'btn btn-primary fS10 p10 mL10 tAC';
            var icon = document.createElement("i");
            icon.className = 'fas fa-eye';

            document.getElementById("pastExperienceCertificatePreview").appendChild(test);
            test.appendChild(icon);
        }

        if (tempAgreementAcceptance != '') {
            document.getElementById('checkedImgForAgreementAcceptance').hidden = false;
            var checkedImageView = document.getElementById('checkedImgForAgreementAcceptance');
            checkedImageView.src = "../../../dist/img/icons/checkBox.jpg";
            checkedImageView.style.height = 13;
            checkedImageView.style.width = 13;
            document.getElementById('agreementAcceptLabel').hidden = false;
        }
        if (tempInvoiceType == 'GST') document.getElementById('gstTypeInvoiceDetails').hidden = false;
        selectDropdownValue("instituteOnboardingStatus", academicApproval);
        setOldValues();
    });
});

function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].value;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}


function setOldValues() {
    oldFacultyProfileReviewStatus = '';
    oldFacultyProfileReviewStatus = document.getElementById('instituteOnboardingStatus').value.trim().toUpperCase();
}

function setHeaders() {
    facultyId = '';
    facultyFirstName = '';
    facultyMiddleName = '';
    facultyLastName = '';
    facultyEmailId = '';
    facultyPassword = '';
    facultyPrimaryNumber = '';
    facultyWhatsAppNumber = '';
    facultyAlternateNumber = '';
    facultyPanCard = '';
    facultyAddress = '';
    // enrollment
    facultyType = '';
    dateOfCommencement = '';
    subjectOffered = '';
    // bank details
    fracultyBankName = '';
    facultyAccountHolderName = '';
    facultyIFSCcode = '';
    facultyAccountType = '';
    facultyAccountNumber = '';
    facultyBranch = '';

    facultyId = document.getElementById('facultyId').value.trim();
    facultyFirstName = document.getElementById('facultyFirstName').value.trim().toUpperCase();
    facultyMiddleName = document.getElementById('facultyMiddleName').value.trim().toUpperCase();
    facultyLastName = document.getElementById('facultyLastName').value.trim().toUpperCase();
    facultyEmailId = document.getElementById('facultyEmailId').value.trim();
    facultyPassword = document.getElementById('facultyPassword').value.trim();
    facultyPrimaryNumber = document.getElementById('facultyPrimaryNumber').value.trim();
    facultyWhatsAppNumber = document.getElementById('facultyWhatsAppNumber').value.trim();
    facultyAlternateNumber = document.getElementById('facultyAlternateNumber').value.trim();
    facultyPanCard = document.getElementById('facultyPanCard').value.trim().toUpperCase();
    facultyAddress = document.getElementById('facultyAddress').value.trim();

    facultyType = document.getElementById('facultyType').value.trim().toUpperCase();
    dateOfCommencement = document.getElementById('dateOfCommencement').value.trim();
    // dateOfCommencement = document.getElementById('dateOfCommencement').value();
    subjectOffered = document.getElementById('subjectOffered').value.trim().toUpperCase();

    fracultyBankName = document.getElementById('facultyBankName').value.trim().toUpperCase();
    facultyAccountHolderName = document.getElementById('facultyAccountHolderName').value.trim().toUpperCase();
    facultyIFSCcode = document.getElementById('ifscCode').value.trim().toUpperCase();
    facultyAccountType = document.getElementById('facultyAccountType').value.trim().toUpperCase();
    facultyAccountNumber = document.getElementById('facultyAccountNo').value.trim().toUpperCase();
    facultyBranch = document.getElementById('facultyBankBranch').value.trim().toUpperCase();
}

function part1Validation() {
    if (facultyFirstName == '') return 0;
    if (facultyLastName == '') return 0;
    if (facultyPassword == '') return 0;
    if (facultyPrimaryNumber == '') return 0;
    if (facultyPrimaryNumber.length != 10) return 0;
    if (facultyWhatsAppNumber == '') return 0;
    if (facultyWhatsAppNumber.length != 10) return 0;
    if (facultyPanCard == '') return 0;
    if (facultyAddress == '') return 0;
    return 1;
}

function part2Validation() {
    if (facultyType == '') return 0;
    if (dateOfCommencement == '') return 0;
    if (subjectOffered == '') return 0;
    return 1;
}

function part3Validation() {
    if (fracultyBankName == '') return 0;
    if (facultyAccountHolderName == '') return 0;
    if (facultyIFSCcode == '') return 0;
    if (facultyAccountType.toUpperCase() == '') return 0;
    if (facultyAccountNumber == '') return 0;
    if (facultyBranch == '') return 0;
    return 1;
}

function part4Validation() {
    if (tempAddress == '') return 0;
    if (tempIdProof == '') return 0;
    if (tempFRe == '') return 0;
}


function approveFacultyValidation() {
    if (setHeaders() == 0) return 0;
    if (part1Validation() == 0) {
        showError('', '#ff6666', "All required fields in Personal Information section should be filled.");
        return 0;
    }
    if (part2Validation() == 0) {
        showError('', '#ff6666', "All required fields in Assignment Details section should be filled.");
        return 0;
    }
    if (part3Validation() == 0) {
        showError('', '#ff6666', "All required fields in Bank Details section should be filled.");
        return 0;
    }
    if (part4Validation() == 0) {
        showError('', '#ff6666', "All required documents should be uploaded.");
        return 0;
    }
    if (tempAgreementAcceptance == '') {
        showError('', '#ff6666', "Faculty has not accepted agreement yet.");
        return 0;
    }
    return 1;
}


function validatingOldValues() {
    statement = "";
    var flagForStatement = 0;

    if (oldFacultyProfileReviewStatus != instituteOnboardinStatus) {
        flagForStatement = 1;
        statement = statement + "Faculty profile review status updated from " + oldFacultyProfileReviewStatus + " to " + instituteOnboardinStatus + "<br>";
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    }
    return 1;
}


function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function updateOnboardingStatus(userName) {
    var saveFlag = 'updateOnboardingStatus';
    document.getElementById('updateStatus').disabled = true;
    instituteOnboardinStatus = '';
    instituteOnboardinStatus = document.getElementById('instituteOnboardingStatus').value.trim().toUpperCase();
    facultyId = document.getElementById('facultyId').value.trim();
    if (instituteOnboardinStatus == 'INSTITUTE ONBOARDING STATUS') {
        showError('', '#ff6666', "Please Select Status.");
        document.getElementById('updateStatus').disabled = false;
        return 0;
    } else showError('', '', '');
    if (instituteOnboardinStatus == 'APPROVED') {
        if (approveFacultyValidation() == 0) {
            document.getElementById('updateStatus').disabled = false;
            return;
        }
    }
    if (validatingOldValues() == 0) {
        document.getElementById('updateStatus').disabled = false;
        return;
    }
    if (checkOnline() == false) {
        document.getElementById("updateStatus").disabled = false;
        return;
    }
    if (confirm('Are you sure you want to update status')) {
        document.getElementById('successMessage').innerHTML = 'updating. Please wait....';
        $.post('saveFacultyOnboardingStatus.php', {
            'saveFlag': saveFlag,
            'facultyId': facultyId,
            'instituteOnboardinStatus': instituteOnboardinStatus,
            'userName': userName,
            'statement': statement
        }, function (data) {
            document.getElementById('successMessage').innerHTML = 'updated successfuly. Please wait. The page will get auto-refresh...';
            location.reload();
        });
    }
    else document.getElementById('updateStatus').disabled = false;
}