function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "semester") dummyOptions(theSelect, options, "SEMESTER");
    if (selectName == "subjectName") dummyOptions(theSelect, options, "SUBJECT");
    if (selectName == "assignmentIdDrpodown") dummyOptions(theSelect, options, "ASSIGNMENT ID");
    if (selectName == "facultyNameDropdown") dummyOptions(theSelect, options, "FACULTY NAME");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("semester")) {
            options.value = options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("assignmentIdDrpodown")) {
            options.value = options.text = results[i].assignmentId.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("facultyNameDropdown")) {
            facultyName = results[i].firstName + ' ' + results[i].lastName;
            options.value = options.text = facultyName.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}

function getDropdownValue(id) {
    var tempP = document.getElementById(id);
    return tempP.options[tempP.selectedIndex].text;
}

function filterOtherDropDown(flag) {
    tempSemester = getSelectValues('', document.getElementById("semester")).trim();
    tempSubject = getSelectValues('', document.getElementById("subjectName")).trim();
    tempSubjectName = [];
    tempFacultyName = [];
    tempAssignmentId = [];
    newAssignmentIdArray = [];
    if (flag == "semester") {
        loadDataDropdown("subjectName", []);
        loadDataDropdown("assignmentIdDrpodown", []);
        loadDataDropdown("facultyNameDropdown", []);
        for (let i = 0; i < masterSubjectName.length; i++) {
            if (masterSubjectName[i].semester == tempSemester) {
                tempSubjectName.push(obj = {
                    "subjectId": masterSubjectName[i].subjectId.trim(),
                    "subjectName": masterSubjectName[i].subjectName.trim()
                });
            }
            loadDataDropdown("subjectName", tempSubjectName);
        }
        for (let i = 0; i < masterAssignmentData.length; i++) {
            if (masterAssignmentData[i].semester == tempSemester) {
                tempAssignmentId.push(obj = {
                    "assignmentId": masterAssignmentData[i].assignmentId.trim()
                });
            }
            loadDataDropdown("assignmentIdDrpodown", tempAssignmentId);
        }
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == "subject") {
        for (let i = 0; i < masterAssignmentData.length; i++) {
            if (masterAssignmentData[i].semester == tempSemester && masterAssignmentData[i].subjectName == tempSubject) {
                newAssignmentIdArray.push(obj = {
                    "assignmentId": masterAssignmentData[i].assignmentId.trim()
                });
            }
            loadDataDropdown("assignmentIdDrpodown", newAssignmentIdArray);
        }
        for (let i = 0; i < masterFacultyName.length; i++) {
            tempSubjectList = masterFacultyName[i].facultySubject.split("|");
            for (j = 0; j < tempSubjectList.length; j++) {
                if (tempSubjectList[j] == tempSubject) {
                    tempFacultyName.push(obj = {
                        "firstName": masterFacultyName[i].firstName.trim().toUpperCase(),
                        "lastName": masterFacultyName[i].lastName.trim().toUpperCase()
                    });
                }
            }
            loadDataDropdown("facultyNameDropdown", tempFacultyName);
        }
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == "assignment") {
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == 'faculty') {
        var table = $('#example1').DataTable();
        table.draw();
    }
}

function resetReview() {
    noOfRating = 0;
    for (let i = 0; i < 10; i++) {
        document.getElementById("rating" + (i + 1)).className = "btn btn-scale btn-scale-desc-" + (i + 1);
    }
}

function countRating(elementId) {
    var temp = elementId.split("rating");
    resetReview();
    noOfRating = temp[1];
    document.getElementById(elementId).className = "btn btn-scale btn-scale-desc-" + temp[1] + " btn-border";
}

function addReview(assignmentId,reviewId,unitNo,noOfLectures,noOfPenaltyFlag)
{
    window.location.href = "addReview.php?aId=" + assignmentId + "&rId=" + reviewId +"&uNo=" + unitNo + "&nOL=" + noOfLectures + "&nOpf=" + noOfPenaltyFlag;
}

function viewAssignmentReview(assignmentId,reviewId,unitNo,noOfLectures,noOfPenaltyFlag)
{
    window.location.href = "viewReview.php?aId=" + assignmentId + "&rId=" + reviewId +"&uNo=" + unitNo + "&nOL=" + noOfLectures + "&nOpf=" + noOfPenaltyFlag;
}

function editAssignmentReview(assignmentId,reviewId,unitNo,noOfLectures,noOfPenaltyFlag)
{
    window.location.href = "editReview.php?aId=" + assignmentId + "&rId=" + reviewId +"&uNo=" + unitNo + "&nOL=" + noOfLectures + "&nOpf=" + noOfPenaltyFlag;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
      .replace(/\'/g, "\\\'")
      .replace(/\"/g, "\\\"");
  
    return output;
  }

var reviewDate = '',
    commentsOfLecture = '',
    penaltyAmount = '',
    approvedExecutionTime = '';
    noOfRating = 0,
    contentArray = [];

var assignmentId = '',
    reviewId = '',
    facultyName = '';

function setHeaders() {
    reviewDate = '';
    commentsOfLecture = '';
    penaltyAmount = '';
    approvedExecutionTime = '';

    reviewDate = $("#reviewDateAndTime").find("input").val();
    commentsOfLecture = document.getElementById("commentText").value.trim();
    commentsOfLecture = escapeSpecialCharacters(commentsOfLecture);
    commentsOfLecture = commentsOfLecture.replace("\n", " ");
    penaltyAmount = document.getElementById("penaltyAmount").value;
    approvedExecutionTime = document.getElementById("approvedExecutionTime").value.trim();

    assignmentId = document.getElementById('asssignmentId').value.trim();
    reviewId = document.getElementById('reviewId').value.trim();
    unitNo = document.getElementById('unitNo').value.trim();
    facultyName = document.getElementById('facultyName').value.trim();
    return 1;
}

function formValidation() {
    if (setHeaders() == 0) return 0;

    if (approvedExecutionTime == '') {
        showError('approvedExecutionTime', '#ff6666', "Please enter approved execution time.");
        return 0;
    } else showError('approvedExecutionTime', '', '');

    if (approvedExecutionTime < 0) {
        showError('approvedExecutionTime', '#ff6666', "Time can not be negative.");
        return 0;
    } else showError('approvedExecutionTime', '', '');

    if (approvedExecutionTime == 0) {
        showError('approvedExecutionTime', '#ff6666', "Approved Time can not be zero.");
        return 0;
    } else showError('approvedExecutionTime', '', '');

    if (reviewDate == '') {
        showError('reviewDateAndTime', '#ff6666', "Review Date cannot be Blank.");
        return 0;
    } else showError('reviewDateAndTime', '', '');

    if (noOfRating == 0) {
        showError('', '#ff6666', "Please Select Rating of Unit.");
        return 0;
    } else showError('', '', '');

    if (penaltyAmount < 0) {
        showError('', '#ff6666', "Penalty Amount Cannot be negative.");
        return 0;
    } else showError('', '', '');

    if (penaltyAmount == '') {
           penaltyAmount = '0';
    }

    if (makeArray() == 0) return 0;
    return 1;
}

function makeArray()
{
    contentArray = [];
    var obj = {
        'assignmentId': assignmentId,
        'reviewId': reviewId,
        'unitNo': unitNo,
        "facultyId": facultyId,
        'facultyName': facultyName,
        'reviewDate': reviewDate,
        'noOfRating': noOfRating,
        'comments': commentsOfLecture,
        'penaltyAmount' : penaltyAmount,
        'approvedExecutionTime' : approvedExecutionTime,
    }
    contentArray.push(obj);
}

function saveReview(id) {
    var saveFlag = "SAVEFLAG";
    if(id == 'saveReview') reviewStatus= 'UNDER REVIEW';
    else reviewStatus = 'COMPLETED';
    if (formValidation() == 0) return;
    else {
        if (confirm("Are you sure you want to save Unit Review??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Lecture Review. Please wait...';
            document.getElementById('saveReview').disabled = true;
            document.getElementById('saveAndPublishReview').disabled = true;
            $.post('saveAssignmentReview.php', {
                'saveFlag': saveFlag,
                'reviewStatus' : reviewStatus,
                'contentArray': contentArray,
            }, function(data) {
                document.getElementById('successMessage').innerHTML = 'Lecture Review Saved Successfully...';
                // console.log(data);
            });
        }
    }
}

function updateReview(id)
{
    var saveFlag = "editReview";
    if(id == 'saveReview') reviewStatus= 'UNDER REVIEW';
    else reviewStatus = 'COMPLETED';
    if (formValidation() == 0) return;
    else {
        if (confirm("Are you sure you want to save Unit Review??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Lecture Review. Please wait...';
            document.getElementById('saveReview').disabled = true;
            document.getElementById('saveAndPublishReview').disabled = true;
            $.post('saveAssignmentReview.php', {
                'saveFlag': saveFlag,
                'reviewStatus' : reviewStatus,
                'contentArray': contentArray,
            }, function(data) {
                document.getElementById('successMessage').innerHTML = 'Lecture Review Saved Successfully...';
                if (data == 'ADD') alert("Review can't be updated.");
                // console.log(data);
            });
        }
    }
}