<?php
session_start();
if (strlen($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    if ($_SESSION['academicExecutiveLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';

$masterSemester = [];
$sql = "SELECT * FROM semester";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterSemester, $row);
    }
}

$masterSubjectName = [];
$sql2 = "SELECT * FROM subjects;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($masterSubjectName, $row2);
    }
}

$masterAssignmentData = [];
$sql3 = "SELECT DISTINCT assignmentId,semester,subjectName FROM f_assignment WHERE facultyName NOT IN ('Not Selected')  ORDER BY assignmentId DESC;";
$result3 = $conn->query($sql3);
if ($result3->num_rows > 0) {
    while ($row3 = $result3->fetch_assoc()) {
        array_push($masterAssignmentData, $row3);
    }
}

$masterFacultyName = [];
$sql4 = "SELECT facultyId,firstName,middleName,lastName,facultySubject FROM faculty where formStatus = 'APPROVED' order by facultyId desc;";
$result4 = $conn->query($sql4);
if ($result4->num_rows > 0) {
    while ($row4 = $result4->fetch_assoc()) {
        array_push($masterFacultyName, $row4);
    }
}
require '../../common/navbar.php';
?>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/moment/moment.min.js"></script>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">Assignment Review List</h3>
                            <br><br>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Semester</label>
                                        <select class="form-control custom-select" id="semester" style="width: 100%;"
                                            onchange="filterOtherDropDown('semester');">
                                            <option disabled selected>SELECT SEMESTER</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Subject Name</label>
                                        <select class="form-control custom-select" id="subjectName" style="width: 100%;"
                                            onchange="filterOtherDropDown('subject');">
                                            <option selected>SELECT SUBJECT</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Faculty Name</label>
                                        <select class="form-control custom-select" id="facultyNameDropdown"
                                            style="width: 100%;" onchange="filterOtherDropDown('faculty');">
                                            <option selected>SELECT FACULTY NAME</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Assignment Id</label>
                                        <select class="form-control custom-select" id="assignmentIdDrpodown"
                                            style="width: 100%;" onchange="filterOtherDropDown('assignment');">
                                            <option selected>SELECT ASSIGNMENT ID</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p id='errorMessage' class="text-center"
                                            style="color: red; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <p id='successMessage' class="text-center"
                                            style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <span id="savedData"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 tAC">
                                    <div class="form-group">
                                        <input type="button" class="btn btn-primary mT27" value="Get List"
                                            id="generateDetails" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php require 'manageAllAssignmentReviewDetails.php' ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="masterAssignmentReview.js?v=<?php echo $fileVersion; ?>"></script>
<script>
var masterSemester = <?php echo json_encode($masterSemester); ?>;
var masterSubjectName = <?php echo json_encode($masterSubjectName); ?>;
var masterAssignmentData = <?php echo json_encode($masterAssignmentData); ?>;
var masterFacultyName = <?php echo json_encode($masterFacultyName); ?>;
$(function() {
    var tempProjectName = '',
        tempProgramName = '';

    tempSemester = getDropdownValue("semester").trim();
    tempSubject = getDropdownValue("subjectName").trim();

    $("#generateDetails").click(() => {
        document.getElementById('generateDetails').disabled = true;
        document.getElementById("successMessage").innerHTML = "Please wait while we load the data.";
        $.post('manageAllAssignmentReviewDetails.php', {
            'semesterName': tempSemester.trim(),
            'subjetcName': tempSubject.trim(),
        }, function(data) {
            $('#paeDetails').html(data);
            document.getElementById("successMessage").innerHTML = "";
            document.getElementById('generateDetails').disabled = false;
        });
    });

    $.fn.dataTableExt.afnFiltering.push(
        function(settings, data, dataIndex) {
            selectedSemesterName = getSelectValues('', document.getElementById("semester")).trim();
            var rowSemesterName = data[3];

            if (selectedSemesterName != 'SELECT SEMESTER') {
                inSemesterName = (selectedSemesterName.indexOf(rowSemesterName) !== -1) ? rowSemesterName :
                    false;
            } else inSemesterName = true;

            selectedSubjectName = getSelectValues('', document.getElementById("subjectName")).trim();
            var rowSubjectName = data[4];

            if (selectedSubjectName != 'SELECT SUBJECT') {
                inSubjectName = (selectedSubjectName.indexOf(rowSubjectName) !== -1) ? rowSubjectName :
                    false;
            } else inSubjectName = true;

            // faculty name
            selectedFacultyName = getSelectValues('', document.getElementById("facultyNameDropdown"))
                .trim();
            var rowFacultyName = data[1];

            if (selectedFacultyName != 'SELECT FACULTY NAME') {
                inFacultyName = (selectedFacultyName.indexOf(rowFacultyName) !== -1) ? rowFacultyName :
                    false;
            } else inFacultyName = true;

            // assignment Id
            selectedAssignmentID = getSelectValues('', document.getElementById("assignmentIdDrpodown"))
                .trim();
            var rowAssignmentID = data[0];

            if (selectedAssignmentID != 'SELECT ASSIGNMENT ID') {
                inAssignmentId = (selectedAssignmentID.indexOf(rowAssignmentID) !== -1) ? rowAssignmentID :
                    false;
            } else inAssignmentId = true;

            return inSemesterName && inSubjectName && inAssignmentId && inFacultyName;
        }
    );

    loadDataDropdown("semester", masterSemester);
    // loadDataDropdown("subjectName", masterSubjectName);
    // loadDataDropdown("assignmentIdDrpodown", masterAssignmentData);
    // loadDataDropdown("facultyNameDropdown", masterFacultyName);
});
</script>
<?php require '../../common/footer.php'; ?>