var auditorUserId = "",
    auditorCompanyName = "",
    auditorEmailId = "",
    auditorPassword = "",
    auditorFirstName = "",
    auditorLastName = "",
    duplicatEmail = false;


function randomString(length, chars) {
    var mask = '';
    if (chars.indexOf('a') > -1) mask += 'abcdefghijklmnopqrstuvwxyz';
    if (chars.indexOf('A') > -1) mask += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    if (chars.indexOf('#') > -1) mask += '0123456789';
    if (chars.indexOf('!') > -1) mask += '@#&*';
    var result = '';
    for (var i = length; i > 0; --i) result += mask[Math.floor(Math.random() * mask.length)];
    return result;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}
function checkDuplicate(emailId) {
    $.post('checkDuplicate.php', {
        'emailId': emailId
    },
        function (data) {
            if (data == 1) {
                showError('errorMessage', '', 'Duplicate email');
                document.getElementById("auditorEmailId").style.backgroundColor = "#ffc2b3";
                duplicatEmail = true;
                return duplicatEmail;
            } else {
                showError('errorMessage', '', '');
                document.getElementById("auditorEmailId").style.backgroundColor = "";
                duplicatEmail = false;
                return duplicatEmail;
            }
        }
    );
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}
function setHeaders() {
    auditorUserId = "";
    auditorCompanyName = '';
    auditorEmailId = '';
    auditorPassword = "";
    auditorFirstName = "";
    auditorLastName = "";

    auditorFirstName = document.getElementById("auditorFirstName").value.trim().toUpperCase();
    auditorLastName = document.getElementById("auditorLastName").value.trim().toUpperCase();
    auditorUserId = document.getElementById("auditorUserId").value.trim();
    auditorCompanyName = document.getElementById("auditorCompanyName").value.trim().toUpperCase();
    auditorEmailId = document.getElementById("auditorEmailId").value.trim();
    auditorPassword = document.getElementById("auditorPassword").value.trim();

    return 1;
}

function auditorValidation() {
    // life Coach first name
    if (auditorFirstName.length <= 0) {
        document.getElementById("auditorFirstName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter first name");
        return 0;
    } else {
        document.getElementById("auditorFirstName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // life coach last name
    if (auditorLastName.length <= 0) {
        document.getElementById("auditorLastName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter last name");
        return 0;
    } else {
        document.getElementById("auditorLastName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //auditor company name validation
    if (auditorCompanyName.length <= 0) {
        document.getElementById("auditorCompanyName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter company name");
        return 0;
    } else {
        document.getElementById("auditorCompanyName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //auditor EmailId validation
    if (auditorEmailId.length <= 0) {
        document.getElementById("auditorEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter email");
        return 0;
    } else {
        document.getElementById("auditorEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (!validateEmail(auditorEmailId)) {
        document.getElementById("auditorEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Email is not in correct format");
        // document.getElementById("errorMessage").style.display="block";
        return 0;
    } else {
        document.getElementById("auditorEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (duplicatEmail) {
        showError('errorMessage', '', 'Email Alredy Exist. Please Change it...');
        document.getElementById("auditorEmailId").style.backgroundColor = "#ffc2b3";
        return 0;
    } else {
        showError('errorMessage', '', '');
        document.getElementById("auditorEmailId").style.backgroundColor = "";
    }
    return 1;
}

function saveAuditor() {
    document.getElementById('saveButton').disabled = true;
    if (setHeaders() == 0) return;
    if (auditorValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (confirm("Are you sure you want to save Details")) {
        document.getElementById('successMessage').innerHTML = "Saving Data Please Wait...";
        document.getElementById('saveButton').disabled = true;
        $.post('saveAuditor.php', {
            'auditorFirstName': auditorFirstName,
            'auditorLastName': auditorLastName,
            'auditorUserId': auditorUserId,
            'auditorCompanyName': auditorCompanyName,
            'auditorEmailId': auditorEmailId,
            'auditorPassword': auditorPassword
        }, function (data) {
            console.log(data);
            document.getElementById('successMessage').innerHTML = "Data Saved successfully.";
            document.getElementById('saveButton').disabled = false;
            // location.reload();
        });
    }
    else document.getElementById('saveButton').disabled = false;
}

function showDetails(auditorId) {
    encodedValue_auditorId = btoa(auditorId);
    encodedKey_auditorId = btoa('lId');
    window.location.href = "viewAuditor.php?" + encodedKey_auditorId + "=" + encodedValue_auditorId;
}

function userEdit(auditorId) {
    encodedValue_auditorId = btoa(auditorId);
    encodedKey_auditorId = btoa('lId');
    window.location.href = "editAuditor.php?" + encodedKey_auditorId + "=" + encodedValue_auditorId;
}