<?php
require_once '../../common/connectToDB.php';
$conn->begin_transaction();
session_start();
date_default_timezone_set('Asia/Kolkata');
$timestamp = date("d-m-y : h:i:sa");

$academicExecutiveName = $_SESSION['academicExecutiveNameEdj'];
$userId = $_SESSION['academicExecutiveUserid'];
$userType = $_SESSION['academicExecutiveRightsEdj'];

try {
    if ($_POST['saveFlag'] === 'addScore') {
        $studentScoreDetails = $_POST['studentScoreDetails'];
        $scoreMasterData = $_POST['scoreMasterData'];
        $semester = $scoreMasterData[0]['semester'];
        $semesterParts = explode('-', $semester);
        $semesterNo = $semesterParts[1];

        $logQueryExecuted = '';
        $logStatement = "Scores saved for subject ({$scoreMasterData[0]['subjectName']}) in semester ({$scoreMasterData[0]['semester']}).";

        // Fetch seriesnumber using sql + query pattern
        $sqlSeries = "SELECT * FROM seriesnumber WHERE seriesName IN ('logID', 'eaxmScoreRowId')";
        $resultSeries = $conn->query($sqlSeries);
        $series = [];
        while ($row = $resultSeries->fetch_assoc()) {
            $series[$row['seriesName']] = $row['seriesValue'];
        }

        $logId = $series['logID'];
        $eaxmScoreRowId = isset($series['eaxmScoreRowId']) ? (int) $series['eaxmScoreRowId'] : 1;
        $masterScoreId = $scoreMasterData[0]['masterScoreId'];

        // Get subject score structure
        $subjectId = $conn->real_escape_string($scoreMasterData[0]['subjectId']);
        $sqlStructure = "SELECT * FROM subjectscore WHERE subjectId = '$subjectId'";
        $structureRes = $conn->query($sqlStructure);
        $subjectScoreStructure = [];
        while ($row = $structureRes->fetch_assoc()) {
            $subjectScoreStructure[$row['examType']] = $row;
        }

        // Check for existing scores
        $sqlCheck = "SELECT COUNT(*) as count FROM examinationscore WHERE examScoreMasterId = '$masterScoreId'";
        $resultCheck = $conn->query($sqlCheck);
        $existingCount = $resultCheck->fetch_assoc()['count'];
        $isInsert = $existingCount == 0;

        $insertValues = [];

        foreach ($studentScoreDetails as $student) {
            $studentId = $conn->real_escape_string($student['studentId']);
            $rollNo = $conn->real_escape_string($student['rollNo']);
            $firstName = $conn->real_escape_string($student['studentFirstName']);
            $lastName = $conn->real_escape_string($student['studentLastName']);

            foreach ($student['scores'] as $examType => $score) {
                $examScore = (int) $score;
                $passingMarks = (int) ($subjectScoreStructure[$examType]['examPassingMarks'] ?? 0);
                $status = $examScore >= $passingMarks ? 'PASS' : 'FAIL';

                $sqlCheckExist = "SELECT examScoreRowId FROM examinationscore 
                                  WHERE examScoreMasterId = '$masterScoreId' 
                                  AND studentId = '$studentId' AND examType = '$examType'";
                $resultCheckExist = $conn->query($sqlCheckExist);

                if ($resultCheckExist->num_rows > 0) {
                    $existingId = $resultCheckExist->fetch_assoc()['examScoreRowId'];
                    $sqlUpdate = "UPDATE examinationscore 
                                  SET examScore = '$examScore', internalExamStatus = '$status', scoreEntryTime = '$timestamp' 
                                  WHERE examScoreRowId = '$existingId'";
                    $conn->query($sqlUpdate);
                    $logQueryExecuted .= $sqlUpdate . '|||';
                } else {
                    $insertValues[] = "(
                        '$masterScoreId', '$eaxmScoreRowId', '$studentId', '{$scoreMasterData[0]['batchId']}',
                        '{$scoreMasterData[0]['batchName']}', '{$scoreMasterData[0]['semester']}',
                        '$subjectId', '{$scoreMasterData[0]['subjectName']}', '$examType',
                        '$examScore', '$status', '$timestamp'
                    )";
                    $eaxmScoreRowId++;
                }
            }
        }

        if (!empty($insertValues)) {
            $sqlInsert = "INSERT INTO examinationscore (
                examScoreMasterId, examScoreRowId, studentId, batchId, batchName, semester, subjectId, subjectName,
                examType, examScore, internalExamStatus, scoreEntryTime
            ) VALUES " . implode(", ", $insertValues);
            $conn->query($sqlInsert);
            $logQueryExecuted .= $sqlInsert . '|||';
        }

        $sqlUpdateMaster = "UPDATE examinationscoremaster 
                            SET resultStatus = '{$scoreMasterData[0]['resultStatus']}' 
                            WHERE examScoreMasterId = '{$masterScoreId}'";
        $conn->query($sqlUpdateMaster);
        $logQueryExecuted .= $sqlUpdateMaster . '|||';

        if ($isInsert) {
            $sqlUpdateSeriesEaxm = "UPDATE seriesnumber SET seriesValue = $eaxmScoreRowId WHERE seriesName = 'eaxmScoreRowId'";
            $conn->query($sqlUpdateSeriesEaxm);
        }

        $sqlUpdateLogId = "UPDATE seriesnumber SET seriesValue = seriesValue + 1 WHERE seriesName = 'logID'";
        $conn->query($sqlUpdateLogId);

        $logQueryEscaped = $conn->real_escape_string($logQueryExecuted);
        $logStatementEscaped = $conn->real_escape_string($logStatement);
        $sqlLog = "INSERT INTO logtable (
            logid, userid, username, user_type, timeStamp, logtype, statement, sqlQuery,
            userIPaddress, userLocation, timeZone, userNetworkConnectionInfo, lastVisitedPage
        ) VALUES (
            '$logId', '$userId', '$academicExecutiveName', '$userType', '$timestamp', 'UPDATE',
            '$logStatementEscaped', '$logQueryEscaped', '', '', '', '', ''
        )";
        $conn->query($sqlLog);

        $sqlESM = "SELECT * FROM examinationscoremaster 
                   WHERE batchId = '" . $scoreMasterData[0]['batchId'] . "' 
                   AND academicYear = '" . $scoreMasterData[0]['academicYear'] . "' 
                   AND semester = '" . $semesterNo . "' 
                   AND resultStatus = 'PENDING'";
        $resultESM = $conn->query($sqlESM);
        echo $resultESM->num_rows;

        if ($resultESM->num_rows == 0) {
            $subjectDetails = [];
            $nextSemester = 'SEMESTER-' . (intVal($semesterNo) + 1);
            $sqlSubjects = "SELECT * FROM subjects WHERE semester = '$nextSemester'";
            $resultSubjects = $conn->query($sqlSubjects);
            if ($resultSubjects->num_rows > 0) {
                while ($row = $resultSubjects->fetch_assoc()) {
                    $subjectDetails[] = $row;
                }
            }

            $sqlSN = "SELECT * FROM seriesnumber WHERE seriesName IN ('examinationScoreMasterId','eaxmScoreRowId')";
            $resultSN = $conn->query($sqlSN);
            $examinationScoreMasterId = 0;
            $eaxmScoreRowId = 0;
            while ($rowSN = $resultSN->fetch_assoc()) {
                if ($rowSN['seriesName'] == 'examinationScoreMasterId')
                    $examinationScoreMasterId = $rowSN['seriesValue'];
                if ($rowSN['seriesName'] == 'eaxmScoreRowId')
                    $eaxmScoreRowId = $rowSN['seriesValue'];
            }

            if (count($subjectDetails) > 0) {
                $sqlESMInsert = 'INSERT INTO examinationscoremaster VALUES ';
                foreach ($subjectDetails as $subject) {
                    $sqlESMInsert .= "('" . $examinationScoreMasterId . "',
                        '" . $scoreMasterData[0]['batchId'] . "',
                        '" . $scoreMasterData[0]['batchName'] . "',
                        '" . $scoreMasterData[0]['academicYear'] . "',
                        '" . (intVal($semesterNo) + 1) . "',
                        '" . $subject['subjectId'] . "',
                        '" . $subject['subjectName'] . "',
                        'PENDING'),";
                    $examinationScoreMasterId++;
                }
                $sqlESMInsert = rtrim($sqlESMInsert, ",");
                $conn->query($sqlESMInsert);
                $logQueryExecuted .= $sqlESMInsert . '|||';

                $sqlUpdateSeries = "UPDATE seriesnumber SET seriesValue = CASE 
                    WHEN seriesName = 'examinationScoreMasterId' THEN $examinationScoreMasterId 
                    WHEN seriesName = 'eaxmScoreRowId' THEN $eaxmScoreRowId 
                    ELSE seriesValue END";
                $conn->query($sqlUpdateSeries);
            }
        }
    }

    $conn->commit();
} catch (mysqli_sql_exception $e) {
    $conn->rollback();
    echo $e->getMessage();
    // throw $e;
}
$conn = null;
?>