<?php
session_start();
if (strlen($_SESSION['academicExecutiveLoginsuccessEdj'])) {
    if ($_SESSION['academicExecutiveLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
$academicYearList = [];

$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}

$masterBatchDetails = [];
$sql = "SELECT * FROM batchmaster ORDER BY batchId DESC;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterBatchDetails, $row);
    }
}
$semester = [];
$sql2 = "SELECT * FROM semester;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($semester, $row2);
    }
}
require '../../common/header.php';
require '../../common/navbar.php';
?> <div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">Pending Result Entry List</h3>
                            <br>
                            <br>
                            <div class='row'>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY BATCH CODE</label>
                                        <select class="select2" multiple="multiple" id="filterBatchCode"
                                            data-placeholder="SELECT BATCH CODE" style="width: 100%;"
                                            onchange="filterTable('batch')" ;>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                        <select class="select2" multiple="multiple" id="filterAyear"
                                            data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;"
                                            onchange="filterTable('studAyear')" ;>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY SEMESTER NO.</label>
                                        <select class="select2" multiple="multiple" id="semDropdown"
                                            style="width: 100%;" onchange="filterTable('semester');"
                                            data-placeholder="SELECT SEMESTER">
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingResultEntryTable">
                                <thead>
                                    <tr>
                                        <th width='15%'>BATCH NAME</th>
                                        <th width='15%'>ACADEMIC YEAR</th>
                                        <th width='15%'>SEMESTER</th>
                                        <th width='40%'>SUBJECT NAME</th>
                                        <th width='15%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody> <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT esm.*
                                                    FROM examinationscoremaster esm
                                                    INNER JOIN (
                                                        SELECT batchId, academicYear, MIN(semester) as minSem
                                                        FROM examinationscoremaster
                                                        WHERE resultStatus = 'PENDING'
                                                        GROUP BY batchId, academicYear
                                                    ) filtered
                                                    ON esm.batchId = filtered.batchId 
                                                    AND esm.academicYear = filtered.academicYear 
                                                    AND esm.semester = filtered.minSem
                                                    WHERE esm.resultStatus = 'PENDING'
                                                    ORDER BY esm.batchName, esm.academicYear, esm.semester
                                                ";
 // $sql = "SELECT es.examScoreMasterId,es.batchName,es.academicYear,es.semester,es.subjectName,esm.examScoreMasterId FROM examinationscore es INNER JOIN examinationscoremaster esm ON es.examScoreMasterId = esm.examScoreMasterId WHERE esm.resultStatus = 'PENDING' GROUP BY es.examScoreMasterId";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $examScoreMasterId = $row['examScoreMasterId'];
                                            echo "
                                                <tr class='tAC'>
                                                    <td> " . $row['batchName'] . "</td>
                                                    <td>" . $row['academicYear'] . "</td>
                                                    <td>SEMESTER-" . $row['semester'] . "</td>
                                                    <td>" . $row['subjectName'] . "</td>
                                                    <td class='project-actions'>
                                                        <a class='btn btn-primary btn-sm' href='#' onclick='addScore(this.id)' id = " . $examScoreMasterId . " title='click hear to add score'>
                                                            <i class='fas fa-user-edit'>
                                                            </i>
                                                        </a>
                                                    </td>
                                                </tr>";
                                        }
                                    }
                                    ?> </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="pendingResultEntry.js?v=<?php echo $fileVersion; ?>"></script>
<script>
var academicYearList = <?php echo json_encode($academicYearList) ?>;
var masterBatchDetails = <?php echo json_encode($masterBatchDetails) ?>;
var semester = <?php echo json_encode($semester); ?>;
$(function() {
    $('.select2').select2();
    $.fn.dataTableExt.afnFiltering.push(function(settings, data, dataIndex) {
        selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();
        selectedBatch = getSelectValues('', document.getElementById("filterBatchCode")).trim();
        selectedSemester = getSelectValues('', document.getElementById("semDropdown")).trim();
        var rowBatch = data[0].trim();
        var rowAcademicYear = data[1].trim();
        var rowSemester = data[2].trim();
        if (selectedAcademicYear != '') {
            inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ?
                rowAcademicYear : false;
        } else inStudAcademicYear = true;
        if (selectedBatch != '') {
            inBatch = (selectedBatch.indexOf(rowBatch) !== -1) ? rowBatch : false;
        } else inBatch = true;
        if (selectedSemester != '') {
            inSemester = (selectedSemester.indexOf(rowSemester) !== -1) ? rowSemester : false;
        } else inSemester = true;
        return inStudAcademicYear && inBatch && inSemester;
    });
    $("#pendingResultEntryTable").DataTable({
        "responsive": true,
        "autoWidth": false,
        "aLengthMenu": [
            [5, 10, 25, 50, 75, -1],
            [5, 10, 25, 50, 75, "All"]
        ],
        "pageLength": 20,
        "aaSorting": [],
    });
});
loadDataDropdown("filterAyear", academicYearList);
loadDataDropdown("filterBatchCode", masterBatchDetails);
loadDataDropdown("semDropdown", semester);
</script> <?php require '../../common/footer.php'; ?>