function calculateInlineStatus(studentId) {
    let total = 0;
    let passed = true;

    subjectScoreStructure.forEach(exam => {
        const examType = exam.examType;
        const input = document.getElementById(`score_${studentId}_${examType}`);
        let score = parseFloat(input.value) || 0;
        const maxMarks = parseFloat(exam.examTotalMarks);
        const passMarks = parseFloat(exam.examPassingMarks);

        // Clamp value and show alert if exceeding max marks
        if (score > maxMarks) {
            alert(`Score for ${examType} cannot exceed ${maxMarks}`);
            score = maxMarks;
            input.value = maxMarks; // Set input back to max
        }

        // Optional: Prevent negative input too
        if (score < 0) {
            alert(`Score for ${examType} cannot be negative`);
            score = 0;
            input.value = 0;
        }

        if (score < passMarks) {
            passed = false;
        }

        total += score;
    });

    document.getElementById(`total_${studentId}`).innerText = total.toFixed(2);
    document.getElementById(`status_${studentId}`).innerHTML = passed
        ? "<span class='badge badge-success'>PASS</span>"
        : "<span class='badge badge-danger'>FAIL</span>";
}


function saveScore() {
    const payload = [];

    studentList.forEach(student => {
        const studentId = student.studentId;
        const scores = {};
        let total = 0;
        let status = "PASS";

        for (let exam of subjectScoreStructure) {
            const examType = exam.examType;
            const maxMarks = parseFloat(exam.examTotalMarks);
            const passMarks = parseFloat(exam.examPassingMarks);

            const input = document.getElementById(`score_${studentId}_${examType}`);
            let score = parseFloat(input.value);
            if (isNaN(score)) score = 0;

            // Clamp value between 0 and max
            score = Math.max(0, Math.min(score, maxMarks));

            if (score < passMarks) {
                status = "FAIL";
            }

            scores[examType] = score;
            total += score;
        }

        payload.push({
            studentId,
            scores,
            status,
            totalMarks: total,
            examScoreMasterId
        });
    });

    document.getElementById('saveBtn').disabled = true;
    document.getElementById('successMessage').innerText = "";
    document.getElementById('errorMessage').innerText = "";

    fetch('update.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(payload)
    })
    .then(res => res.json())
    .then(response => {
        if (response.success) {
            document.getElementById('successMessage').innerText = "Scores updated successfully!";
        } else {
            document.getElementById('errorMessage').innerText = response.message || "Something went wrong!";
        }
    })
    .catch(() => {
        document.getElementById('errorMessage').innerText = "Error updating scores.";
    })
    .finally(() => {
        document.getElementById('saveBtn').disabled = false;
    });
}
