<?php
session_start();
if (!isset($_SESSION['academicExecutiveLoginsuccessEdj']) || $_SESSION['academicExecutiveLoginsuccessEdj'] <= 0) {
    header('Location:../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';

$examScoreMasterList = [];
$subjectScoreStructure = [];
$subjectDetails = [];
$studentList = [];

if (isset($_GET['esmi'])) {
    $examScoreMasterId = base64_decode($_GET['esmi']);

    $sqlMaster = "SELECT * FROM examinationscoremaster WHERE examScoreMasterId = '$examScoreMasterId'";
    $resultMaster = $conn->query($sqlMaster);
    $scoreMasterRow = $resultMaster->fetch_assoc();

    if ($scoreMasterRow) {
        $examScoreMasterList[] = $scoreMasterRow;

        $subjectId = $scoreMasterRow['subjectId'];

        $sqlSubject = "SELECT * FROM subjects WHERE subjectId = '$subjectId'";
        $resultSubject = $conn->query($sqlSubject);
        while ($row = $resultSubject->fetch_assoc()) {
            $subjectDetails[] = $row;
        }

        $sqlStructure = "SELECT * FROM subjectscore WHERE subjectId = '$subjectId'  AND deleted_at IS NULL";
        $resultStructure = $conn->query($sqlStructure);
        while ($row = $resultStructure->fetch_assoc()) {
            $subjectScoreStructure[] = $row;
        }

        $batchId = $scoreMasterRow['batchId'];
        $batchName = $scoreMasterRow['batchName'];

        $sqlStudents = "SELECT * FROM loginstudents WHERE batchId = '$batchId'";
        $resultStudents = $conn->query($sqlStudents);
        while ($student = $resultStudents->fetch_assoc()) {
            $studentList[] = [
                'studentId' => $student['studentId'],
                'rollNo' => $student['rollNo'],
                'firstname' => $student['firstname'],
                'lastname' => $student['lastname']
            ];            


        }
    }
}

require '../../common/header.php';
require '../../common/navbar.php';
?> <div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-3">
                                    <label>Result ID</label>
                                    <input type="text" class="form-control tAC" id="examScoreMasterId"
                                        value="<?= $examScoreMasterList[0]['examScoreMasterId'] ?? '' ?>" disabled>
                                </div>
                                <div class="col-md-3">
                                    <label>Academic Year</label>
                                    <input type="text" class="form-control tAC" id="academicYear"
                                        value="<?= $examScoreMasterList[0]['academicYear'] ?? '' ?>" disabled>
                                </div>
                                <div class="col-md-3">
                                    <label>Batch</label>
                                    <input type="text" class="form-control tAC" id="batchName"
                                        value="<?= $examScoreMasterList[0]['batchName'] ?? '' ?>" disabled>
                                </div>
                                <div class="col-md-3">
                                    <label>Semester</label>
                                    <input type="text" class="form-control tAC" id="semester"
                                        value="<?= 'SEMESTER-' . ($examScoreMasterList[0]['semester'] ?? '') ?>"
                                        disabled>
                                </div>
                            </div>
                            <div class='row'>
                                <div class="col-md-6">
                                    <label>Subject</label>
                                    <input type="text" class="form-control tAC" id="subjetName"
                                        value="<?= $examScoreMasterList[0]['subjectName'] ?? '' ?>" disabled>
                                </div>
                                <div class="col-md-3">
                                    <label>Result Status</label>
                                    <select class="form-control custom-select" id="resultStatus">
                                        <option disabled>SELECT STATUS</option>
                                        <option value='PENDING'
                                            <?= ($examScoreMasterList[0]['resultStatus'] ?? '') == 'PENDING' ? 'selected' : '' ?>>
                                            PENDING</option>
                                        <option value='COMPLETED'
                                            <?= ($examScoreMasterList[0]['resultStatus'] ?? '') == 'COMPLETED' ? 'selected' : '' ?>>
                                            COMPLETED</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="scoreTable">
                                <thead id="scoreTableHeader"></thead>
                                <tbody id="scoreTableBody"></tbody>
                            </table>
                        </div>
                        <div class="card-footer tAC">
                            <p id='errorMessage' class="text-danger text-center"></p>
                            <p id='successMessage' class="text-success text-center"></p>
                            <span id="savedData"></span>
                            <input type="button" class="btn btn-primary" value="Save" onclick="saveScore()"
                                id="saveBtn" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
const subjectScoreStructure = <?= json_encode($subjectScoreStructure) ?>;
const subjectDetails = <?= json_encode($subjectDetails) ?>;
const studentList = <?= json_encode($studentList) ?>;
const examScoreMasterId = '<?= $examScoreMasterList[0]['examScoreMasterId'] ?? '' ?>';
const academicYear = '<?= $examScoreMasterList[0]['academicYear'] ?? '' ?>';
const batchId = '<?= $examScoreMasterList[0]['batchId'] ?? '' ?>';
const batchName = '<?= $examScoreMasterList[0]['batchName'] ?? '' ?>';
const semester = '<?= $examScoreMasterList[0]['semester'] ?? '' ?>';
const subjectId = '<?= $examScoreMasterList[0]['subjectId'] ?? '' ?>';
const subjectName = '<?= $examScoreMasterList[0]['subjectName'] ?? '' ?>';
</script>
<!-- JS & Dependencies -->
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="addScore.js?v=<?= time() ?>"></script>
<script src="addScore.js?v=<?= $fileVersion ?>"></script>
<script>
$(function() {
    addTableHeader();
    renderStudentRows(studentList); // ✅ now sourced from PHP correctly
    selectDropdownValue("resultStatus", '<?php echo $examScoreMasterList[0]['resultStatus']; ?>');
});
</script>
<script>
function selectDropdownValue(dropdownId, value) {
    let dropdown = document.getElementById(dropdownId);
    if (dropdown) {
        for (let i = 0; i < dropdown.options.length; i++) {
            if (dropdown.options[i].value === value) {
                dropdown.selectedIndex = i;
                break;
            }
        }
    }
}
</script> <?php require '../../common/footer.php'; ?>